<?php $__env->startSection('title', config('app.name').' || CheckOut'); ?>
<?php $__env->startSection('content'); ?>

<div id="check_out">
    <div class="container">
        <?php if( $is_iptv ): ?>
        <img id="logo" src="<?php echo e(asset('storage/'.\App\Models\Config::whereName('iptv_white_logo')->first()->value)); ?>" />
        <?php else: ?>
        <img id="logo" src="<?php echo e(asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)); ?>" />
        <?php endif; ?>
        <p class="sub_title">You are almost there</p>
        <div class="gray_elements">
            <span class="element">
                <i class="fa fa-shield"></i>
                SSL secured checkout
            </span>
            <span class="element">
                <i class="fa fa-life-ring"></i>
                24/7 support available
            </span>
            <span class="element">
                <i class="fa fa-credit-card-alt"></i>
                Payment option
            </span>
        </div>
        <div class="checkout_container">
            <div id="top_breadcrumb">
                <div class="breadcrumb_elements">
                    <span class="breadcrumb_element">
                        <i class="fa fa-circle-o"></i>
                        cart
                    </span>
                    <span class="divider"></span>
                    <span class="breadcrumb_element">
                        <i class="fa fa-circle"></i>
                        <?php echo e($is_iptv ? 'Checkout' : 'information'); ?>

                    </span>
                    <span class="divider"></span>
                    <span class="breadcrumb_element">
                        <i class="fa fa-circle-o"></i>
                        finish
                    </span>
                </div>
            </div>
        </div>
        <div class="checkout_container billing">
            <div class="row  d-flex justify-content-center <?php echo e($is_iptv ? 'd-flex justify-content-center' : ''); ?>">
                <?php if( !$is_iptv ): ?>
                <div class="col-md-5">
                    <div class="billing_box">
                        <h1>Shipping Details</h1>
                        <div class="order_details">
                            <div id="shipping_overlay" v-show="infos_saved"><i class="fa fa-check-circle-o"></i></div>
                            <form id="submit-payment" action="<?php echo e(route('payment.ok')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="customer_id" id="customer_id">
                                <input type="hidden" name="transaction_id" id="transaction_id">
                                <input type="hidden" name="paypal_email" id="paypal_email">
                                <div class="row">
                                    <div class="col-md-6 form-group">
                                        <label for="shipping_firstName">First Name <span class="required">*</span></label>
                                        <input type="text" class="form-control" id="shipping_firstName" name="shipping_firstName" placeholder="First Name">
                                        <div v-show="shipping_firstName_error" class="invalid-feedback"> {{shipping_firstName_error}} </div>
                                    </div>
                                    <div class="col-md-6 form-group">
                                        <label for="shipping_lastName">Last Name <span class="required">*</span></label>
                                        <input type="text" class="form-control" id="shipping_lastName" name="shipping_lastName" placeholder="Last Name">
                                        <div v-show="shipping_lastName_error" class="invalid-feedback"> {{shipping_lastName_error}} </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 form-group">
                                        <label for="shipping_country">Country <span class="required">*</span></label>
                                        <select name="shipping_country" id="shipping_country">
                                        </select>
                                        <div v-show="shipping_country_error" class="invalid-feedback"> {{shipping_country_error}} </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 form-group">
                                        <label for="shipping_streetAddress">Street Address <span class="required">*</span></label>
                                        <input type="text" class="form-control" id="shipping_streetAddress" name="shipping_streetAddress" placeholder="Street address">
                                        <div v-show="shipping_streetAddress_error" class="invalid-feedback"> {{shipping_streetAddress_error}} </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 form-group">
                                        <label for="shipping_city">City <span class="required">*</span></label>
                                        <input type="text" class="form-control" id="shipping_city" name="shipping_city" placeholder="City">
                                        <div v-show="shipping_city_error" class="invalid-feedback"> {{shipping_city_error}} </div>
                                    </div>
                                    <div class="col-md-12 form-group">
                                        <label for="shipping_postal_code">Postal Code <span class="required">*</span></label>
                                        <input type="text" class="form-control" id="shipping_postal_code" name="shipping_postal_code" placeholder="Postal code">
                                        <div v-show="shipping_postal_code_error" class="invalid-feedback"> {{shipping_postal_code_error}} </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 form-group">
                                        <label for="shipping_phone">Phone <span class="required">*</span></label>
                                        <input type="text" class="form-control" id="shipping_phone" name="shipping_phone" placeholder="Phone">
                                        <div v-show="shipping_phone_error" class="invalid-feedback"> {{shipping_phone_error}} </div>
                                    </div>
                                    <div class="col-md-12 form-group">
                                        <label for="shipping_emailAddress">Email address <span class="required">*</span></label>
                                        <input type="text" class="form-control" id="shipping_emailAddress" name="shipping_emailAddress" v-model="shipping_emailAddress" placeholder="E-mail">
                                        <div v-show="shipping_emailAddress_error" class="invalid-feedback"> {{shipping_emailAddress_error}} </div>
                                    </div>
                                </div>
                            </form>
                            <button id="save_details" class="btn btn-primary" @click="save_shipping_details" :disabled="save_btn_disabled">
                                <i :class="['fa', 'fa-circle-o-notch', 'fa-spin', { 'd-none': !loading }]"></i>
                                Save Details To Process Payment
                            </button>
                        </div>
                    </div>
                </div>
                <?php else: ?>
                <form id="submit-payment" action="<?php echo e(route('confirmRefOrder')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="order_id" id="order_id">
                    <input type="hidden" name="customer_id" id="customer_id">
                    <input type="hidden" name="transaction_id" id="transaction_id">
                    <input type="hidden" name="paypal_email" id="paypal_email">
                    <input type="hidden" name="first_name" id="first_name">
                    <input type="hidden" name="last_name" id="last_name">
                    <input type="hidden" name="country" id="country">
                </form>
                <?php endif; ?>
                <div class="col-md-6 <?php echo e($is_iptv ? 'orderBig' : ''); ?>">
                    <h1>Your Order <?php echo e($is_iptv ? 'N°'.$order_id : ''); ?></h1>
                    <div class="order_details">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th class="title" scope="col">product</th>
                                    <th class="title right" scope="col">subTotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th scope="row" class="prod_title"><?php echo e($item->name); ?></th>
                                    <td class="right">
                                        <span class="quantity">x<?php echo e($item->qty); ?></span>
                                        <span class="subtotal"><?php echo e($item->subtotal()); ?> $</span>
                                    </td>
                                </tr>
                                <?php if( $vod == 1 ): ?>
                                <tr>
                                    <th scope="row" class="prod_title">VOD ( Movies && Series )</th>
                                    <td class="right">
                                        <span class="subtotal"><?php echo e($vod_price); ?> $</span>
                                    </td>
                                </tr>
                                <?php endif; ?>
                                <?php if( $adult == 1 ): ?>
                                <tr>
                                    <th scope="row" class="prod_title">Adult Channels</th>
                                    <td class="right">
                                        <span class="subtotal"><?php echo e($adult_price); ?> $</span>
                                    </td>
                                </tr>
                                <?php endif; ?>
                                <?php if( $prioritize == 1 ): ?>
                                <tr>
                                    <th scope="row" class="prod_title">Prioritize Orders Queue</th>
                                    <td class="right">
                                        <span class="subtotal"><?php echo e($prioritize_price); ?> $</span>
                                    </td>
                                </tr>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php if( !$is_iptv ): ?>
                        <table class="table">
                            <tbody>
                                <tr>
                                    <th scope="row">subtotal</th>
                                    <td class="right">
                                        <span class="subtotal">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <?php echo e(Cart::subtotal()); ?> $</span>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row">shipping</th>
                                    <td class="right">
                                        <span class="subtotal">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Free Shipping</span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>                        
                        <?php endif; ?>
                        <div class="total">
                            <span class="label">total</span>
                            <span class="value"><?php echo e($is_iptv ? Cart::total() + $adult_price + $vod_price + $prioritize_price : Cart::total()); ?> $</span>
                        </div>
                        
                        <?php if(!$is_iptv): ?><p class="privacy_policy">Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our <a target="_blank" href="<?php echo e(route('page', 'privacy-policy')); ?>">privacy policy</a>.</p><?php endif; ?>                        
                        <div id="paypal_box">
                            <span class="title">PayPal <small> ( Debit / Credit Cards ) </small></span>
                            <span class="paypal_box_container">
                                <div id="pay">
                                    <div id="paypal-button-container" v-show="payment_ui_enabled"></div>
                                    <div id="paypal-overlay" v-show="!payment_ui_enabled">
                                        <img src="<?php echo e(asset('paypal.png')); ?>" alt="">
                                    </div>
                                </div>
                            </span>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.3.1/axios.min.js" integrity="sha512-NbjaUHU8g0+Y8tMcRtIz0irSU3MjLlEdCvp82MqciVF4R2Ru/eaXHDjNSOvS6EfhRYbmQHuznp/ghbUvcC0NVw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://www.paypal.com/sdk/js?client-id=<?php echo e($client_id); ?>"></script>
<?php if( env('APP_ENV') == 'local' ): ?>
<script src="<?php echo e(asset('js/vue.js')); ?>"></script>
<?php else: ?>
<script src="<?php echo e(asset('js/vue.min.js')); ?>"></script>
<?php endif; ?>
<script>
    new Vue({
        el: '#check_out',
        data: {
            ref: <?php echo e($is_iptv ? 'true' : 'false'); ?>,
            payment_ui_enabled: <?php echo e($is_iptv ? 'true' : 'false'); ?>,
            loading: false,
            infos_saved: false,
            save_btn_disabled: false,
            shipping_firstName_error: '',
            shipping_lastName_error: '',
            shipping_country_error: '',
            shipping_streetAddress_error: '',
            shipping_city_error: '',
            shipping_postal_code_error: '',
            shipping_phone_error: '',
            shipping_emailAddress_error: '',

        },
        methods: {
            renderPayPal() {
                var self = this
                paypal.Buttons({
                    createOrder: function(data, actions) {
                        return actions.order.create({
                            purchase_units: [{
                                amount: {
                                    value: <?php echo e($is_iptv ? Cart::total() + $adult_price + $vod_price + $prioritize_price : Cart::total()); ?>

                                }
                            }]
                        });
                    },
                    onApprove: function(data, actions) {
                        return actions.order.capture().then(function(details) {

                            if(  details.status == "COMPLETED"  ) {

                                if(self.ref) {
                                    document.getElementById('order_id').value = <?php echo e($order_id ? $order_id : rand(200,1000)); ?>

                                    document.getElementById('first_name').value = details.payer.name.given_name
                                    document.getElementById('last_name').value = details.payer.name.surname
                                    document.getElementById('country').value = details.purchase_units[0].shipping.address.country_code
                                }else {
                                    var shipping_firstName = document.getElementById('shipping_firstName').value
                                    var shipping_lastName = document.getElementById('shipping_lastName').value
                                    var shipping_country = document.getElementById('shipping_country').value
                                    var shipping_streetAddress = document.getElementById('shipping_streetAddress').value
                                    var shipping_city = document.getElementById('shipping_city').value
                                    var shipping_postal_code = document.getElementById('shipping_postal_code').value
                                    var shipping_phone = document.getElementById('shipping_phone').value
                                    var shipping_emailAddress = document.getElementById('shipping_emailAddress').value

                                    if( shipping_firstName == '' ) document.getElementById('shipping_firstName').value = details.payer.name.given_name
                                    if( shipping_lastName == '' ) document.getElementById('shipping_lastName').value = details.payer.name.surname
                                    if( shipping_country == '' ) document.getElementById('shipping_country').value = details.purchase_units[0].shipping.address.country_code
                                    if( shipping_streetAddress == '' ) document.getElementById('shipping_streetAddress').value = details.purchase_units[0].shipping.address.address_line_1
                                    if( shipping_city == '' ) document.getElementById('shipping_city').value = details.purchase_units[0].shipping.address.admin_area_2
                                    if( shipping_postal_code == '' ) document.getElementById('shipping_postal_code').value = details.purchase_units[0].shipping.address.postal_code
                                    if( shipping_phone == '' ) document.getElementById('shipping_phone').value = '+49009960099'
                                    if( shipping_emailAddress == '' ) document.getElementById('shipping_emailAddress').value = 'xxx@xxx.com'
                                }
                                document.getElementById('customer_id').value = details.payer.payer_id
                                document.getElementById('transaction_id').value = details.purchase_units[0].payments.captures[0].id
                                document.getElementById('paypal_email').value = details.payer.email_address

                                $('form#submit-payment').submit()
                            }else alert("Payment declined");
                        });
                    },
                    onClick: function(data, actions) {
                        
                        console.log(actions)

                    },
                    onCancel: () => {
                        alert('Payment Cancelled!!')
                    }
                }).render('#paypal-button-container')
            },
            save_shipping_details() {
                if( !this.infos_saved ) {

                    this.shipping_firstName_error = ''
                    this.shipping_lastName_error = ''
                    this.shipping_country_error = ''
                    this.shipping_streetAddress_error = ''
                    this.shipping_city_error = ''
                    this.shipping_postal_code_error = ''
                    this.shipping_phone_error = ''
                    this.shipping_emailAddress_error = ''

                    if( document.getElementById('shipping_firstName').value == '') {
                        this.shipping_firstName_error = 'First Name Required'
                    }

                    if( document.getElementById('shipping_lastName').value == '') {
                        this.shipping_lastName_error = 'Last Name Required'
                    }

                    if( document.getElementById('shipping_country').value == '') {
                        this.shipping_country_error = 'Country is Required'
                    }

                    if( document.getElementById('shipping_streetAddress').value == '') {
                        this.shipping_streetAddress_error = 'Street Address is Required'
                    }

                    if( document.getElementById('shipping_city').value == '') {
                        this.shipping_city_error = 'City is Required'
                    }
                    
                    if( document.getElementById('shipping_postal_code').value == '') {
                        this.shipping_postal_code_error = 'Post Code is Required'
                    }

                    if( document.getElementById('shipping_phone').value == '') {
                        this.shipping_phone_error = 'Phone Number is Required'
                    }

                    if( document.getElementById('shipping_emailAddress').value == '') {
                        this.shipping_emailAddress_error = 'Email Address is Required'
                    }

                    if( !this.shipping_firstName_error && !this.shipping_lastName_error && !this.shipping_country_error &&
                        !this.shipping_streetAddress_error && !this.shipping_city_error && !this.shipping_postal_code_error &&
                        !this.shipping_phone_error && !this.shipping_emailAddress_error
                    ) {
                        var self = this
                        this.input_ui_enabled = false
                        this.loading = true    
                        setInterval(function () {
                            self.payment_ui_enabled = true
                            self.loading = false
                            self.save_btn_disabled = true
                            self.infos_saved = true
                        }, 1000)
                    }
                }
            }
        },
        mounted() {
            this.renderPayPal()
            axios.get("https://restcountries.com/v2/all").then(data => {
                var countries = data.data
                var html = ''
                for( var i = 0; i < countries.length; i++ ) {
                    html += '<option value="'+countries[i]['alpha2Code']+'">'+countries[i]['name']+'</option>'
                }
                $('select#shipping_country').html(html)
            })
           $('select#shipping_country').select2({ width: '100%' })
        },

    })

</script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>

div#check_out {
    text-align: center;
    padding: 33px 24px;
}

div#check_out img#logo {
    width: 166px;
    margin: 20px;
}

select#country {
    display: block;
}

p.sub_title {
    font-size: 34px;
    font-weight: 500;
    color: #c6c6c6;
}

.gray_elements {
    color: #eee;
}

.gray_elements span.element {
    padding: 12px 10px;
    display: inline-block;
}

span.divider {
    display: inline-block;
    width: 80px;
    background: #dadada;
    height: 1px;
    border-radius: 3px;
    margin: 4px 17px;
}

.breadcrumb_elements span.breadcrumb_element {
    color: #fbfbfb;
    font-size: 15px;
    text-transform: capitalize;
    font-weight: 500;
}

.checkout_container {
    background: #030e2e6b;
    padding: 21px 0;
    border-radius: 10px;
    margin: 22px 0;
}

.checkout_container.billing {
    text-align: left;
    padding: 68px 46px;
}

.checkout_container.billing h1 {
    font-size: 18px;
    margin-bottom: 28px;
    text-align: center;
    color: #c7c7c7;
}

.checkout_container.billing label {
    color: #e7e7e7;
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 7px;
    margin-left: 2px;
}

.checkout_container.billing .form-control, .checkout_container.billing .form-control:focus {
    background: #ffffff2b;
    color: white;
    border: none;
    box-shadow: none;
    padding: 8px 12px;
    border-radius: 2px;
    font-size: 14px;
}

.checkout_container.billing .form-group {
    margin-bottom: 22px;
}

span.select2-selection.select2-selection--single, .select2-container--default.select2-container--disabled .select2-selection--single {
    background: #ffffff2b;
    border: none;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: white;
    font-weight: 500;
    font-size: 15px;
}

.table th {
    text-transform: capitalize;
}

.checkout_container.billing tr, .checkout_container.billing th {
    border-top: hidden;
    border-bottom: 1px dashed #b4b4b4;
}

.table>tbody>tr>td,
.table>tbody>tr>th {
    border-top: none;
    border-bottom: none;
}

table.table {
    margin: 0;
}

.table>tbody>tr>td span.subtotal {
    color: yellow;
    font-size: 15px;
    font-weight: 600;
}

.table>tbody>tr>td span.quantity {
    color: #dfd9d9;
    font-size: 14px;
    margin-right: 4px;
}

th.title {
    font-size: 14px;
    color: #a2a2a2;
}

div#paypal_box {
    background: #ffffff1a;
    padding: 16px 16px;
    color: white;
    margin-bottom: 15px;
    border-radius: 10px;
    box-shadow: 0 0 2px #161d62;
}

div#paypal_box span.title {
    font-weight: 700;
}

div#paypal_box span.paypal_box_container {
    display: block;
    margin: 0;
    position: relative;
    margin-top: 20px;
}

div#paypal_box span.paypal_box_container p {
    margin: 0;
    padding: 0;
    color: #dedede;
    font-size: 14px;
}

div.billing_box {
    padding: 0 7px;
    position: relative;
}

p.privacy_policy {
    color: white;
    font-size: 13px;
    margin: 26px 0;
}

p.privacy_policy a {
    color: #00ceec;
    font-weight: 500;
    text-transform: capitalize;
}

div#paypal-button-container, div#paypal-overlay {
    width: 100%;
    background: #f4f4f4;
    padding: 28px 58px 3px;
    border-radius: 3px;
}

.checkout_container.billing label span.required {
    color: rgb(254, 16, 16);
}

div#paypal-overlay img {
    width: 38%;
    padding: 21px 0;
}

div#paypal-overlay {
    text-align: center;
    background: #061132;
}

button#save_details {
    background: green;
    box-shadow: none;
    border: none;
    border-radius: 13px;
    font-weight: 600;
    font-size: 14px;
    padding: 7px 21px;
}

div#shipping_overlay {
    width: 100%;
    height: 100%;
    background: #061132c9;
    position: absolute;
    top: 0;
    left: 0;
    z-index: 9999;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 43px;
    color: #b7b7b7ab;
}

.order_details {
    background: #ffffff0a;
    box-shadow: 0px 0px 5px #10004a9e;
    padding: 32px 25px;
    position: relative;
}

.total .label {
    display: block;
    font-weight: 600;
    text-transform: uppercase;
    color: #cecccc;
    text-align: center;
    font-size: 14px;
}

.total .value {
    font-size: 22px;
    font-weight: 800;
    color: #59ff00;
    text-align: center;
    display: block;
}

.orderBig h1 {
    font-size: 29px!important;
    font-weight: 800;
    text-transform: uppercase;
}

.orderBig th {
    font-weight: 800;
    font-size: 17px;
}

.total {
    padding: 23px 0;
    background: #ffffff14;
}

.orderBig div#paypal_box {
    margin-bottom: 5px;
    margin-top: 27px;
}

.orderBig th.prod_title {
    color: white;
    font-size: 14px;
    padding-bottom: 17px;
    font-weight: 500;
}

td.right {
    text-align: right;
}

.checkout_container.billing th.title.right {
    text-align: right;
}

@media (max-width: 768px) {
    .checkout_container.billing h1 {
        margin-top: 28px;
    }
    
    th[scope="row"] {
        width: 60%;
    }

    span.divider {
        width: 20px;
    }

    .gray_elements span.element {
        font-size: 13px;
    }

    div#paypal-button-container, div#paypal-overlay {
        padding: 15px 4px!important;
    }

    .order_details {
        background: none;
        box-shadow: none;
        padding: 0
    }

}




</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/hostovip.co.uk/resources/views/checkout.blade.php ENDPATH**/ ?>