<?php $__env->startSection('title', config('app.name').' || '.$product->title); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <div id="product">
        <?php if(session()->has('error')): ?>
        <div class="alert alert-danger" role="alert">
            <?php echo e(session()->get('error')); ?>

        </div>
        <?php endif; ?>
        <div class="row">
            <div class="poster col-md-5">
                <img src="<?php echo e(asset('storage/'.$product->poster)); ?>" alt="<?php echo e($product->title); ?>" title="<?php echo e($product->title); ?>">
            </div>
            <div class="col-md-6">
                <?php if(auth()->guard()->check()): ?>
                <a href="<?php echo e(route('admin.product_edit', $product->id)); ?>"><i class="fa fa-pencil"></i></a>
                <?php endif; ?>
                <h1 title="<?php echo e($product->title); ?>" class="title"><?php echo e($product->title); ?></h1>
                <div class="price_section">
                    <span class="price"><?php echo e($product->price); ?>$</span>
                    <span class="old_price"><?php echo e($product->old_price); ?>$</span>
                </div>
                <?php if($product->in_stock == "1"): ?>
                <div class="quantity col-md-3">
                    <i class="increase_q fa fa-minus"></i>
                    <input type="number" name="quantity" class="quantity_value" value="1">
                    <i class="decrease_q fa fa-plus"></i>
                </div>
                <?php endif; ?>
                <?php if($product->in_stock == "0"): ?>
                <span class="sold_out"><i class="fa fa-close"></i> sold out</span>
                <?php else: ?>
                <button type="button" class="order_btn animate__animated animate__pulse col-md-7">order now</button>
                <?php endif; ?>
                <ul class="box-under">
                    <li>
                        <i class="fa fa-cloud-download"></i>
                        <p>Digital Download</p>
                    </li>
                    <li>
                        <i class="fa fa-eye"></i>
                        <p>Instant Access</p>
                    </li>
                    <li>
                        <i class="fa fa-lock"></i>
                        <p>Secure Payment</p>
                    </li>
                    <li>
                        <i class="fa fa-modx"></i>
                        <p>100% Guaranteed</p>
                    </li>
                    <li>
                        <i class="fa fa-medium"></i>
                        <p>Free Shipping</p>
                    </li>
                    <li class="category">
                        <span class="name">Category :</span>
                        <a href="<?php echo e(route('category', $product->category->slug)); ?>"><?php echo e($product->category->name); ?></a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <div id="description">
        <?php echo $product->description; ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script>
    var app_env = '<?php echo e(env('APP_ENV')); ?>'
    $(document).ready(() => {
        $('i.increase_q').on('click', () => {
            const old_value = parseInt($('input.quantity_value').val())
            if( old_value > 1 ) {
                $('input.quantity_value').val(old_value - 1)
            }
        })

        $('i.decrease_q').on('click', () => {
            const old_value = parseInt($('input.quantity_value').val())
            if( old_value < 3 ) {
                $('input.quantity_value').val(old_value + 1)
            }
        })

        $('.order_btn').click(function() {
            var url = "<?php echo e(route('cart.store', [ 'id' => $product->id ])); ?>"
            // var url = "<?php echo e(route('cart.store', [ 'id' => 1 ])); ?>"
            if(app_env == 'production') {
                url = url.replace('http://', 'https://')
            }
            var qty = parseInt($('input.quantity_value').val())
            if( qty <= 3 ) {
                if( qty >= 1 ) {
                    window.location.href = url+"&q="+qty
                }else alert('You Can Order Only 3 items Maximum')
            }else alert('You Can Order Only 3 items Maximum')
        })
        $(".alert-danger").fadeTo(2000, 1000).slideUp(1000, function(){
            $(".alert-danger").slideUp(1000);
        });
    })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/buygympack.com/resources/views/product.blade.php ENDPATH**/ ?>