@extends('layouts.app')
@section('title', config('app.name').' || Contact Us')
@section('extra_css')
<style>
.h-captcha {
    margin-top: 25px;
}
label {
    color: rgb(187, 187, 187);
    font-size: 14px
}
</style>
@endsection
@section('content')
<div class="container">
    <div id="contact-us">
        @if (session('success'))
        <div class="sent">
            <i class="fa fa-check-circle"></i>
            <p class="message-sent">{{session('success') }}</p>
        </div>
        @else
        <h1>Contact Us</h1>
        <form method="POST">
            @if($errors->any())
            <ul>
                @foreach ($errors->all() as $error)
                <li>{{$error}}</li>
                @endforeach
            </ul>
            @endif
            @csrf
            <div class="my-2">
                <label for="email">Email</label>
                <input id="email" type="email" name="email" class="form-control" placeholder="Email" required>
            </div>
            <div class="my-2">
                <label for="subject">Subject</label>
                <input id="subject" type="text" name="subject" class="form-control" placeholder="Subject">
            </div>
            <div class="my-2">
                <label for="message">Message</label>
                <textarea id="message" name="message" class="form-control" rows="7" placeholder="Message"></textarea>
            </div>
            {!! app('captcha')->display() !!}
            <button type="submit" class="send_message">Send</button>
        </form>
        @endif
    </div>
</div>
@endsection