@extends('layouts.adminapp')
@section('extra_css')
<style>

</style>
@endsection
@section('title', 'Product N° '.$product->id)
@section('content')
<div class="form-head d-flex mb-3 mb-lg-5 align-items-start">
    <a href="{{route('admin.products')}}" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
 </div>
<div class="card card-default color-palette-box admin_product">
    @if( session()->has('success') )
    <span class="badge bg-success"> {{session()->get('success')}} </span>
    @endif
    <div class="card-body">
        <a href="{{route('product', $product->slug)}}" target="_blank" class="show_product_admin btn btn-success"><i class="fa fa-eye"></i>Show Product</a>
        <form action="{{route('admin.product_update')}}" method="POST" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="id" value="{{$product->id}}">
            <div class="row">
                <div class="mb-3 col-md-9">
                    <label for="title" class="form-label">Title</label>
                    <input type="text" name="title" class="form-control" placeholder="title" id="title" value="{{$product->title}}">
                </div>
                <div class="col-md-2 select">
                    <label for="visibility" class="form-label">Visible</label>
                    <select name="visibility">
                        <option value="0" @if($product->visibility == 0) selected @endif> NO </option>
                        <option value="1" @if($product->visibility == 1) selected @endif> YES </option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="mb-3 col-md-6">
                    <label for="slug" class="form-label">Slug</label>
                    <input type="text" name="slug" class="form-control" id="slug" placeholder="slug" value="{{$product->slug}}">
                </div>
                <div class="mb-3 col-md-6">
                    <label for="short_title" class="form-label">Short Title</label>
                    <input type="text" name="short_title" class="form-control" id="short_title" value="{{$product->short_title}}">
                </div>
            </div>
            <div class="row">
                <div class="mb-3 col-md-2">
                    <label for="price" class="form-label">Price</label>
                    <input type="text" name="price" class="form-control" id="price" value="{{$product->price}}">
                </div>
                <div class="col-md-3 select">
                    <label for="category" class="form-label">Category</label>
                    <select name="category_id">
                        @foreach($categories as $category)
                        <option value="{{$category->id}}" @if($category->id == $product->category_id) selected @endif>{{$category->name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 select">
                    <label for="hot" class="form-label">Hot</label>
                    <select name="hot">
                        <option value='1' {{ $product->hot == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $product->hot == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-3 mb-3">
                    <label for="poster" class="form-label">Poster</label>
                    <input type="file" class="form-file-input form-control" name="poster" id="poster">
                </div>
                <div class="col-md-8">
                    <label for="tags" class="form-label">Tags</label>
                    <input type="text" name="tags" class="form-control" id="old_price" placeholder="tags ..." value="{{$product->tags}}">
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <label for="description" class="form-label">Description</label>
                    <textarea rows="30" class="ckeditor form-control" id="description" name="description">{{$product->description}}</textarea>
                </div>
            </div>
            <div class="mb-3">
                <button class="btn btn-primary" type="submit">Update</button>
            </div>
        </form>
    </div>
</div>
@endsection
@section('extra_js')
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script>
    $(document).ready(function () {
        $('.ckeditor').ckeditor();
        $(".badge.bg-success").fadeTo(2000, 500).slideUp(500, function(){
            $(".badge.bg-success").slideUp(500);
        });
    });
</script>
@endsection


@section('extra_css')
<style>
    textarea{
        color:black
    }
</style>
@endsection