@extends('layouts.adminapp')
@section('extra_css')
<link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css'>

<style>
a.badge.bg-success {
    padding: 4px 9px;
    font-size: 12px;
}
a.badge.bg-warning {
    padding: 3px 16px;
    font-weight: 600;
    font-size: 12px;
}
span.badge.bg-danger {
    color: white;
    font-weight: 600;
    padding: 7px 0;
    font-size: 14px;
}
div#send_order {
    background: #eee;
    padding: 6px 11px;
    border-radius: 10px;
}
.datepicker.datepicker-dropdown th.datepicker-switch, .datepicker.datepicker-dropdown th.next, .datepicker.datepicker-dropdown th.prev {
    color: white;
}
.datepicker .datepicker-switch:hover, .datepicker .next:hover, .datepicker .prev:hover, .datepicker tfoot tr th:hover {
    background: #1d1b1f;
} 
</style>
@endsection
@section('title', 'Order N° '.$order->id)
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="{{route('admin.orders')}}" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
</div>
<div class="card card-default color-palette-box">
    @if( session()->has('success') )
    <span class="badge bg-success"> {{session()->get('success')}} </span>
    @elseif( session()->has('error') )
    <span class="badge bg-danger"> {{session()->get('error')}} </span>
    @endif
    <div class="card-body table-responsive">
        <h2 class="order_total">Total : {{$order->billing_total}}$</h2>
        <h2 class="order_total">Order Date : {{$order->created_at->format('d-m-Y H:i')}}</h2>
        <h4></h4>
        <table class="table">
            <thead>
                <tr>
                    <th>transaction</th>
                    <th>customer</th>
                    <th>name</th>
                    <th>paypal email</th>
                    <th>refunded</th>
                    <th>paid</th>
                    <th>sent</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <th>{{$order->transaction_id}}</th>
                    <th>{{$order->customer_id}}</th>
                    <th>{{$order->billing_firstName.' '.$order->billing_lastName}}</th>
                    <th class="customer">{{$order->paypal_email}}</th>
                    <th>
                        <a href="{{route('admin.set_refunded', $order->id)}}" class="badge bg-{{ $order->refunded ? 'success' : 'warning' }}">
                            {{ $order->refunded ? 'Yes' : 'No' }}
                        </a>
                    </th>
                    <th>
                        <a href="{{route('admin.set_paid', $order->id)}}" class="badge bg-{{ $order->paid ? 'success' : 'warning' }}">
                            {{ $order->paid ? 'Yes' : 'Not Yet' }}
                        </a>
                    </th>
                    <th>
                        <a href="{{route('admin.set_sent', $order->id)}}" class="badge bg-{{ $order->sent ? 'success' : 'warning' }}">
                            {{ $order->sent ? 'Yes' : 'Not Yet' }}
                        </a>
                    </th>
                </tr>
            </tbody>
        </table>
        <h4>Details</h4>
        <div id="service">
            <form action="{{route('admin.order_update_service')}}" method="POST">
                @csrf
                <input type="hidden" name="id" value="{{$order->service->id}}">
                <div class="row">
                    <div class="col-md-3">
                        <label for="title">Period</label>
                        <input type="text" class="form-control" id="title" value="{{$order->service->title}}" disabled>
                    </div>
                    <div class="col-md-3">
                        <label for="activated">Activated</label>
                        <select name="activated" id="activated">
                            <option value="1" @if( $order->service->activated == 1 ) selected @endif>YES</option>
                            <option value="0" @if( $order->service->activated == 0 ) selected @endif>NO</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="activation_date">Activation Date</label> 
                        @if ($order->service->activation_date == NULL)
                        <input class="form-control" name="activation_date" type="text" id="activation_date" value="">                         
                        @else
                        <input class="form-control" name="activation_date" type="text" id="activation_date" value="{{$order->service->activation_date->format('d F, Y')}}">
                        @endif                        
                    </div>
                    <div class="col-md-3">
                        <label for="expiration_date">Expiration Date</label>
                        @if ($order->service->expiration_date == NULL)
                        <input class="form-control" name="expiration_date" type="text" id="expiration_date" value="">
                        @else
                        <input class="form-control" name="expiration_date" type="text" id="expiration_date" value="{{$order->service->expiration_date->format('d F, Y')}}">
                        @endif
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <label for="server_id">Server</label>
                        <select name="server_id" id="server_id">
                            <option value="0">-</option>
                            @foreach (App\Models\Server::all() as $server)
                            <option value="{{$server->id}}" @if( $server->id == $order->service->server_id ) selected @endif>{{$server->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="host">Host</label>
                        <input type="text" class="form-control" id="host" name="host" value="{{$order->service->host}}">
                    </div>
                    <div class="col-md-3">
                        <label for="username">UserName</label>
                        <input type="text" class="form-control" id="username" name="username" value="{{$order->service->username}}">
                    </div>
                    <div class="col-md-3">
                        <label for="password">Password</label>
                        <input type="text" class="form-control" id="password" name="password" value="{{$order->service->password}}">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <label for="price">Price</label>
                        <input type="text" class="form-control" id="price" value="{{$order->service->price}} $" disabled>
                    </div>
                    <div class="col-md-3">
                        <label for="mac_address">Mac Address</label>
                        <input type="text" class="form-control" id="mac_address" name="mac_address" value="{{$order->service->mac_address}}">
                    </div>
                    <div class="col-md-3">
                        <label for="device_key">Device Key</label>
                        <input type="text" class="form-control" id="device_key" name="device_key" value="{{$order->service->device_key}}">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label for="m3u">M3U</label>
                        <input type="text" class="form-control" id="m3u" name="m3u" value="{{$order->service->m3u}}">
                    </div>
                    <div class="col-md-6">
                        <label for="epg">EPG</label>
                        <input type="text" class="form-control" id="epg" name="epg" value="{{$order->service->epg}}">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <label for="application_id">Application</label>
                        <select name="application_id" id="application_id">
                            @foreach (App\Models\Application::all() as $application)
                            <option value="{{$application->id}}" @if( $application->id == $order->service->application_id ) selected @endif>{{$application->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="device_id">Device</label>
                        <select name="device_id" id="device_id">
                            @foreach (App\Models\Device::all() as $device)
                            <option value="{{$device->id}}" @if( $device->id == $order->service->device_id ) selected @endif>{{$device->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="adult_content">Adult_content</label>
                        <select name="adult_content" id="adult_content">
                            <option value="0" @if( $order->adult_content == 0 ) selected @endif>No</option>
                            <option value="1" @if( $order->adult_content == 1 ) selected @endif>Yes</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="vod_content">VOD_content</label>
                        <select name="vod_content" id="vod_content">
                            <option value="0" @if( $order->vod_content == 0 ) selected @endif>No</option>
                            <option value="1" @if( $order->vod_content == 1 ) selected @endif>Yes</option>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 mb-4">
                        <label for="enigma_2">Enigma v2</label>
                        <input type="text" class="form-control" name="enigma_2" value="{{$order->service->enigma_2}}">
                    </div>
                    <div class="col-md-12">
                        <label for="enigma_16">Enigma v1.6</label>
                        <input type="text" class="form-control" name="enigma_16" value="{{$order->service->enigma_16}}">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <label for="notes">Notes</label>
                        <textarea class="form-control" name="notes" id="notes" cols="30" rows="10">{{$order->service->notes}}</textarea>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-success">Update</button>
                    </div>
                </div>
            </form>
        </div>
        @if ( $order->service->activated )
        <div id="send_order">
            <form action="{{route('admin.send_order')}}" method="POST">
                @csrf
                <input type="hidden" name="id" value="{{$order->id}}">
                <div class="row">
                    <div class="col-md-6">
                        <label for="email">Send Order Details</label>
                        <input type="email" class="form-control" name="email" value="{{$order->paypal_email}}">
                    </div>
                    <div class="col-md-6">
                        <button type="submit" class="btn btn-primary">Send</button>
                    </div>
                </div>
            </form>
        </div>
        @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script src='https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js'></script>
<script>
    $(document).ready(() => {
        $(".card>.badge.bg-success").fadeTo(2000, 500).slideUp(500, function(){
            $(".card>.badge.bg-success").slideUp(500);
        })
        $.fn.datepicker.defaults.format = "dd MM, yyyy"
        $('#activation_date').datepicker()
        $('#expiration_date').datepicker()
    })
</script>
@endsection