
<?php $__env->startSection('title', 'Servers'); ?>
<?php $__env->startSection('content'); ?>
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="<?php echo e(route('admin.server_insert')); ?>" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert New Server</a>
</div>
<div class="card card-default color-palette-box">
    <?php if( session()->has('success') ): ?>
    <span class="badge bg-success"> <?php echo e(session()->get('success')); ?> </span>
    <?php endif; ?>
    <div class="card-body">
        <?php if(count($servers) > 0): ?>
        <form method="POST" action="<?php echo e(route('admin.servers_update')); ?>">
            <?php echo csrf_field(); ?>
            <table class="table">
              <thead>
                <tr>
                    <th>id</th>
                    <th>name</th>
                    <th>line</th>
                    <th>mag</th>
                    <th></th>
                </tr>
            </thead>
                <tbody>
                <?php $__currentLoopData = $servers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $server): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="product-table">
                    <td>#<?php echo e($server->id); ?><input type="hidden" name="id[]" value="<?php echo e($server->id); ?>"></td>
                    <td><input class="form-control" type="text" name="name[]" value="<?php echo e($server->name); ?>"></td>
                    <td><input class="form-control" type="text" name="line[]" value="<?php echo e($server->default_line); ?>"></td>
                    <td><input class="form-control" type="text" name="mag[]" value="<?php echo e($server->default_mag); ?>"></td>
                    <td>
                      <div class="table_td">
                        <a class="remove_server" data-url="<?php echo e(route('admin.server_delete', $server->id)); ?>" href="#"><i class="fa fa-trash"></i></a>
                      </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <button class="btn btn-primary">Update</button>
        <form>
        <?php else: ?>
       <h3>No Categories</h3>
       <?php endif; ?>
    </div>
 </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script>
    $(document).ready(function() {
        $('a.remove_server').on('click', function(e) {
          e.preventDefault()
            var confirm = window.confirm('Sure ?');
            if(confirm) {
                window.location.href = $(this).data('url')
            }
        })
    })
</script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_css'); ?>
    <style>
      td.title {
        background: #eee;
        width: 100%;
        padding: 7px;
        display: inline-block;
        color: #333;
      }
      a.remove_server {
        background: red;
        color: white;
        width: 32px;
        height: 32px;
        text-align: center;
        padding: 4px;
        border-radius: 50%;
        font-size: 17px;
      }
      a.remove_server:hover {
        background: rgb(196, 0, 0);
        transition: 0.3s
      }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/subtvpack.com/resources/views/admin/servers.blade.php ENDPATH**/ ?>