<?php $__env->startSection('title', config('app.name').' || Channels List'); ?>
<?php $__env->startSection('extra_css'); ?>
<style>

span.no_channels {
  display: block;
  background: #ffffff17;
  font-weight: 500;
  font-size: 18px;
  text-align: center;
  padding: 17px 0;
  color: #fffe00;
  border-radius: 7px;
  text-transform: uppercase;
}

</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <div id="channels_list">
        <h1>Channels List</h1>
        <p>At <?php echo e(config('app.name')); ?> we offer you an access to more than 16.000 TV channels of all countries around the world<br>
          This list contains only the popular countries, All list will be available to you after having a Subscription.</p>
        <div class="channels_box" v-if="countries.length > 0 || channels.length > 0">
          <div class="row">
            <div class="col-md-3">
              <div class="box">
                <ul v-if="countries">
                  <li v-for="country in countries" @click="change_country(country.id)" :class="{active: country.id == selected_country}">{{country.name}}</li>
                </ul>
              </div>
            </div>
            <div class="col-md-9">
              <div class="box">
                <div class="search col-md-12 mx-auto">
                  <div class="input-group">
                    <input class="form-control" type="search" value="search" id="keyword" v-model="keyword" placeholder="Put channel name here">
                    <span class="input-group-append">
                      <button @click="getSearch" class="btn btn-outline-secondary bg-white border-bottom-0 border rounded-pill ms-n5" type="button">
                        <i class="fa fa-search"></i>
                      </button>
                    </span>
                  </div>
                </div>
                <ul v-if="loading" class="channels_section loading">
                  <i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
                </ul>
                <ul v-if="channels && !loading" class="channels_section">
                  <li v-for="channel in channels">{{channel.name}} <small v-if="channel.country">{{channel.country.name}}</small> </li>
                </ul>
              </div>
            </div>
          </div>
        </div>
        <span class="no_channels" v-else>No Channels Found</span>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<?php if( env('APP_ENV') == 'local' ): ?>
<script src="<?php echo e(asset('js/vue.js')); ?>"></script>
<?php else: ?>
<script src="<?php echo e(asset('js/vue.min.js')); ?>"></script>
<?php endif; ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.2.1/axios.min.js" integrity="sha512-zJYu9ICC+mWF3+dJ4QC34N9RA0OVS1XtPbnf6oXlvGrLGNB8egsEzu/5wgG90I61hOOKvcywoLzwNmPqGAdATA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>

var country_url = '<?php echo e(route('getCountryData', 0)); ?>'
var search_url = '<?php echo e(route('search', 0)); ?>'

<?php if( env('APP_ENV') == 'production' ): ?>
  country_url = country_url.replace('http://', 'https://')
  search_url = search_url.replace('http://', 'https://')
<?php endif; ?>

new Vue({
  el: 'div#channels_list',
  data: {
    countries: <?php echo $countries; ?>,
    channels: <?php echo $canals; ?>,
    selected_country: <?php echo e($channelsList_defaultCountry_id); ?>,
    keyword: '',
    loading: false
  },
  methods: {
    change_country(val) {
      this.keyword = ''
      this.loading = true
      this.channels = []
      this.selected_country = val
      axios.get( country_url.replace('/0', '/'+val) )
      .then(data => {
        setTimeout(() => {
          this.loading = false
          this.channels = data.data

          <?php if (app('mobile-detect')->isMobile() && !app('mobile-detect')->isTablet()) : ?>
          $('html, body').animate({
                scrollTop: $("#channels_list ul.channels_section").offset().top - 100
            }, 0);
          <?php endif; ?>

          jQuery('ul.channels_section').scrollTop(0)
        }, 300)
      })
    },
    getSearch() {
      jQuery('#channels_list .box ul li').first().siblings().removeClass('active')
      this.loading = true
      this.channels = []
      axios.get( search_url.replace('/0', '/'+this.keyword) )
      .then(data => {
        setTimeout(() => {
          this.loading = false
          this.channels = data.data
          jQuery('ul.channels_section').scrollTop(0)
        }, 300)
      })
    }
  },
  mounted() {
    // jQuery('#channels_list .box ul').scrollTo('#channels_list .box ul li.active');
    jQuery("#channels_list .box ul li.active").get(0).scrollIntoView({behavior: 'smooth'});
  }
})
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/channels_list.blade.php ENDPATH**/ ?>