<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" xmlns="http://www.w3.org/1999/xhtml" itemscope itemtype="http://schema.org/WebPage">
    <head prefix="og: http://ogp.me/ns# fb: http://ogp.me/ns/fb# article: http://ogp.me/ns/article#">
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2">
        <link rel="profile" href="http://gmpg.org/xfn/11">
        <link rel="shortcut icon" href="<?php echo e(asset('storage/'.\App\Models\Config::whereName('favicon')->first()->value)); ?>">
        <meta name="robots" content="noodp, noydir" />
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <meta name="description" content="<?php echo e(\App\Models\Config::whereName('seo_description')->first()->value); ?>">
        <style>
           <?php if( env('APP_ENV') == 'production' ): ?>
           <?php echo $__env->make('layouts.inc.css.app_min', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
           <?php else: ?>
           <?php echo $__env->make('layouts.inc.css.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
           <?php endif; ?>
        </style>
        <?php echo $__env->yieldContent('extra_css'); ?>
        <title><?php echo $__env->yieldContent('title'); ?></title>
        <?php if( \App\Models\Config::whereName('gads_tracking_enabled')->first()->value == 1 ): ?>            
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(\App\Models\Config::whereName('gads_tracking_tag')->first()->value); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', "<?php echo e(\App\Models\Config::whereName('gads_tracking_tag')->first()->value); ?>");
        </script>
        <?php endif; ?>
        <noscript><h3> You must have JavaScript enabled in order to use this order form. Please 
        enable JavaScript and then reload this page in order to continue. </h3> 
        <meta HTTP-EQUIV="refresh" content=0;url="javascriptNotEnabled.php"></noscript>
    </head>
    <body>
        <a id="whatsapp_button" href="<?php echo e(App\Models\Config::whereName('whatsapp_link')->first()->value); ?>" target="_blank"><i class="fa fa-whatsapp"></i><span> Chat With Us </span></a>
        <div id="header">
            <?php if( App\Models\Config::whereName('top_message_allowed')->first()->value == 1 ): ?>
            <div class="top-message">
                <?php echo e(App\Models\Config::whereName('top_message')->first()->value); ?>

            </div>
            <?php endif; ?>
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <a id="logo" class="nav-brand" href="<?php echo e(route('home')); ?>">
                        <img width="118" height="48" alt="<?php echo e(config('app.name').' - '.\App\Models\Config::whereName('website_description')->first()->value); ?>" src="<?php echo e(asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)); ?>">
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"><i class="fa fa-bars" aria-hidden="true"></i></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav top-menu me-auto mb-2 mb-lg-0">
                            <li><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li>
                                <a class="nav-item hvr-underline-from-center" href="<?php echo e(Route::currentRouteName() == 'home' ? '#subscribe' : route('subscriptions')); ?>">
                                    pricing
                                </a>
                            </li>
                            <?php if( App\Models\Config::whereName('trial_allowed')->first()->value == 1 ): ?>
                            <li><a class="nav-item hvr-underline-from-center" target="_blank" href="<?php echo e(App\Models\Config::whereName('whatsapp_link')->first()->value); ?>">12 HOURS TRIAL</a></li>
                            <?php endif; ?>
                            <li><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('how_to_install')); ?>">How To Install</a></li>
                            <li><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('channels_list')); ?>">Channels List</a></li>
                            <li><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('faq')); ?>">FAQ</a></li>
                            <li><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('contactus')); ?>">Contact Us</a></li>
                        </ul>
                        <div class="top-right-menu">
                            <ul>
                                <li>
                                    <div class="cta_btn">
                                        <a class="order_now_cta" href="<?php echo e(Route::currentRouteName() == 'home' ? '#subscribe' : route('subscriptions')); ?>"> Order Now </a>
                                     </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
        <?php echo $__env->yieldContent('content'); ?>
        <footer>
            <div class="container">
                <div class="row top_s">
                <div class="about_us col-md-4">
                    <a href="<?php echo e(route('home')); ?>">
                        <img width="118" height="48" alt="<?php echo e(\App\Models\Config::whereName('about_us')->first()->value); ?>" 
                        src="<?php echo e(asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)); ?>">
                    </a>
                    <p><?php echo e(\App\Models\Config::whereName('about_us')->first()->value); ?></p>
                    <img class="payments_img" width="300" height="99" src="<?php echo e(asset('cards.webp')); ?>" alt="payment methods">
                </div>
                <div class="col-md-4">
                    <div class="links">
                        <h3>helpful links</h3>
                        <a href="<?php echo e(route('channels_list')); ?>" class="hvr-underline-from-center">channels list</a>
                        <a href="<?php echo e(route('subscriptions')); ?>" class="hvr-underline-from-center">subscriptions</a>
                        <a href="<?php echo e(route('faq')); ?>" class="hvr-underline-from-center">Frequently Asked Questions</a>
                        <a href="<?php echo e(route('how_to_install')); ?>" class="hvr-underline-from-center">how to install</a>
                        <a href="<?php echo e(route('contactus')); ?>" class="hvr-underline-from-center">contact us</a>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="links">
                        <h3>pages</h3>
                        <?php $__currentLoopData = \App\Models\LegalPage::whereVisibility(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('page', $page->slug)); ?>" class="hvr-underline-from-center"><?php echo e($page->title); ?></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            </div>
            <div class="_footer">
                All Rights Are Reserved To <span class="colored"><?php echo e(config('app.name')); ?></span> <i class="fa fa-copyright" aria-hidden="true"></i> <?php echo e(\Carbon\Carbon::now()->year); ?>

            </div>
        </footer>
        <?php if( \App\Models\Config::whereName('gtag')->first()->value ): ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(\App\Models\Config::whereName('gtag')->first()->value); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', "<?php echo e(\App\Models\Config::whereName('gtag')->first()->value); ?>");
        </script>
        <?php endif; ?>


        
        <script>
        <?php if( env('APP_ENV') == 'production' ): ?>
        <?php echo $__env->make('layouts.inc.js.app_min', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php else: ?>
        <?php echo $__env->make('layouts.inc.js.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        </script>
    

        <?php echo $__env->yieldContent('extra_js'); ?>
        
    </body>
</html><?php /**PATH C:\xampp\htdocs\iptvca.io\resources\views/layouts/app.blade.php ENDPATH**/ ?>