<?php $__env->startSection('extra_css'); ?>
<link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css'>

<style>
a.badge.bg-success {
    padding: 4px 9px;
    font-size: 12px;
}
a.badge.bg-warning {
    padding: 3px 16px;
    font-weight: 600;
    font-size: 12px;
}
span.badge.bg-danger {
    color: white;
    font-weight: 600;
    padding: 7px 0;
    font-size: 14px;
}
div#send_order {
    background: #eee;
    padding: 6px 11px;
    border-radius: 10px;
}
.datepicker.datepicker-dropdown th.datepicker-switch, .datepicker.datepicker-dropdown th.next, .datepicker.datepicker-dropdown th.prev {
    color: white;
}
.datepicker .datepicker-switch:hover, .datepicker .next:hover, .datepicker .prev:hover, .datepicker tfoot tr th:hover {
    background: #1d1b1f;
}
h4._details_title {
    color: #024591;
    font-weight: 800;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title', 'Invoice N° '.$order->id); ?>
<?php $__env->startSection('content'); ?>
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="<?php echo e(route('admin.orders')); ?>" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
</div>
<div class="card card-default color-palette-box">
    <?php if( session()->has('success') ): ?>
    <span class="badge bg-success"> <?php echo e(session()->get('success')); ?> </span>
    <?php elseif( session()->has('error') ): ?>
    <span class="badge bg-danger"> <?php echo e(session()->get('error')); ?> </span>
    <?php endif; ?>
    <div class="card-body table-responsive">
        <label for=""><?php echo e($order->product->short_title); ?></label>
        <h2 class="order_total">Total : <?php echo e($order->total); ?>$</h2>
        <h2 class="order_total">Order Date : <?php echo e($order->created_at->format('d-m-Y H:i')); ?></h2>
        <h4 class="_details_title">Invoice</h4>
        <div id="order">
            <div class="row">
                <div class="actions">
                    <a href="<?php echo e(route('admin.set_sent', $order->id)); ?>" class="badge bg-<?php echo e($order->sent ? 'success' : 'warning'); ?>">
                        <?php echo e($order->sent ? 'Sent' : 'Not Sent'); ?>

                    </a>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label for="billing_email">Billing Email</label>
                    <input type="text" class="form-control" id="billing_email" value="<?php echo e($order->billing_email); ?>" disabled>
                </div>
                <div class="col-md-4">
                    <label for="billing_name">Billing Name</label>
                    <input type="text" class="form-control" id="billing_name" value="<?php echo e($order->billing_name); ?>" disabled>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <label for="notes">Notes</label>
                    <textarea class="form-control" id="notes" name="notes" disabled><?php echo e($order->notes); ?></textarea>
                </div>
            </div>
        </div>
        <div id="send_order">
            <form action="<?php echo e(route('admin.send_invoice_link')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" value="<?php echo e($order->id); ?>">
                <div class="row">
                    <div class="col-md-6">
                        <label for="email">Send Payment Link</label>
                        <input type="email" class="form-control" name="email" value="<?php echo e($order->billing_email); ?>">
                    </div>
                    <div class="col-md-6">
                        <button type="submit" class="btn btn-primary">Send</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
 </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script src='https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js'></script>
<script>
    $(document).ready(() => {
        $(".card>.badge.bg-success").fadeTo(2000, 500).slideUp(500, function(){
            $(".card>.badge.bg-success").slideUp(500);
        })
        $.fn.datepicker.defaults.format = "dd MM, yyyy"
        $('#activation_date').datepicker()
        $('#expiration_date').datepicker()
    })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/fullsubtv.com/resources/views/admin/invoice.blade.php ENDPATH**/ ?>