<?php $__env->startSection('title', 'Questions'); ?>
<?php $__env->startSection('content'); ?>
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="<?php echo e(route('admin.questions_insert')); ?>" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Question</a>
</div>
<div class="card card-default color-palette-box">
    <?php if( session()->has('success') ): ?>
    <span class="badge bg-success"> <?php echo e(session()->get('success')); ?> </span>
    <?php endif; ?>
    <div class="card-body table-responsive">
       <?php if(count($questions) > 0): ?>
       <table class="table">
        <thead>
          <tr>
            <th scope="col"></th>
            <th scope="col">Question</th>
            <th scope="col">Visibility</th>
            <th scope="col">Creation Date</th>
            <th scope="col"></th>
          </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr class="questions-table">
            <td><?php echo e($question->id); ?></td>
            <td><?php echo e($question->question); ?></td>
            <td>
              <span class="badge bg-<?php echo e($question->visibility == '1' ? 'success' : 'warning'); ?>">
                <?php echo e($question->visibility == '1' ? 'Visible' : 'Draft'); ?>

              </span>
            </td>
            <td><?php echo e($question->created_at); ?></td>
            <td class="actions">
              <a href="<?php echo e(route('admin.questions_edit', $question->id)); ?>"><i class="edit fa fa-pencil"></i></a>
              <a class="remove_question" data-id="<?php echo e($question->id); ?>" href="#"><i class="edit fa fa-trash"></i></a>
            </td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
       <?php else: ?>
       <h3>No Questions</h3>
       <?php endif; ?>
    </div>
 </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script>
$('.remove_question').on('click', function(e) {
        e.preventDefault()
        var confirmA = confirm('Delete The Question ?')
        var question_id = $(this).attr('data-id')
        var link = "<?php echo e(route('admin.questions_delete', 0)); ?>"
        if(confirmA) {
          window.location.href = link.replace('/0', '/'+question_id)
        }
      });
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>
    <style>
    tr.questions-table span.badge {
        padding: 4px;
        text-transform: uppercase;
        font-size: 11px;
    }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\fullsubtv.com\resources\views/admin/questions.blade.php ENDPATH**/ ?>