<?php $__env->startSection('extra_css'); ?>
<link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css'>
<link href="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote.min.css" rel="stylesheet">
<style>
a.badge.bg-success, span.badge.bg-success {
    padding: 4px 9px;
    font-size: 12px;
}
a.badge.bg-warning {
    padding: 3px 16px;
    font-weight: 600;
    font-size: 12px;
}
span.badge.bg-danger {
    color: white;
    font-weight: 600;
    padding: 4px 8px;
    font-size: 14px;
}
div#send_order {
    background: #f8f8f8;
    padding: 6px 11px;
    border-radius: 10px;
}
.datepicker.datepicker-dropdown th.datepicker-switch, .datepicker.datepicker-dropdown th.next, .datepicker.datepicker-dropdown th.prev {
    color: white;
}
.datepicker .datepicker-switch:hover, .datepicker .next:hover, .datepicker .prev:hover, .datepicker tfoot tr th:hover {
    background: #1d1b1f;
}

ul.time_infos {
    background: #f8f8f8;
    border-radius: 10px;
    margin: 11px 0;
}

ul.time_infos li {
    padding: 17px 25px;
    display: inline-block;
}

ul.time_infos li span.name {
    display: block;
    font-size: 11px;
    color: #4a4a4a;
    text-transform: uppercase;
    font-weight: 600;
    margin-bottom: 7px;
}

ul.time_infos li span.value {
    color: #027343;
    font-weight: 600!important;
    font-size: 13px;
}

div#connections {
    padding: 11px 0;
    display: flex;
    flex-direction: column;
}

div.tab-content {
    background: #f8f8f8;
    padding: 6px 0;
    border-radius: 0px 0 8px 8px;
}

div.tab-content .bootstrap-select .btn {
    background: white!important;
    color: #292929!important;
    font-weight: 500;
    padding: 9px 11px;
}
div.tab-content {
    position: relative;
    overflow: hidden;
}
div.tab-content .loader {
    position: absolute;
    width: 100%;
    display: none;
    justify-content: center;
    align-items: center;
    max-height: 100%;
    min-height: 100%;
    z-index: 2;
    background: #00000040;
    color: white;
    font-size: 10px;
}

.nav-tabs .nav-link.active {
    background: #333333;
    font-weight: 500;
    border-bottom: 1px solid #eee;
    color: white;
    border-radius: 6px 6px 0 0;
    text-transform: uppercase;
    font-size: 13px;
    padding: 9px 18px;
}

.nav-tabs .nav-link {
    border-radius: 4px 5px 0 0;
    font-size: 14px;
    text-transform: uppercase;
}

#subtype .dropdown.bootstrap-select {
    width: 80%!important;
}

.tox .tox-notification--warn, .tox .tox-notification--warning {
    display: none!important;
}

label.label_title {
    padding: 0 5px;
    margin: 0;
}


</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title', 'Order N° '.$order->id); ?>
<?php $__env->startSection('content'); ?>
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="<?php echo e(route('admin.orders')); ?>" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
</div>
<div class="card card-default color-palette-box">
    <?php if( session()->has('success') ): ?>
    <span class="badge bg-success"> <?php echo e(session()->get('success')); ?> </span>
    <?php elseif( session()->has('error') ): ?>
    <span class="badge bg-danger"> <?php echo e(session()->get('error')); ?> </span>
    <?php endif; ?>
    <div class="card-body table-responsive">
        <label class="label_title"><?php echo e($order->product->short_title); ?></label>
        <label class="label_title">
            <span class="badge bg-danger" style="text-transform: capitalize"><?php echo e($order->product->cnumber->category->name); ?></span>
        </label>
        <ul class="time_infos">
            <li>
                <span class="name">sending status</span>
                <span class="value">
                    <a href="<?php echo e(route('admin.set_sent', $order->id)); ?>" class="badge bg-<?php echo e($order->sent ? 'success' : 'warning'); ?>">
                        <?php echo e($order->sent ? 'Sent' : 'Not Sent'); ?>

                    </a>
                </span>
            </li>
            <li>
                <span class="name">renewing</span>
                <span class="value addon">
                    <span class="badge bg-<?php echo e($order->renewing ? 'success' : 'warning'); ?>"> <?php echo e($order->renewing == 1 ? 'YES' : 'NO'); ?></span>
                </span>
            </li>
            <li>
                <span class="name">adult</span>
                <span class="value addon">
                    <span class="badge bg-<?php echo e($order->adult ? 'success' : 'warning'); ?>"> <?php echo e($order->adult == 1 ? 'YES' : 'NO'); ?></span>
                </span>
            </li>
            <li>
                <span class="name">fast delivery</span>
                <span class="value addon">
                    <span class="badge bg-<?php echo e($order->fastdelivery ? 'success' : 'warning'); ?>"> <?php echo e($order->fastdelivery == 1 ? 'YES' : 'NO'); ?></span>
                </span>
            </li>
        </ul>
        
        <ul class="time_infos">
            <li>
                <span class="name">uuid</span>
                <span class="value"><?php echo e($order->uuid); ?></span>
            </li>
            <li>
                <span class="name">Paypal Business Account</span>
                <span class="value"><?php echo e($order->ppl_account); ?></span>
            </li>
            <li>
                <span class="name">gateway</span>
                <span class="value"><?php echo e($order->gateway); ?></span>
            </li>
            <li>
                <span class="name">total</span>
                <span class="value"><?php echo e($order->total.' '.$order->currency->code); ?></span>
            </li>
            <li>
                <span class="name">ordering date</span>
                <span class="value">
                    <span class="badge bg-dark"><?php echo e($order->created_at->format('F d, Y H:i')); ?></span>
                </span>
            </li>
            <li>
                <span class="name">payment date</span>
                <span class="value">
                    <span class="badge bg-dark"><?php echo e($order->payment_date->format('F d, Y H:i')); ?></span>
                </span>
            </li>
            <li>
                <span class="name">refunding status</span>
                <span class="value">
                    <a href="<?php echo e(route('admin.set_refunded', $order->id)); ?>" class="badge bg-<?php echo e($order->refunded ? 'success' : 'warning'); ?>">
                        <?php echo e($order->refunded ? 'Refunded' : 'Not Refunded'); ?>

                    </a>
                </span>
            </li>
            <li>
                <span class="name">payment status</span>
                <span class="value">
                    <a href="<?php echo e(route('admin.set_paid', $order->id)); ?>" class="badge bg-<?php echo e($order->paid ? 'success' : 'warning'); ?>">
                        <?php echo e($order->paid ? 'Paid' : 'Not Paid'); ?>

                    </a>
                </span>
            </li>
            <li>
                <span class="name">Transaction ID</span>
                <span class="value"><?php echo e($order->transaction_id); ?></span>
            </li>
            <li>
                <span class="name">Customer ID</span>
                <span class="value"><?php echo e($order->customer_id); ?></span>
            </li>
            <li>
                <span class="name">Paypal Email</span>
                <span class="value"><?php echo e($order->ppl_email); ?></span>
            </li>
            <li>
                <span class="name">Paypal Country</span>
                <span class="value"><?php echo e($order->ppl_country ? $order->ppl_country : 'none'); ?></span>
            </li>
            <li>
                <span class="name">Paypal Firstname</span>
                <span class="value"><?php echo e($order->ppl_firstName); ?></span>
            </li>
            <li>
                <span class="name">Paypal Lastname</span>
                <span class="value"><?php echo e($order->ppl_lastName); ?></span>
            </li>
        </ul>
        <?php if( count($order->connections) == 1 ): ?>
        <div class="row">
            <div class="col-md-6">
                <label for="label">Panel Label</label>
                <input type="text" class="form-control connection_label" id="label" value="<?php echo e($label); ?>">
            </div>
        </div>
        <?php endif; ?>
        <div id="connections">
            <?php if( count($order->connections) > 1 ): ?>
            <ul class="nav nav-tabs" id="myTab" role="tablist">
                <?php for( $i=1; $i <= count($order->connections); $i++ ): ?>
                <?php
                $selected_id = session()->has('selected_connection_id') ? session()->get('selected_connection_id') : $order->connections[0]->id;
                ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo e($selected_id == $order->connections[$i-1]->id ? 'active' : ''); ?>" id="tab-n<?php echo e($i); ?>" data-toggle="tab" href="#n<?php echo e($i); ?>" role="tab" aria-controls="n<?php echo e($i); ?>" aria-selected="true">Connection N° <?php echo e($i); ?></a>
                </li>
                <?php endfor; ?>
             </ul>
             <?php endif; ?>
             <div class="tab-content" id="myTabContent">
                <div class="loader"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
                <?php for( $i=1; $i <= count($order->connections); $i++ ): ?>
                <?php
                $selected_id = session()->has('selected_connection_id') ? session()->get('selected_connection_id') : $order->connections[0]->id;
                ?>
                <div class="tab-pane <?php echo e($selected_id == $order->connections[$i-1]->id ? 'fade show active' : ''); ?>" id="n<?php echo e($i); ?>" role="tabpanel" aria-labelledby="tab-n<?php echo e($i); ?>">
                    <div id="service">
                        <form action="<?php echo e(route('admin.update_connection')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="months_number" value="<?php echo e((int)$order->product->period); ?>">
                            <input type="hidden" name="id" value="<?php echo e($order->connections[$i-1]->id); ?>">
                            <div class="row">
                                <div class="col-md-6" id="subtype">
                                    <label style="display: block" for="subtype_id">Subscription Type</label>
                                    <select name="subtype_id" id="subtype_id">
                                        <option value="0">-</option>
                                        <?php $__currentLoopData = App\Models\Subtype::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subtype): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($subtype->id); ?>" <?php if( $subtype->id == $order->connections[$i-1]->subtype_id ): ?> selected <?php endif; ?>><?php echo e($subtype->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <?php if( count($order->connections) > 1 ): ?>
                                <div class="col-md-3">
                                    <label for="label">Connection Label</label>
                                    <input type="text" class="form-control connection_label" id="label" value="<?php echo e($label.' - conn'.$i); ?>">
                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <label for="server_id">Server</label>
                                    <select name="server_id" id="server_id">
                                        <option value="0">-</option>
                                        <?php $__currentLoopData = App\Models\Server::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $server): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                        $server_id = $order->connections[$i-1]->server_id == 0 ? $default_iptvServer : $order->connections[$i-1]->server_id;
                                        ?>
                                        <option value="<?php echo e($server->id); ?>" <?php if( $server->id == $server_id): ?> selected <?php endif; ?>><?php echo e($server->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="activation_date<?php echo e($i); ?>">Activation Date</label> 
                                    <?php if($order->connections[$i-1]->activation_date == NULL): ?>
                                    <input class="form-control" name="activation_date" type="text" id="activation_date<?php echo e($i); ?>" value="">                         
                                    <?php else: ?>
                                    <input class="form-control" name="activation_date" type="text" id="activation_date<?php echo e($i); ?>" value="<?php echo e($order->connections[$i-1]->activation_date->format('d F, Y')); ?>">
                                    <?php endif; ?>                        
                                </div>
                                <div class="col-md-3">
                                    <label for="expiration_date<?php echo e($i); ?>">Expiration Date</label>
                                    <?php if($order->connections[$i-1]->expiration_date == NULL): ?>
                                    <input class="form-control" name="expiration_date" type="text" id="expiration_date<?php echo e($i); ?>" value="">
                                    <?php else: ?>
                                    <input class="form-control" name="expiration_date" type="text" id="expiration_date<?php echo e($i); ?>" value="<?php echo e($order->connections[$i-1]->expiration_date->format('d F, Y')); ?>">
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <label for="host">Host</label>
                                    <input type="text" class="form-control" id="host" name="host" value="<?php echo e($order->connections[$i-1]->host); ?>">
                                </div>
                                <div class="col-md-3">
                                    <label for="username">UserName</label>
                                    <input type="text" class="form-control" id="username" name="username" value="<?php echo e($order->connections[$i-1]->username); ?>">
                                </div>
                                <div class="col-md-3">
                                    <label for="password">Password</label>
                                    <input type="text" class="form-control" id="password" name="password" value="<?php echo e($order->connections[$i-1]->password); ?>">
                                </div>
                                <div class="col-md-3">
                                    <label for="mac_address">Mac Address</label>
                                    <input type="text" class="form-control" id="mac_address" name="mac_address" value="<?php echo e($order->connections[$i-1]->mac_address); ?>">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <label for="m3u">M3U</label>
                                    <input type="text" class="form-control" id="m3u" name="m3u" value="<?php echo e($order->connections[$i-1]->m3u); ?>">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <label for="epg">EPG</label>
                                    <input type="text" class="form-control" id="epg" name="epg" value="<?php echo e($order->connections[$i-1]->epg); ?>">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 mb-4">
                                    <label for="enigma">Enigma</label>
                                    <textarea class="form-control" name="enigma" id="enigma" cols="30" rows="3"><?php echo e($order->connections[$i-1]->enigma); ?></textarea>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-success">Update Connection N° <?php echo e($i); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <?php endfor; ?>
            </div>
        </div>
        <form method="POST" action="<?php echo e(route('admin.update_order')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="id" value="<?php echo e($order->id); ?>">
            <div id="order">
                <div class="row">
                    <div class="col-md-4">
                        <label for="billing_email">Billing Email</label>
                        <input type="text" class="form-control" id="billing_email" name="billing_email" value="<?php echo e($order->billing_email); ?>">
                    </div>
                    <div class="col-md-4">
                        <label for="billing_name">Billing Name</label>
                        <input type="text" class="form-control" id="billing_name" name="billing_name" value="<?php echo e($order->billing_name); ?>">
                    </div>
                    <div class="col-md-4">
                        <label for="phone_number">Phone Number</label>
                        <input type="text" class="form-control" id="phone_number" name="phone_number" value="<?php echo e($order->phone_number); ?>">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label for="languages">Languages</label>
                        <input type="text" class="form-control" id="languages" name="languages" value="<?php echo e($order->languages); ?>">
                    </div>
                    <div class="col-md-6">
                        <label for="countries">Countries</label>
                        <input type="text" class="form-control" id="countries" name="countries" value="<?php echo e($order->countries); ?>">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <label for="notes">Notes</label>
                    <textarea class="form-control" rows="7" id="notes" name="notes"><?php echo e($order->notes); ?></textarea>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <a class="btn btn-primary" data-toggle="collapse" href="#collapseExample" role="button" aria-expanded="false" aria-controls="collapseExample">
                        Extra Mail Fields
                    </a>
                </div>
                <div class="col-12">
                    <div class="collapse" id="collapseExample">
                        <div class="col-md-12 mt-3">
                            <label for="extra_header">Extra Header Mail Html</label>
                            <textarea class="form-control" id="extra_header" name="extra_header"><?php echo e($order->extra_header); ?></textarea>
                        </div>
                        <div class="col-md-12 mt-3">
                            <label for="extra_footer">Extra Footer Mail Html</label>
                            <textarea class="form-control" id="extra_footer" name="extra_footer"><?php echo e($order->extra_footer); ?></textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12 mb-4">
                <button type="submit" class="btn btn-success">Update Order</button>
            </div>
        </form>
        <div id="send_order">
            <form action="<?php echo e(route('admin.send_order')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" value="<?php echo e($order->id); ?>">
                <div class="row">
                    <div class="col-md-6">
                        <label for="email">Send Order Details</label>
                        <input type="email" class="form-control" name="email" value="<?php echo e($order->billing_email); ?>">
                    </div>
                    <div class="col-md-6">
                        <button type="submit" class="btn btn-primary">Send</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
 </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script src='https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js'></script>
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote.min.js"></script>


<script>

    jQuery(document).ready(($) => {

        $('#service form').submit(function(e) {
            e.preventDefault()
            $('div.tab-content .loader').css('display', 'flex')
            url = $(this).attr('action')

            var dataString = $(this).serialize();

            console.log( dataString )

            $(this).find('input#host').val('')
            $(this).find('input#username').val('')
            $(this).find('input#password').val('')
            $(this).find('input#mac_address').val('')
            $(this).find('input#m3u').val('')
            $(this).find('input#epg').val('')
            $(this).find('textarea#enigma').val('')



            axios.post(url, dataString)
            .then(data => data.data)
            .then(data => {

                $(this).find('input#host').val(data.host)
                $(this).find('input#username').val(data.username)
                $(this).find('input#password').val(data.password)
                $(this).find('input#mac_address').val(data.mac_address)
                $(this).find('input#m3u').val(data.m3u)
                $(this).find('input#epg').val(data.epg)
                $(this).find('textarea#enigma').val(data.enigma)



                $('div.tab-content .loader').css('display', 'none')
            })

        })

        $('input.connection_label').on('click', function() {
            var copyText = $(this);
            copyText.select();
            document.execCommand('copy');
        })

        $('textarea#extra_header').summernote();
        $('textarea#extra_footer').summernote();

        
        $(".card>.badge.bg-success").fadeTo(2000, 500).slideUp(500, function(){
            $(".card>.badge.bg-success").slideUp(500);
        })
        $.fn.datepicker.defaults.format = "dd MM, yyyy"
        <?php for($i=1; $i <= count($order->connections);$i++): ?>
        $('#activation_date<?php echo e($i); ?>').datepicker()
        $('#expiration_date<?php echo e($i); ?>').datepicker()
        <?php endfor; ?>

        
    })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\fullsubtv.com\resources\views/admin/order.blade.php ENDPATH**/ ?>