<?php $__env->startSection('title', config('app.name').' || CheckOut'); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <div id="shopping-checkout">
        <h1>Checkout</h1>
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="customer-infos auth_container">
                    <div class="header">
                        <div>
                            <input type="radio" class="form-check-input" checked>
                            <span class="title">Order Details</span>
                        </div>
                    </div>
                    <div class="body">
                        </h2>
                        <form id="payform" method="POST" action="<?php echo e(route('payment.regular')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" id="customer_id" name="customer_id">
                            <input type="hidden" id="transaction_id" name="transaction_id">
                            <input type="hidden" id="ppl_firstName" name="ppl_firstName">
                            <input type="hidden" id="ppl_lastName" name="ppl_lastName">
                            <input type="hidden" id="ppl_email" name="ppl_email">
                            <input type="hidden" id="ppl_country" name="ppl_country">
                            <div class="row">
                                <?php if( $name ): ?>
                                <div class="col-md-4 mb-2 form-group">
                                    <label for="billing_name">Name</label>
                                    <input type="text" class="form-control" id="billing_name" placeholder="Put your name here" value="<?php echo e($name); ?>" disabled  >
                                </div>
                                <?php endif; ?>
                                <?php if( $email ): ?>
                                <div class="col-md-8 form-group">
                                    <label for="billing_email">email</label>
                                    <input type="text" class="form-control" id="billing_email" placeholder="Put your email here" value="<?php echo e($email); ?>" disabled>
                                </div>
                                <?php endif; ?>
                                <?php if( $notes ): ?>
                                <div class="col-md-12 form-group mb-3">
                                    <label for="notes">notes</label>
                                    <textarea class="form-control" id="notes" placeholder="Put your notes here" disabled><?php echo e($notes); ?></textarea>
                                </div>
                                <?php endif; ?>
                                <div class="row form-group">
                                <?php
                                $i = 1;
                                foreach (json_decode($connections) as $connection) {
                                    echo '<div class="info_item">';
                                    echo '<label for="connection'.$i.'">subscription type for connection n°'.$i.'</label>';
                                    foreach ($subtypes as $subtype) {
                                        if( $subtype->id == $connection->subtype ) {
                                            echo '<span>'.$subtype->title;
                                            if( $connection->mac_address->enabled ) echo ' <span class="mac">( '.$connection->mac_address->value.' )</span>';
                                            echo '</span>';
                                        }
                                    }
                                    $i++;
                                    echo '</div>';
                                }
                                ?>
                                </div>
                                <div class="col-md-8 mt-2 form-group">
                                    <a id="edit_configuration" class="btn btn-primary" href="<?php echo e(route('cart')); ?>"><i class="fa fa-pencil"></i> Edit Details</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <h1 class="payment_title">Payment</h1>
                <div class="customer-infos auth_container">
                    <div class="header">
                       <div>
                            <input type="radio" class="form-check-input" checked>
                            <span class="title">PayPal <small>( Credit / Debit Cards )</small>
                        </div>
                    </div>
                    <div class="body">
                        <div id="paypal-button-container"></div>
                    </div>
                 </div>
            </div>
            <div class="col-md-4">
                <div class="customer-infos summary">
                    <div class="header">
                        <span class="title">Summary</span>
                    </div>
                    <div class="body summary">
                        <span class="subtotal">
                            <?php echo e($product_title); ?>

                            <p><?php echo e(Cart::subtotal()); ?> <?php echo e($currency->symbol); ?></p>
                        </span>
                        <span class="subtotal" v-if="adult_enabled">
                            Adult Content
                            <p>{{adult_price}} <?php echo e($currency->symbol); ?></p>
                        </span>
                        <span class="subtotal" v-if="fastdelivery_enabled">
                            Fast Delivery
                            <p>{{fastdelivery_price}} <?php echo e($currency->symbol); ?></p>
                        </span>
                        <span class="subtotal">
                            Setup Fees
                            <p>0 <?php echo e($currency->symbol); ?></p>
                        </span>
                        <span class="total">
                            Total
                            <p>{{total}} <?php echo e($currency->symbol); ?></p>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<?php if( env('APP_ENV') == 'local' ): ?>
<script src="<?php echo e(asset('js/vue.js')); ?>"></script>
<?php else: ?>
<script src="<?php echo e(asset('js/vue.min.js')); ?>"></script>
<?php endif; ?>
<script src="https://www.paypal.com/sdk/js?client-id=<?php echo e($client_id); ?>&currency=<?php echo e($currency->code); ?>"></script>
<script>
    // Init;
    window.subtypes = <?php echo $subtypes; ?>

    window.adult_enabled = <?php echo e($adult); ?>

    window.adult_price = <?php echo e($adult_price); ?>


    window.fastdelivery_enabled = <?php echo e($fastdelivery); ?>

    window.fastdelivery_price = <?php echo e($fastdelivery_price); ?>


    window.subtotal = <?php echo e(Cart::subtotal()); ?>


    <?php if( env('APP_ENV') == 'local' ): ?>
    new Vue({
        el: '#shopping-checkout',
        data: {
            subtypes: window.subtypes,
            adult_enabled: window.adult_enabled,
            adult_price: window.adult_price,
            ppv_enabled: window.ppv_enabled,
            ppv_price: window.ppv_price,
            fastdelivery_enabled: window.fastdelivery_enabled,
            fastdelivery_price: window.fastdelivery_price,
            sub_total: window.subtotal
        },
        computed: {
            total() {
                const ttl = this.sub_total + this.adult_price + this.fastdelivery_price
                var num = Number(ttl)
                var roundedString = num.toFixed(2)
                return Number(roundedString)
            }
        },
        methods: {
            renderPaypal() {
                var self = this
                paypal.Buttons({
                    style: {
                        color: 'blue',
                        shape:  'pill',
                        label:  'paypal'
                    },
                    createOrder: function(data, actions) {
                        return actions.order.create({
                            purchase_units: [{
                                amount: {
                                    value: self.total,
                                }
                            }]
                        });
                    },
                    onApprove: function(data, actions) {
                        return actions.order.capture().then(function(details) {
                            if(  details.status == "COMPLETED"  ) {
                                document.getElementById('customer_id').value = details.payer.payer_id
                                document.getElementById('transaction_id').value = details.purchase_units[0].payments.captures[0].id
                                document.getElementById('ppl_firstName').value = details.payer.name.given_name
                                document.getElementById('ppl_lastName').value = details.payer.name.surname
                                document.getElementById('ppl_email').value = details.payer.email_address
                                document.getElementById('ppl_country').value = details.payer.address.country_code
                                $('form#payform').submit()
                            }else alert("Payment declined");
                        });
                    },
                    onClick: function(data, actions) {
                        
                        console.log(actions)
                    },
                    onCancel: () => {
                        alert('Payment Cancelled!!')
                    }
                }).render('#paypal-button-container')
            }
        },
        mounted() {
            this.renderPaypal()
        }
    })
    <?php else: ?>
    <?php echo $__env->make('layouts.inc.js.checkout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>
<style>

ul.right-menu, .top-message, ul.top-menu, footer, .navbar a.order_now, .navbar a.cart_number, .navbar-toggler, .cta_btn a{
    display: none!important;
}

.top-right-menu ul li .dropdown {
    display: none;
}
#shopping-checkout .customer-infos .header .email {
    color: #c9bdbd;
    padding: 6px;
    display: block;
    text-transform: capitalize
}
#shopping-checkout .customer-infos.summary .header {
    text-align: center;
}

.form-control::placeholder {
    color: rgb(185, 185, 185)!important;
    opacity: 1;
    text-transform: capitalize
}

.form-control:-ms-input-placeholder {
    color: rgb(158, 158, 158)!important;
}

.form-control::-ms-input-placeholder {
    color: rgb(158, 158, 158)!important;
}

label {
    color: #bebebe;
    font-weight: 600;
    text-transform: capitalize;
    font-size: 15px;
    margin-block: 4px;
}

button.btn.btn-success {
    font-weight: 600;
    font-size: 15px;
    text-transform: uppercase;
}

a#edit_configuration {
    background: #2f9c4f;
    border: none;
    font-weight: 600;
    text-transform: capitalize;
    padding: 5px 8px;
    font-size: 14px;
}

a#edit_configuration:hover {
    background: #22773c;
    transition: .3s
}

.info_item label {
    display: block;
    color: #eee;
    font-size: 14px;
    font-weight: 500;
}

.info_item {
    background: #eeeeee17;
    margin: 9px 13px;
    padding: 10px 11px;
    border-radius: 6px;
}

.info_item span {
    color: #95ee23;
    font-size: 15px;
    font-weight: 600;
}

.info_item span span.mac {
    color: #d8d801;
}

h1.payment_title {
    color: white;
    font-size: 21px;
    text-transform: uppercase;
    margin-top: 45px;
    display: block;
    font-weight: 800;
}

</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\buysubtv.com\resources\views/checkout.blade.php ENDPATH**/ ?>