<?php $__env->startSection('title', config('app.name').' - '.$title); ?>
<?php $__env->startSection('description', $description); ?>
<?php $__env->startSection('extra_css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
  <div id="channels_list">
    <h1>Channels List</h1>
    <p>At <?php echo e(config('app.name')); ?> we offer you an access to more than 16.000 TV channels of all countries around the world</p>
    <ul class="categories" v-if="categories.length > 1">
      <li v-for="category in categories" :class="{active: category.id == default_category}" @click="change_category(category.id)">{{category.name}}</li>
    </ul>

    <p v-if="categories.length > 1">
      You Are Viewing
      <span style="color:#07fcca;text-transform: uppercase;font-weight: 600;">
        {{default_categoryName}} server
      </span>
      Channels List.
    </p>

    <div class="channels_box" v-if="countries.length > 0 || channels.length > 0">
      <div class="row">
        <div class="col-md-3">
          <div class="box">
            <input v-show="!loadingCountries" id="kewyordCountrySearch" type="text" v-model="kewyordCountrySearch" class="form-control" 
            placeholder="Search Catgeories ...">
            <ul v-if="loadingCountries" class="loadingCountries">
              <i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
            </ul>
            <ul v-if="countries && !loadingCountries && !filteredCountriesList">
              <li v-for="country in countries" @click="getChannels(country.id)" :ref="country.id == defaultCountry_id ? 'active' : ''" :class="{active: country.id == defaultCountry_id}">{{country.name}}</li>
            </ul>
            <ul v-if="filteredCountriesList">
              <li v-for="country in filteredCountriesList" @click="getChannels(country.id)" :ref="country.id == defaultCountry_id ? 'active' : ''" :class="{active: country.id == defaultCountry_id}">{{country.name}}</li>
            </ul>
          </div>
        </div>
        <div class="col-md-9">
          <div class="box">
            <div class="search col-md-12 mx-auto">
              <div class="input-group">
                <input class="form-control" type="search" value="search" id="keyword" v-model="keyword" placeholder="Put channel name here">
                <span class="input-group-append">
                  <button @click="getSearch" class="btn btn-outline-secondary bg-white border-bottom-0 border rounded-pill ms-n5" type="button">
                    <i class="fa fa-search"></i>
                  </button>
                </span>
              </div>
            </div>
            <ul v-if="loading" class="channels_section loading">
              <i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
            </ul>
            <ul v-if="channels && !loading" class="channels_section">
              <li v-for="channel in channels">{{channel.name}}
                <small v-if="channel.country_name">{{channel.country_name}}</small>
                <small class="server" v-if="channel.category">{{channel.category}} Server</small>
               </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
    <span class="no_channels" v-else>No Channels Found</span>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<?php if( env('APP_ENV') == 'local' ): ?>
<script src="<?php echo e(asset('js/vue.js')); ?>"></script>
<?php else: ?>
<script src="<?php echo e(asset('js/vue.min.js')); ?>"></script>
<?php endif; ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.2.1/axios.min.js" integrity="sha512-zJYu9ICC+mWF3+dJ4QC34N9RA0OVS1XtPbnf6oXlvGrLGNB8egsEzu/5wgG90I61hOOKvcywoLzwNmPqGAdATA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>

  var changeCategory_url = '<?php echo e(route('changeCategory', 0)); ?>'
  var channels_url = '<?php echo e(route('getChannels', 0)); ?>'
  var search_url = '<?php echo e(route('search', 0)); ?>'


  changeCategory_url = changeCategory_url.replace('http://', 'https://')
  channels_url = channels_url.replace('http://', 'https://')
  search_url = search_url.replace('http://', 'https://')

  new Vue({
    el: 'div#channels_list',
    data: {
      default_category: <?php echo e($defaultCategory_id); ?>,
      categories: <?php echo $categories; ?>,
      countries: <?php echo $countries; ?>,
      channels: <?php echo $channels; ?>,
      defaultCountry_id: <?php echo e($defaultCountry_id); ?>,
      keyword: '',
      kewyordCountrySearch: '',
      loading: false,
      loadingCountries: false,
    },
    computed: {
      filteredCountriesList() {
        return this.countries.filter(country => {
          return country.name.toLowerCase().includes(this.kewyordCountrySearch.toLowerCase())
        })
      },
      default_categoryName() {
        return this.categories.find(item => item.id === this.default_category).name
      }
    },
    methods: {
      change_category(val) {
        this.loadingCountries = true
        this.loading = true
        this.channels = []
        this.default_category = val
        this.kewyordCountrySearch = ''
        axios.get(changeCategory_url.replace('/0', '/' + val))
              .then(data => data.data)
              .then(data => {
                setTimeout(() => {
                      this.loadingCountries = false
                      this.loading = false
                      this.defaultCountry_id = data.defaultCountry
                      this.countries = data.countries
                      this.channels = data.channels
                  }, 300)
              })
      },
      scrollDown() {
        jQuery("#channels_list .box ul li.active").get(0).scrollIntoView({behavior: 'smooth'});
      },
      getChannels(val) {
        this.keyword = ''
          this.loading = true
          this.channels = []
          this.defaultCountry_id = val
          axios.get(channels_url.replace('/0', '/' + val))
              .then(data => {
                setTimeout(() => {
                      this.loading = false
                      this.channels = data.data

                      <?php if (app('mobile-detect')->isMobile() && !app('mobile-detect')->isTablet()) : ?>
                      $('html, body').animate({
                          scrollTop: $("#channels_list ul.channels_section").offset().top - 100
                      }, 0);
                      <?php endif; ?>

                      // jQuery('ul.channels_section').scrollTop(0)
                  }, 300)
              })
      },
      getSearch() {
          // jQuery('#channels_list .box ul li').first().siblings().removeClass('active')
          this.loading = true
          this.channels = []
          axios.get(search_url.replace('/0', '/' + this.keyword))
              .then(data => {
                  setTimeout(() => {
                      this.loading = false
                      this.channels = data.data
                      // jQuery('ul.channels_section').scrollTop(0)
                  }, 300)
              })
      },
    },
    mounted() {
      jQuery("#channels_list .box ul li.active").get(0).scrollIntoView({behavior: 'smooth'});
        // this.channels = this.getChannels()
        // jQuery('#channels_list .box ul').scrollTo('#channels_list .box ul li.active');
        // jQuery("#channels_list .box ul li.active").get(0).scrollIntoView({behavior: 'smooth'});
    }
})

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/subtvpack.com/resources/views/channels_list.blade.php ENDPATH**/ ?>