@extends('layouts.app')
@section('title', config('app.name').' - Configure')
@section('extra_css')
<style>
#shopping-cart .checkout a {
    background: #030e2e;
    padding: 13px 81px;
    font-size: 21px;
    font-weight: 600;
}
#shopping-cart .checkout a:hover {
    background: #010616;
    transition: 0.3s;
}

._device_item {
    background: #ffffff12;
    border-radius: 11px;
    padding: 12px 17px;
    box-shadow: 0 0 2px 0px #251b29;
    border: 1px solid #ffffff14;
}

div#shopping-cart .summary {
    width: 320px;
    margin-top: 55px;
}

div#whatsapp {
    text-align: center;
    padding: 59px 0;
    margin-top: 47px;
}

.invalid-feedback {
    color: #ff0018;
}

/* @desktop
div#shopping-cart .summary {
    width: 320px;
    margin-top: 55px;
}

div#whatsapp {
    text-align: center;
    padding: 59px 0;
    margin-top: 47px;
}

@enddesktop */

</style>
@endsection
@section('content')
<div class="container">
    <div id="shopping-cart">
        @if($items->count() > 0)
        @if( session()->has('success') )
        {{-- <div class="alert alert-success" role="alert">
            {{session()->get('success')}}
        </div> --}}
        @endif
        <div class="row justify-content-center">
            <div class="col-md-7">
                <h2>Configure</h2>
                <div class="items">
                    @foreach ($items as $item)
                    @php
                        $connections_number = $item->model->cnumber->number;
                    @endphp
                    <div class="cart-item">
                        <h2>{{$item->model->period}}
                            @if( $showCategory )
                            <span class="cart_server_type">( {{ $item->model->cnumber->category->name }} server )</span>
                            @endif
                        </h2>
                        <ul>
                           <li style="text-transform:capitalize;font-weight: 700"><i class="fa fa-check"></i> {{$connections_number}} Connection <small>(s)</small></li>
                           <li style="text-transform:capitalize;font-weight: 700"><i class="fa fa-check"></i> No Activation Fees</li>
                           <li style="text-transform:capitalize;font-weight: 700"><i class="fa fa-check"></i> Technical Assistance & Support</li>
                        </ul>
                     </div>
                    @endforeach
                 </div>
                 <div class="additional_info">
                    <div class="body">
                       <form id="checkout_bridge_form" action="{{route('checkout_bridge')}}" method="POST">
                            @csrf
                            <div class="col-md-12 mb-4">
                                <label for="name" class="form-label">
                                    Your Name
                                </label>
                                <input type="text" id="name" v-model="name" name="name" placeholder="Jhon" class="form-control">
                                <div class="invalid-feedback" v-if="error_name" style=""> Name is Required </div>
                            </div>
                            <div class="col-md-12 mb-4">
                                <label for="email_address" class="form-label">
                                    Your Email
                                </label>
                                <input type="text" id="email_address" name="email_address" v-model="email" placeholder="xxx@xxx.com" class="form-control">
                                <div class="invalid-feedback" v-if="error_email" style=""> Email is Required </div>
                                @php
                                    // $errors = session()->get('errors');
                                @endphp
                                
                                @if($errors->has('email_address'))
                                <div class="invalid-feedback"> {{ $errors->first('email_address') }} </div>  
                                @endif

                                @if( $errors )
                                @foreach ($errors as $error)
                                <div class="invalid-feedback" style=""> {{$error}} </div>  
                                @endforeach
                                @endif
                            </div>
                            <div class="col-md-12 mb-4">
                                <label for="phone_number" class="form-label">
                                    Your Phone Number <small>( Optional )</small>
                                </label>
                                <input type="text" id="phone_number" name="phone_number" v-model="phone_number" placeholder="+XX (XX) XXX XXXX" class="form-control">
                            </div>
                            <div class="col-md-12">
                                <label for="renewing" class="form-label">
                                    Do you wanna renew your subscription ?
                                    <small> ( If Yes, use the same email ) *required</small>
                                </label>
                                <select class="form-select" id="renewing" name="renewing">
                                    <option value="0" :selected="renewing == 0">No, i want a new subscription</option>
                                    <option value="1" :selected="renewing == 1">Yes, i want to renew</option>
                                </select>
                            </div>
                            <div class="row mt-3">
                                <div class="col-md-12 mb-4">
                                    <label for="countries" class="form-label">
                                        Enter Countries <small>( Optional )</small>
                                    </label>
                                    <input type="text" id="countries" name="countries" v-model="countries" placeholder="UK, USA, India, Etc ... ( All Channels By Default )" class="form-control">
                                </div>
                                <div class="col-md-12 mb-4">
                                    <label for="languages" class="form-label">
                                        Enter Series Languages <small>( Optional )</small>
                                    </label>
                                    <input type="text" id="languages" name="languages" v-model="languages" placeholder="English, French, Punjabi, Etc ... ( English By Default )" class="form-control">
                                </div>
                            </div>
                            @for ( $i = 1; $i <= $connections_number; $i++ )
                            <div class="mb-3 _device_item">
                                <div class="col-md-12 mb-3" >
                                    <label for="subtype_id{{$i}}" class="form-label">Subscription Type {{ $connections_number > 1 ? 'For Connection ( Device ) N° '.$i.' ' : ''}}</label> 
                                    <select id="subtype_id{{$i}}" class="form-select selectpicker" v-on:change="change{{$i}}">
                                        <option value="0">* choose subscription type</option>
                                        <option v-for="subtype in subtypes" :value="subtype.id" :selected="selected_subtypes[{{$i}}] == subtype.id">@{{subtype.title}}</option>
                                    </select>
                                    <div class="invalid-feedback" v-if="error_subtypes[{{$i}}]"> Choose Subscription type Please </div>
                                </div>
                                <div class="col-md-12" v-if="mac_addresses[{{$i}}].enabled">
                                    <label for="mac_address" class="form-label">
                                        Mac Address ( Connection N° {{$i}} )
                                    </label>
                                    <input type="text" id="mac_address" v-model="mac_addresses[{{$i}}].value" placeholder="00:1A:79:XX:XX:XX" class="form-control">
                                </div>
                                <div class="invalid-feedback" v-if="error_macAddresses[{{$i}}]"> Mac Address is missing </div>
                            </div>
                            @endfor
                            <div class="col-md-12 mt-4">
                                <label for="notes" class="form-label">
                                    Additional Notes
                                </label>
                                <textarea spellcheck="false" placeholder="You can describe here which device (s) do you wanna use to setup your subscription, or any important info." name="notes" id="notes" cols="30" rows="7" class="form-control">{{$stored_notes}}</textarea>
                            </div>
                            <span
                                v-if="vod.enabled || adult.enabled || fastdelivery.enabled"
                                class="addons_title">Addons <small class="block"># Click To Select The Addon</small></span>
                            <div class="row">
                                <div class="col-md-6" v-if="vod.enabled">
                                    <div :class="{addon_item: true, addon_item_active: vod.status }" @click="vod.status = !vod.status">
                                        <input class="form-check-input" type="checkbox" v-model="vod.status" name="vod">
                                        <span>
                                            VOD ( Series & Movies )
                                            <small class="block" v-if="vod.price == 0">FREE</small>
                                            <small class="block" v-else>@{{vod.price}} {{$currency->symbol}}</small>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-6" v-if="adult.enabled">
                                    <div :class="{addon_item: true, addon_item_active: adult.status }" @click="adult.status = !adult.status">
                                        <input class="form-check-input" type="checkbox" v-model="adult.status" name="adult">
                                        <span>
                                            Adult Content
                                            <small class="block" v-if="adult.price == 0">FREE</small>
                                            <small class="block" v-else>@{{adult.price}} {{$currency->symbol}}</small>
                                        </span>
                                    </div>
                                </div>
                                <input type="hidden" id="connections" name="connections">
                                <div class="col-md-6" v-if="fastdelivery.enabled">
                                    <div :class="{addon_item: true, addon_item_active: fastdelivery.status }" @click="fastdelivery.status = !fastdelivery.status">
                                        <input class="form-check-input" type="checkbox" v-model="fastdelivery.status" name="fastdelivery">
                                        <span>Fast Delivery
                                            <small class="block" v-if="fastdelivery.price == 0">FREE</small>
                                            <small class="block" v-else>@{{fastdelivery.price}} {{$currency->symbol}}</small>
                                        </span>
                                    </div>
                                </div>
                            </div>
                       </form>
                    </div>
                 </div>
            </div>
            <div class="col-md-3">
                <div class="summary">
                    <p class="order_summary">order summary</p>
                    <span class="subtotal">
                        subtotal
                        <p>@{{subtotal}} {{$currency->symbol}}</p>
                    </span>
                    <span class="subtotal" v-if="vod.status && vod.enabled">
                        VOD ( Series & Movies )
                        <p>@{{vod.price}} {{$currency->symbol}}</p>
                    </span>
                    <span class="subtotal" v-if="adult.status && adult.enabled">
                        Adult Content
                        <p>@{{adult.price}} {{$currency->symbol}}</p>
                    </span>
                    <span class="subtotal" v-if="fastdelivery.status && fastdelivery.enabled">
                        Fast Delivery
                        <p>@{{fastdelivery.price}} {{$currency->symbol}}</p>
                    </span>
                    <span class="subtotal">
                        Setup Fees
                        <p>0 {{$currency->symbol}}</p>
                    </span>
                    <span class="total">
                        Total Due Today
                        <p>@{{total}} {{$currency->symbol}}</p>
                        <button @click.prevent="checkout" href="#" class="btn btn-success"><i class="fa fa-credit-card"></i> Checkout</button>
                    </span>
                </div>
            </div>
        </div>
        @else
        <div class="cart-empty">
            <h1>Your Shopping Cart Is Empty !</h1>
            <a href="{{route('home')}}">Continue Shopping</a>
        </div>
        @endif
    </div>
</div>
@endsection
@section('extra_js')
@if ( env('APP_ENV') == 'local' )
<script src="{{asset('js/vue.js')}}"></script>
@else
<script src="{{asset('js/vue.min.js')}}"></script>
@endif

@desktop
<script>
   $( document ).ready(function() {
    $(".alert-success").fadeTo(2000, 500).slideUp(500, function(){
        $(".alert-success").slideUp(500);
    });

    var $sticky = $('div#shopping-cart .summary');
    var $stickyrStopper = $('div#whatsapp');
    if (!!$sticky.offset()) { // make sure ".sticky" element exists
      var generalSidebarHeight = $sticky.innerHeight();
      var stickyTop = $sticky.offset().top;
      var stickOffset = 0;
      var stickyStopperPosition = $stickyrStopper.offset().top;
      var stopPoint = stickyStopperPosition - generalSidebarHeight - stickOffset;
      var diff = stopPoint + stickOffset;
  
      $(window).scroll(function(){ // scroll event
        var windowTop = $(window).scrollTop(); // returns number
  
        if (stopPoint < windowTop) {
            $sticky.css({ position: 'absolute', top: diff });
        } else if (stickyTop < windowTop+stickOffset) {
            $sticky.css({ position: 'fixed', top: stickOffset });
        } else {
            $sticky.css({position: 'absolute', top: 'initial'});
        }
      });
      
    }
  }); 
</script>
@enddesktop

<script>
    // init
    window.stored_connections = {!! $stored_connections ? $stored_connections : '[]' !!}
    window.vod_enabled = {{$stored_vod}}
    window.adult_enabled = {{$stored_adult}}
    window.stored_name = '{{$stored_name}}'
    window.stored_email = '{{$stored_email}}'
    window.stored_renewing = {{$stored_renewing}}
    
    window.stored_phone_number = '{{$stored_phone_number}}'
    window.stored_countries = '{{$stored_countries}}'
    window.stored_languages = '{{$stored_languages}}'
    window.subtypes = {!! $subtypes !!}
    window.connections_number = {{$connections_number}}

    window.vod = {
        enabled: {{$vod_enabled}},
        status: {{$stored_vod ? 'true' : 'false'}},
        price: {{$vod_price}}
    }

    window.adult = {
        enabled: {{$adult_enabled}},
        status: {{$stored_adult ? 'true' : 'false'}},
        price: {{$adult_price}}
    }

    window.fastdelivery = {
        enabled: {{$fastdelivery_enabled}},
        status: {{$stored_fastdelivery ? 'true' : 'false'}},
        price: {{$fastdelivery_price}}
    }

    window.subtotal = {{\Cart::subtotal()}}

    @if( env('APP_ENV') == 'local' )

    new Vue({
        el: '#shopping-cart',
        data: {
            connections: window.stored_connections,
            name: window.stored_name,
            email: window.stored_email,
            renewing: window.stored_renewing,
            phone_number: window.stored_phone_number,
            countries: window.stored_countries,
            languages: window.stored_languages,
            error_name: '',
            error_email: '',
            subtypes: window.subtypes,
            error_subtypes: [],
            error_macAddresses: [],
            selected_subtypes: [],
            mac_addresses: [],
            connections_number: window.connections_number,
            vod: window.vod,
            adult: window.adult,
            fastdelivery: window.fastdelivery,
            subtotal: window.subtotal
        },
        methods: {
            checkout() {
                let submit = true
                let mag_subtype_id = this.getMagSybTypeId()

                if( this.connections_number == 1 ) {
                    if( this.name != '' && this.email != '' && this.selected_subtypes[1] != 0 ) {  
                        if( this.selected_subtypes[1] == mag_subtype_id ) {
                            if( this.mac_addresses[1].value != '' ) {
                                submit = true
                            }else submit = false
                        }
                    }else submit = false
                }else if( this.connections_number == 2 ) {
                    if( this.name != '' && this.email != '' && this.selected_subtypes[1] != 0 && this.selected_subtypes[2] != 0 ) {

                        if( this.selected_subtypes[1] == mag_subtype_id ) {
                            if( this.mac_addresses[1].value != '' ) {
                                submit = true
                            }else submit = false
                        }
                        if( this.selected_subtypes[2] == mag_subtype_id ) {
                            if( this.mac_addresses[2].value != '' ) {
                                submit = true
                            }else submit = false
                        }
                    }else submit = false
                }else if( this.connections_number == 3 ) {
                    if( this.name != '' && this.email != '' && this.selected_subtypes[1] != 0 && this.selected_subtypes[2] != 0
                            && this.selected_subtypes[3] != 0 ) {

                        if( this.selected_subtypes[1] == mag_subtype_id ) {
                            if( this.mac_addresses[1].value != '' ) {
                                submit = true
                            }else submit = false
                        }
                        
                        if( this.selected_subtypes[2] == mag_subtype_id ) {
                            if( this.mac_addresses[2].value != '' ) {
                                submit = true
                            }else submit = false
                        }

                        if( this.selected_subtypes[3] == mag_subtype_id ) {
                            if( this.mac_addresses[3].value != '' ) {
                                submit = true
                            }else submit = false
                        }
                    }else submit = false
                }else if( this.connections_number == 4 ) {
                    if( this.name != '' && this.email != '' && this.selected_subtypes[1] != 0 && this.selected_subtypes[2] != 0
                            && this.selected_subtypes[3] != 0 && this.selected_subtypes[4] != 0 ) {

                        if( this.selected_subtypes[1] == mag_subtype_id ) {
                            if( this.mac_addresses[1].value != '' ) {
                                submit = true
                            }else submit = false
                        }
                        
                        if( this.selected_subtypes[2] == mag_subtype_id ) {
                            if( this.mac_addresses[2].value != '' ) {
                                submit = true
                            }else submit = false
                        }

                        if( this.selected_subtypes[3] == mag_subtype_id ) {
                            if( this.mac_addresses[3].value != '' ) {
                                submit = true
                            }else submit = false
                        }

                        if( this.selected_subtypes[4] == mag_subtype_id ) {
                            if( this.mac_addresses[4].value != '' ) {
                                submit = true
                            }else submit = false
                        }
                    }else submit = false
                }else if( this.connections_number == 5 ) {
                    if( this.name != '' && this.email != '' && this.selected_subtypes[1] != 0 && this.selected_subtypes[2] != 0
                            && this.selected_subtypes[3] != 0 && this.selected_subtypes[4] != 0 && this.selected_subtypes[5] != 0 ) {

                        if( this.selected_subtypes[1] == mag_subtype_id ) {
                            if( this.mac_addresses[1].value != '' ) {
                                submit = true
                            }else submit = false
                        }
                        
                        if( this.selected_subtypes[2] == mag_subtype_id ) {
                            if( this.mac_addresses[2].value != '' ) {
                                submit = true
                            }else submit = false
                        }

                        if( this.selected_subtypes[3] == mag_subtype_id ) {
                            if( this.mac_addresses[3].value != '' ) {
                                submit = true
                            }else submit = false
                        }

                        if( this.selected_subtypes[4] == mag_subtype_id ) {
                            if( this.mac_addresses[4].value != '' ) {
                                submit = true
                            }else submit = false
                        }

                        if( this.selected_subtypes[5] == mag_subtype_id ) {
                            if( this.mac_addresses[5].value != '' ) {
                                submit = true
                            }else submit = false
                        }
                    }else submit = false
                }

                if(submit) {
                    let connections = []
                    for( let $i = 1; $i <= this.connections_number; $i++) {
                        connections.push({
                            subtype: this.selected_subtypes[$i],
                            mac_address: this.mac_addresses[$i]
                        })
                    }
                    document.getElementById('connections').value = JSON.stringify(connections)
                    document.getElementById('checkout_bridge_form').submit()
                }else {

                    alert( 'You Missed Some Required Infos' )

                    if( this.name == '' ) {
                        this.error_name = true
                    }else this.error_name = false

                    if( this.email == '' ) {
                        this.error_email = true
                    }else this.error_email = false

                    if( this.selected_subtypes[1] == 0 ) {
                        this.$set(this.error_subtypes, 1, true)
                    }else this.$set(this.error_subtypes, 1, false)

                    if( this.selected_subtypes[2] == 0 ) {
                        this.$set(this.error_subtypes, 2, true)
                    }else this.$set(this.error_subtypes, 2, false)

                    if( this.selected_subtypes[3] == 0 ) {
                        this.$set(this.error_subtypes, 3, true)
                    }else this.$set(this.error_subtypes, 3, false)

                    if( this.selected_subtypes[4] == 0 ) {
                        this.$set(this.error_subtypes, 4, true)
                    }else this.$set(this.error_subtypes, 4, false)

                    if( this.selected_subtypes[5] == 0 ) {
                        this.$set(this.error_subtypes, 5, true)
                    }else this.$set(this.error_subtypes, 5, false)
                    
                    if( this.selected_subtypes[1] == mag_subtype_id && this.mac_addresses[1].value == '' ) {
                        this.$set(this.error_macAddresses, 1, true)
                    }else {
                        this.$set(this.mac_addresses, 1, {
                            enabled: false,
                            value: this.mac_addresses[1].value
                        })
                        this.$set(this.error_macAddresses, 1, false)
                    }

                    if( this.selected_subtypes[2] == mag_subtype_id && this.mac_addresses[2].value == '' ) {
                        this.$set(this.error_macAddresses, 2, true)
                    }else {
                        this.$set(this.mac_addresses, 2, {
                            enabled: false,
                            value: this.mac_addresses[2].value
                        })
                        this.$set(this.error_macAddresses, 2, false)
                    }

                    if( this.selected_subtypes[3] == mag_subtype_id && this.mac_addresses[3].value == '' ) {
                        this.$set(this.error_macAddresses, 3, true)
                    }else {
                        this.$set(this.mac_addresses, 3, {
                            enabled: false,
                            value: this.mac_addresses[3].value
                        })
                        this.$set(this.error_macAddresses, 3, false)
                    }

                    if( this.selected_subtypes[4] == mag_subtype_id && this.mac_addresses[4].value == '' ) {
                        this.$set(this.error_macAddresses, 4, true)
                    }else {
                        this.$set(this.mac_addresses, 4, {
                            enabled: false,
                            value: this.mac_addresses[4].value
                        })
                        this.$set(this.error_macAddresses, 4, false)
                    }

                    if( this.selected_subtypes[5] == mag_subtype_id && this.mac_addresses[5].value == '' ) {
                        this.$set(this.error_macAddresses, 5, true)
                    }else {
                        this.$set(this.mac_addresses, 5, {
                            enabled: false,
                            value: this.mac_addresses[5].value
                        })
                        this.$set(this.error_macAddresses, 5, false)
                    }

                }
            },
            getMagSybTypeId() {
                let id = 0
                this.subtypes.forEach(element => {
                    if(element.title.toLowerCase().includes('mag')) {
                        id = element.id
                    }
                })
                return id
            },
            change1() {
                const selected_subtype_id = document.querySelector('select#subtype_id1').value
                this.selected_subtypes[1] = selected_subtype_id
                let selected_subtype_name = ''
                this.subtypes.forEach(element => {
                    if(selected_subtype_id == element.id) {
                        selected_subtype_title = element.title
                    }
                })

                if( selected_subtype_title.toLowerCase().includes('mag')
                    || selected_subtype_title.toLowerCase().includes('formuler') ) {
                        let newMac = {
                            enabled: true,
                            value: this.mac_addresses[1].value
                        }
                        this.$set(this.mac_addresses, 1, newMac)
                }else this.mac_addresses[1].enabled = false
            },
            change2() {
                const selected_subtype_id = document.querySelector('select#subtype_id2').value                
                this.selected_subtypes[2] = selected_subtype_id
                let selected_subtype_name = ''
                this.subtypes.forEach(element => {
                    if(selected_subtype_id == element.id) {
                        selected_subtype_title = element.title
                    }
                })

                if( selected_subtype_title.toLowerCase().includes('mag')
                    || selected_subtype_title.toLowerCase().includes('formuler') ) {
                        let newMac = {
                            enabled: true,
                            value: this.mac_addresses[2].value
                        }
                        this.$set(this.mac_addresses, 2, newMac)
                }else this.mac_addresses[2].enabled = false
            },
            change3() {
                const selected_subtype_id = document.querySelector('select#subtype_id3').value                
                this.selected_subtypes[3] = selected_subtype_id
                let selected_subtype_name = ''
                this.subtypes.forEach(element => {
                    if(selected_subtype_id == element.id) {
                        selected_subtype_title = element.title
                    }
                })
                if( selected_subtype_title.toLowerCase().includes('mag')
                    || selected_subtype_title.toLowerCase().includes('formuler') ) {
                        let newMac = {
                            enabled: true,
                            value: this.mac_addresses[3].value
                        }
                        this.$set(this.mac_addresses, 3, newMac)
                }else this.mac_addresses[3].enabled = false
            },
            change4() {
                const selected_subtype_id = document.querySelector('select#subtype_id4').value                
                this.selected_subtypes[4] = selected_subtype_id
                let selected_subtype_name = ''
                this.subtypes.forEach(element => {
                    if(selected_subtype_id == element.id) {
                        selected_subtype_title = element.title
                    }
                })
                if( selected_subtype_title.toLowerCase().includes('mag')
                    || selected_subtype_title.toLowerCase().includes('formuler') ) {
                        let newMac = {
                            enabled: true,
                            value: this.mac_addresses[4].value
                        }
                        this.$set(this.mac_addresses, 4, newMac)
                }else this.mac_addresses[4].enabled = false
            },
            change5() {
                const selected_subtype_id = document.querySelector('select#subtype_id5').value                
                this.selected_subtypes[5] = selected_subtype_id
                let selected_subtype_name = ''
                this.subtypes.forEach(element => {
                    if(selected_subtype_id == element.id) {
                        selected_subtype_title = element.title
                    }
                })
                if( selected_subtype_title.toLowerCase().includes('mag')
                    || selected_subtype_title.toLowerCase().includes('formuler') ) {
                        let newMac = {
                            enabled: true,
                            value: this.mac_addresses[5].value
                        }
                        this.$set(this.mac_addresses, 5, newMac)
                }else this.mac_addresses[5].enabled = false
            }
        },
        computed: {
            total() {
                var total = this.subtotal
                if( this.vod.status )  total += this.vod.price
                if( this.adult.status )  total += this.adult.price
                if( this.fastdelivery.status )  total += this.fastdelivery.price

                var num = Number(total)
                var roundedString = num.toFixed(2)
                total = Number(roundedString)
                
                return total
            }  
        },
        watch: {
            'vod.status'(val) {
                if( val ) this.total += this.vod.price
                else this.total -= this.vod.price
            },
            'adult.status'(val) {
                if( val ) this.total += this.adult.price
                else this.total -= this.adult.price
            },
            'fastdelivery.status'(val) {
                if( val ) this.total += this.fastdelivery.price
                else this.total -= this.fastdelivery.price
            },
            total(number) {
                var num = Number(number)
                var roundedString = num.toFixed(2)
                var rounded = Number(roundedString)
            }
        },
        created() {
            for(let i = 1; i <= this.connections_number; i++ ) {
                this.mac_addresses[i] = {
                    enabled: false,
                    value: ''
                }
                this.error_subtypes[i] = false
                this.error_macAddresses[i] = false
                this.selected_subtypes[i] = 0
            }
            if( this.connections.length > 0 ) {
                console.log( this.connections )
                let mag_subtype_id = this.getMagSybTypeId()
                this.connections.forEach((element, index) => {
                    this.selected_subtypes[index + 1] = element.subtype
                    if( element.subtype == mag_subtype_id ) {
                        this.$set(this.mac_addresses, index+1, {
                            enabled: element.mac_address.enabled,
                            value: element.mac_address.value,
                        })
                    }
                })
            }
        }
    })
    
    @else
    @include('layouts.inc.js.configure')
    @endif

</script>
@endsection
