@extends('layouts.app')
@section('extra_css')
<style>
.auth-form {
    background: #00000030;
    border-radius: 14px;
    padding: 49px 53px;
    margin: 70px 0;
    color: white;
}
h1.login_text {
    font-size: 28px;
    font-weight: 500;
    margin-bottom: 40px;
}
.form-control {
    background: #bdbdbd;
    color: #111!important;
    height: 43px;
    border: none;
    border-radius: 8px;
    font-weight: 600
}
.form-control:focus {
   background: #bdbdbd;
   color: white;
   border-color: #bdbdbd;
}
.custom-control {
    padding: 7px 0;
}
.auth-form a {
    color: #e6ff00!important;
}
.auth-form p {
   margin: 0;
}
button.login {
    display: block;
    width: 100%;
    background: #e91e63;
    border: none;
    border-radius: 9px;
    padding: 10px 0;
}
button.login:hover {
    background: #960c3a;
    transition: 0.3s
}
</style>
@endsection
@section('title', 'Login')
@section('content')
<div class="container">
   <div class="row justify-content-center align-items-center">
      <div class="col-md-5">
         <div class="authincation-content">
            <div class="row">
               <div class="col-xl-12">
                  <div class="auth-form">
                     <form method="POST" action="{{ route('login') }}">
                       @csrf
                       <h1 class="login_text text-center">Secure Login</h1>
                        <div class="form-group mb-4">
                           <input id="email" placeholder="E-mail" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                           @error('email')
                               <span class="invalid-feedback" role="alert">
                                   <strong>{{ $message }}</strong>
                               </span>
                           @enderror
                        </div>
                        <div class="form-group">
                           <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password" placeholder="Password">
                           @error('password')
                               <span class="invalid-feedback" role="alert">
                                   <strong>{{ $message }}</strong>
                               </span>
                           @enderror
                        </div>
                        <div class="form-row d-flex justify-content-between mt-4 mb-2">
                           <div class="form-group">
                              <div class="custom-control custom-checkbox ml-1">
                                 <input class="custom-control-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                 <label class="custom-control-label" for="remember">Remember my preference</label>
                              </div>
                           </div>
                           @if (Route::has('password.request'))
                               <div class="form-group">
                                   <a class="btn btn-link" href="{{ route('password.request') }}">
                                       {{ __('Forgot Password?') }}
                                   </a>
                                </div>
                           @endif
                        </div>
                        <div class="text-center py-2">
                           <button type="submit" class="btn btn-primary login">Login</button>
                        </div>
                     </form>
                     @if( Route::has('register') )
                     <div class="new-account mt-3">
                        <p>Don't have an account? <a class="text-primary" href="{{route('register')}}">Sign up</a></p>
                     </div>
                     @endif
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
@endsection