<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'cnumber_id',
        'title',
        'short_title',
        'period',
        'price',
        'old_price',
        'visibility',
        'in_stock',
        'hot',
    ];
    
    public function orders() {
        return $this->hasMany(Order::class);
    }

    public function cnumber() {
        return $this->belongsTo(Cnumber::class);
    }
}