<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Connection extends Model
{
    use HasFactory;

    protected $fillable = [
        'server_id',
        'subtype_id',
        'host',
        'username',
        'password',
        'm3u',
        'epg',
        'mac_address',
        'enigma',
        'activation_date',
        'expiration_date',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'activation_date',
        'expiration_date'
    ];

    public function order() {
        return $this->belongsTo(Product::class);
    }

    public function category() {
        return $this->product()->category();
    }

    public function subtype() {
        return $this->belongsTo(Subtype::class);
    }
}