<?php

namespace App\Http\Controllers;

use App\Models\Product;
use Illuminate\Http\Request;

class SitemapController extends Controller
{
    public function products() {
        $items = Product::orderBy('updated_at', 'desc')->get();
        return response()->view('sitemap', [
            'items' => $items,
        ])->header('Content-Type', 'text/xml');
    }
}
