<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" xmlns="http://www.w3.org/1999/xhtml" itemscope itemtype="http://schema.org/WebPage">
    <head prefix="og: http://ogp.me/ns# fb: http://ogp.me/ns/fb# article: http://ogp.me/ns/article#">
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2">
        <link rel="profile" href="http://gmpg.org/xfn/11">
        <link rel="shortcut icon" href="<?php echo e(asset('storage/'.\App\Models\Config::whereName('favicon')->first()->value)); ?>">
        <meta name="robots" content="noodp, noydir" />
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="<?php echo e(asset('css/app.css?v='.time())); ?>" rel="stylesheet">
        <?php echo $__env->yieldContent('extra_css'); ?>
        <title><?php echo $__env->yieldContent('title'); ?></title>
    </head>
    <body>
        <?php if( \Request::route() != null && \Request::route()->getName() !== 'checkout' && \Request::route()->getName() !== 'checkout_iptv' &&  \Request::route()->getName() !== 'confirmRefOrder' ): ?>
        <p class="cta_top_message">
            GET 50% OFF | The Store You Are Looking For ❤️
        </p>
        <div id="header">
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <a id="logo" class="nav-brand" href="<?php echo e(route('home')); ?>">
                        <img width="140" alt="<?php echo e(\App\Models\Config::whereName('website_title')->first()->value); ?>" src="<?php echo e(asset('storage/'.\App\Models\Config::whereName('white')->first()->value)); ?>">
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"><i class="fa fa-bars" aria-hidden="true"></i></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav top-menu ml-auto mb-2 mb-lg-0">
                            <?php $__currentLoopData = \App\Models\Category::take(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('category', $category->slug)); ?>"><?php echo e($category->name); ?></a></li>                                
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <li><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('contactus')); ?>">Contact US</a></li>
                        </ul>
                        <div class="top-right-menu">
                            <ul>
                                <?php if( Auth::check() && auth()->user()->is_admin === 1 ): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="admin_link">ADMIN</a>
                                </li>
                                <?php endif; ?>
                                <li>
                                    <a href="<?php echo e(route('cart')); ?>" class="cart_number">
                                        <i class="fa fa-shopping-cart"></i>
                                        <span><?php echo e(\Cart::count()); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
        <?php endif; ?>
        <?php echo $__env->yieldContent('content'); ?>
        <?php if(  \Request::route() != null && \Request::route()->getName() !== 'checkout' && \Request::route()->getName() !== 'checkout_iptv' &&  \Request::route()->getName() !== 'confirmRefOrder' ): ?>
        <footer>
            <div class="container">
                <div class="row top_s">
                    <div class="about_us col-md-6">
                        <h3>about us</h3>
                        <p><?php echo e(\App\Models\Config::whereName('about_us')->first()->value); ?></p>
                        <ul>
                            <li><img width="40" height="25" src="<?php echo e(asset('cards/paypal.svg')); ?>" alt="paypal"></li>
                            <li><img width="40" height="30" src="<?php echo e(asset('cards/visa.svg')); ?>" alt="visa"></li>
                            <li><img width="40" height="34" src="<?php echo e(asset('cards/mastercard.svg')); ?>" alt="mastercard"></li>
                            <li><img width="40" height="34" src="<?php echo e(asset('cards/amex.svg')); ?>" alt="amex"></li>
                            <li><img width="40" height="34" src="<?php echo e(asset('cards/discover.svg')); ?>" alt="discover"></li>
                        </ul>
                    </div>
                    <div class="col-md-3">
                        <div class="links">
                            <?php $__currentLoopData = \App\Models\Category::take(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('category', $category->slug)); ?>" class="hvr-underline-from-center"><?php echo e($category->name); ?></a>                            
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('contactus')); ?>" class="hvr-underline-from-center">contact us</a>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="links">
                            <?php $__currentLoopData = \App\Models\LegalPage::whereVisibility(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('page', $page->slug)); ?>" class="hvr-underline-from-center"><?php echo e($page->title); ?></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="_footer">
                    All Rights Are Reserved To <strong style="color: lime"><?php echo e(config('app.name')); ?></strong> <i class="fa fa-copyright" aria-hidden="true"></i> <?php echo e(\Carbon\Carbon::now()->year); ?>

                </div>
            </div>
        </footer>
        <?php endif; ?>
        <script src="<?php echo e(asset('js/app.js')); ?>"></script>
        <?php echo $__env->yieldContent('extra_js'); ?>
    </body>
</html><?php /**PATH C:\xampp\htdocs\buysubiv.co.uk\resources\views/layouts/app.blade.php ENDPATH**/ ?>