@extends('layouts.app')
@section('title', 'Thank You For The Order')
@section('content')
<div class="container">
   <div id="thank-you">
      <span>Order Received</span>
      <p>Thank You , Your Order Has Been Received.</p>
      <div id="body">
         <div class="order_item">
            <span class="title">order number</span>
            <p class="value">#{{$order->id}}</p>
         </div>
         <div class="order_item">
            <span class="title">payment Method</span>
            <p class="value">{{$order->payment_method == "cc" ? "Credit / Debit Cards" : "PayPal"}}</p>
         </div>
         <div class="order_item">
            <span class="title">product</span>
            <p class="value">{{$order->product->title}}</p>
         </div>
         <div class="order_item">
            <span class="title">quantity</span>
            <p class="value">x {{$order->shipping_qty}}</p>
         </div>
         <div class="order_item">
            <span class="title">email</span>
            <p class="value">{{$order->shipping_emailAddress}}</p>
         </div>
         <div class="order_item">
            <span class="title">status</span>
            <p class="value">
               @if ( $order->shipped == 1 )
               <span class="badge bg-success">shipped</span>
               @else
               <span class="badge bg-secondary">processing</span>
               @endif
            </p>
         </div>
         <div class="order_item">
            <span class="title">total</span>
            <p class="value">{{$order->total}} $</p>
         </div>
      </div>
      <a href="{{route('home')}}" class="homepage">homepage</a>
   </div>
</div>
@endsection
@section('extra_css')
<style>
</style>
@endsection