<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" xmlns="http://www.w3.org/1999/xhtml" itemscope itemtype="http://schema.org/WebPage">
    <head prefix="og: http://ogp.me/ns# fb: http://ogp.me/ns/fb# article: http://ogp.me/ns/article#">
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2">
        <link rel="profile" href="http://gmpg.org/xfn/11">
        <link rel="shortcut icon" href="{{asset('storage/'.\App\Models\Config::whereName('favicon')->first()->value)}}">
        <meta name="robots" content="noodp, noydir" />
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="{{asset('css/app.css?v='.time())}}" rel="stylesheet">
        @yield('extra_css')
        <title>@yield('title')</title>
    </head>
    <body>
        @if ( \Request::route() != null && \Request::route()->getName() !== 'checkout' && \Request::route()->getName() !== 'checkout_iptv' &&  \Request::route()->getName() !== 'confirmRefOrder' )
        <p class="cta_top_message">
            GET 50% OFF | The Store You Are Looking For ❤️
        </p>
        <div id="header">
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <a id="logo" class="nav-brand" href="{{route('home')}}">
                        <img width="140" alt="{{\App\Models\Config::whereName('website_title')->first()->value}}" src="{{asset('storage/'.\App\Models\Config::whereName('white')->first()->value)}}">
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"><i class="fa fa-bars" aria-hidden="true"></i></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav top-menu ml-auto mb-2 mb-lg-0">
                            @foreach (\App\Models\Category::take(5)->get() as $category)
                            <li><a class="nav-item hvr-underline-from-center" href="{{route('category', $category->slug)}}">{{$category->name}}</a></li>                                
                            @endforeach
                            <li><a class="nav-item hvr-underline-from-center" href="{{route('contactus')}}">Contact US</a></li>
                        </ul>
                        <div class="top-right-menu">
                            <ul>
                                @if ( Auth::check() && auth()->user()->is_admin === 1 )
                                <li>
                                    <a href="{{route('admin.dashboard')}}" class="admin_link">ADMIN</a>
                                </li>
                                @endif
                                <li>
                                    <a href="{{route('cart')}}" class="cart_number">
                                        <i class="fa fa-shopping-cart"></i>
                                        <span>{{\Cart::count()}}</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
        @endif
        @yield('content')
        @if (  \Request::route() != null && \Request::route()->getName() !== 'checkout' && \Request::route()->getName() !== 'checkout_iptv' &&  \Request::route()->getName() !== 'confirmRefOrder' )
        <footer>
            <div class="container">
                <div class="row top_s">
                    <div class="about_us col-md-6">
                        <h3>about us</h3>
                        <p>{{\App\Models\Config::whereName('about_us')->first()->value}}</p>
                        <ul>
                            <li><img width="40" height="25" src="{{asset('cards/paypal.svg')}}" alt="paypal"></li>
                            <li><img width="40" height="30" src="{{asset('cards/visa.svg')}}" alt="visa"></li>
                            <li><img width="40" height="34" src="{{asset('cards/mastercard.svg')}}" alt="mastercard"></li>
                            <li><img width="40" height="34" src="{{asset('cards/amex.svg')}}" alt="amex"></li>
                            <li><img width="40" height="34" src="{{asset('cards/discover.svg')}}" alt="discover"></li>
                        </ul>
                    </div>
                    <div class="col-md-3">
                        <div class="links">
                            @foreach (\App\Models\Category::take(5)->get() as $category)
                            <a href="{{route('category', $category->slug)}}" class="hvr-underline-from-center">{{$category->name}}</a>                            
                            @endforeach
                            <a href="{{route('contactus')}}" class="hvr-underline-from-center">contact us</a>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="links">
                            @foreach (\App\Models\LegalPage::whereVisibility(1)->get() as $page)
                            <a href="{{route('page', $page->slug)}}" class="hvr-underline-from-center">{{$page->title}}</a>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="_footer">
                    All Rights Are Reserved To <strong style="color: lime">{{ config('app.name') }}</strong> <i class="fa fa-copyright" aria-hidden="true"></i> {{\Carbon\Carbon::now()->year}}
                </div>
            </div>
        </footer>
        @endif
        <script src="{{asset('js/app.js')}}"></script>
        @yield('extra_js')
    </body>
</html>