@extends('layouts.app')
@section('title', config('app.name').' || '.\App\Models\Config::whereName('website_description')->first()->value)
@section('content')
<div id="collections" class="container">
    <h1>Collections</h1>
    <ul class="collections">
        @foreach ($categories as $category)
        <li>
            <a href="{{route('category', $category->slug)}}">
                <img src="{{asset('storage/'.$category->poster)}}" alt="{{$category->name}}">
                <span class="title">{{$category->name}}</span>
            </a>
        </li>
        @endforeach
    </ul>
</div>
@foreach ($categories as $category)
@if( $category->products()->count() > 0 )
<div class="jkh_products">
    <div class="container">
        <h1>{{$category->name}}</h1>
        <div class="row">
            @foreach ($category->products as $product)
            <div class="col-md-3">
                <div class="product">
                    <a href="{{route('product', $product->slug)}}">
                        @if ($product->hot == 1) <span class="hot">Sold</span>@endif
                        <img class="poster img-fluid" src="{{asset('storage/'.$product->poster)}}" />
                        <div class="info">
                            <h2 class="title">{{$product->title}}</h2>
                            <div class="more">
                                <span class="price">{{$product->price}}$</span>
                                <span class="old_price">{{$product->old_price}}$</span>
                            </div>
                            <div class="buttons">
                                <a href="{{ route('product', $product->slug) }}" class="btn btn-dark show_product">Order Now</a>
                            </div>
                        </div>
                    </a>
                </div>
            </div> 
            @endforeach
        </div>
    </div>
</div>
@endif
@endforeach
@if ($questions->count() > 0 && false)
<div id="faq">
    <h2>Frequently Asked Questions</h1>
    <div class="container">
        <div class="accordion accordion-flush" id="accordionFlushExample">
            @foreach ($questions as $key => $value)
            <div class="accordion-item">
                <h2 class="accordion-header" id="flush-heading{{$key}}">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapse{{$key}}" aria-expanded="false" aria-controls="flush-collapse{{$key}}">
                        {{$value->question}}
                    </button>
                </h2>
                <div id="flush-collapse{{$key}}" class="accordion-collapse collapse" aria-labelledby="flush-heading{{$key}}" data-bs-parent="#accordionFlushExample">
                    <div class="accordion-body">
                        {!!$value->answer!!}
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endif

@endsection
@section('extra_css')
<style>
    div#homepage {
        padding-top: 39px;
    }

    div#homepage>h1 {
        font-size: 34px;
        font-weight: 800;
        color: #333;
        text-align: center;
        margin-bottom: 32px;
    }
</style>
@endsection
@section('extra_js')
<script>
    jQuery(document).ready(function() {
        $('ul.testimonials_list').owlCarousel({
            loop: true,
            nav: false,
            items: 3,
            responsive: {
                0: {
                    items: 1,
                    nav: true
                },
                900: {
                    items: 1,
                    nav: false
                },
                1000: {
                    items: 3,
                    nav: true,
                    loop: false
                }
            },
            autoplay: true,
            autoplayTimeout: 2500,
            autoplayHoverPause: true
        })
    })
</script>
@endsection
