@extends('layouts.app')
@section('title', config('app.name').' || Cart')
@section('extra_css')
<style>
#shopping-cart .checkout a {
    background: #030e2e;
    padding: 13px 81px;
    font-size: 21px;
    font-weight: 600;
}
#shopping-cart .checkout a:hover {
    background: #010616;
    transition: 0.3s;
}

.table>:not(caption)>*>* {
    border: none;
}

table.table {
    border-radius: 8px;
    overflow: hidden;
}
</style>
@endsection
@section('content')
<div class="container">
    <div id="shopping-cart">
        @if($items->count()>0)
        @if(session()->has('success'))
        <div class="alert alert-success" role="alert">
            {{session()->get('success')}}
        </div>
        @endif
        <div class="row justify-content-center">
            <div class="col-md-12">
                <h2>Cart</h2>
                <table class="table">
                    <thead>
                        <tr class="header">
                           <th scope="col">#</th>
                           <th scope="col"></th>
                           <th scope="col">Product</th>
                           <th scope="col">Price</th>
                           <th scope="col">Quantity</th>
                           <th scope="col">Subtotal</th>
                        </tr>
                     </thead>
                     <tbody>
                        @foreach ($items as $item)
                        <tr>
                           <th scope="row">
                              <div class="ceil_flex">
                                 <a class="remove_cart_item" href="{{route('cart.remove', $item->rowId)}}">
                                 <i class="fa fa-close"></i>
                                 </a>
                              </div>
                           </th>
                           <td>
                              <div class="ceil_flex">
                                 <img class="poster" width="60" src="{{asset($item->model->poster)}}" alt="{{$item->title}}">
                              </div>
                           </td>
                           <td>
                              <div class="ceil_flex title">
                                 {{$item->name}}
                              </div>
                           </td>
                           <td>
                              <div class="ceil_flex">
                                 {{$item->price}} $
                              </div>
                           </td>
                           <td>
                              <div class="ceil_flex">                                
                                 x{{$item->qty}}
                           </td>
                           </div>
                           <td>
                              <div class="ceil_flex">                                
                                 {{$item->subtotal()}} $
                              </div>
                           </td>
                        </tr>
                        @endforeach
                     </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-center">
                <div class="cart_summary">
                    <h3>Summary</h3>
                    <ul>
                        <li>
                            <span class="name">subtotal</span>
                            <span class="value">{{Cart::subtotal()}} $</span>
                        </li>
                        <li>
                            <span class="name">shipping</span>
                            <span class="value">Free shipping</span>
                        </li>
                        <li>
                            <span class="name">total</span>
                            <span class="value">{{Cart::total()}} $</span>
                        </li>
                        <li>
                            <a class="btn btn-primary checkout" href="{{route('checkout')}}">proceed to checkout</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        @else
        <div class="cart-empty">
            <h1>Your Shopping Cart Is Empty !</h1>
            <a href="{{route('home')}}">Continue Shopping</a>
        </div>
        @endif
    </div>
</div>
@endsection

@section('extra_js')
<script>
    $(document).ready(() => {
        $(".alert-success").fadeTo(2000, 500).slideUp(500, function(){
            $(".alert-success").slideUp(500);
        });
    })
</script>
@endsection