@extends('layouts.app')
@section('extra_css')
<style>
.auth-form {
    background: #0000003d;
    border-radius: 14px;
    padding: 49px 53px;
    margin: 70px 0;
    color: white;
}
h1.login_text {
    font-size: 28px;
    font-weight: 500;
    margin-bottom: 40px;
}
.form-control {
    background: #ffffff1a;
    color: white;
    height: 43px;
    border: none;
    border-radius: 12px;
}
.form-control:focus {
   background: #ffffff1a;
   color: white;
}
.custom-control {
    padding: 7px 0;
}
.auth-form a {
    color: #e6ff00!important;
    font-size: 13px;
}
.auth-form p {
   margin: 0;
}
button.login {
    display: block;
    width: 100%;
    background: #05247e;
    border: none;
    border-radius: 9px;
    padding: 10px 0;
}
button.login:hover {
    background: #031c68;
    transition: 0.3s
}
</style>
@endsection
@section('title', 'Login')
@section('content')
<div class="container">
   <div class="row justify-content-center align-items-center">
      <div class="col-md-5">
         <div class="authincation-content">
            <div class="row">
               <div class="col-xl-12">
                  <div class="auth-form">
                     <form method="POST" action="{{ route('login') }}">
                       @csrf
                       <h1 class="login_text text-center">Secure Login</h1>
                        <div class="form-group mb-4">
                           <input id="email" placeholder="E-mail" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                           @error('email')
                               <span class="invalid-feedback" role="alert">
                                   <strong>{{ $message }}</strong>
                               </span>
                           @enderror
                        </div>
                        <div class="form-group">
                           <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password" placeholder="Password">
                           @error('password')
                               <span class="invalid-feedback" role="alert">
                                   <strong>{{ $message }}</strong>
                               </span>
                           @enderror
                        </div>
                        <div class="form-row d-flex justify-content-between mt-4 mb-2">
                           <div class="form-group">
                              <div class="custom-control custom-checkbox ml-1">
                                 <input class="custom-control-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                 <label class="custom-control-label" for="remember">Remember my preference</label>
                              </div>
                           </div>
                           @if (Route::has('password.request'))
                               <div class="form-group">
                                   <a class="btn btn-link" href="{{ route('password.request') }}">
                                       {{ __('Forgot Password?') }}
                                   </a>
                                </div>
                           @endif
                        </div>
                        <div class="text-center py-2">
                           <button type="submit" class="btn btn-primary login">Login</button>
                        </div>
                     </form>
                     @if( Route::has('register') )
                     <div class="new-account mt-3">
                        <p>Don't have an account? <a class="text-primary" href="{{route('register')}}">Sign up</a></p>
                     </div>
                     @endif
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
@endsection





























{{-- 
<!DOCTYPE html>
<html lang="en" class="h-100">
   <meta http-equiv="content-type" content="text/html;charset=UTF-8" />
   <head>
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width,initial-scale=1">
      <title>Login</title>
      <link rel="icon" type="image/png" sizes="16x16" href="{{asset('favicon.ico')}}">
      <link href="{{asset('css/style.css')}}" rel="stylesheet">
   </head>
   <body class="h-100">
      <div class="authincation h-100">
         <div class="container h-100">
            <div class="row justify-content-center h-100 align-items-center">
               <div class="col-md-6">
                  <div class="authincation-content">
                     <div class="row no-gutters">
                        <div class="col-xl-12">
                           <div class="auth-form">
                              <form method="POST" action="{{ route('login') }}">
                                @csrf
                                <div class="text-center form-group">
                                    <a href="{{route('login')}}">
                                       <img src="{{asset('logo.png')}}" width="240px">
                                    </a>
                                 </div>
                                 <div class="form-group">
                                    <input id="email" placeholder="E-mail" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                                    @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                 </div>
                                 <div class="form-group">
                                    <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password" placeholder="Password">
                                    @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                 </div>
                                 <div class="form-row d-flex justify-content-between mt-4 mb-2">
                                    <div class="form-group">
                                       <div class="custom-control custom-checkbox ml-1">
                                          <input class="custom-control-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                          <label class="custom-control-label" for="remember">Remember my preference</label>
                                       </div>
                                    </div>
                                    @if (Route::has('password.request'))
                                        <div class="form-group">
                                            <a class="btn btn-link" href="{{ route('password.request') }}">
                                                {{ __('Forgot Password?') }}
                                            </a>
                                         </div>
                                    @endif
                                 </div>
                                 <div class="text-center">
                                    <button type="submit" class="btn btn-primary btn-block">Login</button>
                                 </div>
                              </form>
                              @if( Route::has('register') )
                              <div class="new-account mt-3">
                                 <p>Don't have an account? <a class="text-primary" href="{{route('register')}}">Sign up</a></p>
                              </div>
                              @endif
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </body>
</html> --}}