@extends('layouts.adminapp')
@section('extra_css')
<link href="/vd/sweetalert2/dist/sweetalert2.min.css" rel="stylesheet" type="text/css" />
<script src="/vd/sweetalert2/dist/sweetalert2.min.js" type="text/javascript"></script>
<style>
    div.swal2-select {
        display: none !important;
    }
</style>
@endsection
@section('title', 'Settings')
@section('content')
<div class="card card-default color-palette-box">
    <div class="card-body">
        @if ( session('success') )
        @verbatim <script>
            $(function() {
                Swal("Saved Successfully !!", "", "success")
            });
        </script> @endverbatim
        @endif
        <form action="{{ route('settings.save') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="col-md-3 form-group">
                    <label for="website_title">Website Title</label>
                    <input type="text" class="form-control" id="website_title" name="website_title" value="{{$configs['website_title']}}" placeholder="Website Title">
                </div>
                <div class="col-md-3 form-group">
                    <label for="website_description">Website Description</label>
                    <input type="text" class="form-control" id="website_description" name="website_description" value="{{$configs['website_description']}}" placeholder="Website Description">
                </div> 
            </div>
            <div class="row">
                <div class="col-md-12 form-group">
                    <label for="about_us">About Us</label>
                    <input type="text" class="form-control" id="about_us" name="about_us" value="{{$configs['about_us']}}" placeholder="About US">
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 mb-3">
                    <label for="white_logo" class="form-label">White Logo</label>
                    <input type="file" class="form-file-input form-control" name="white_logo" id="white_logo">
                </div>
                <div class="col-md-3 mb-3">
                    <label for="black_logo" class="form-label">Black Logo</label>
                    <input type="file" class="form-file-input form-control" name="black_logo" id="black_logo">
                </div>
                <div class="col-md-3 mb-3">
                    <label for="favicon" class="form-label">Favicon</label>
                    <input type="file" class="form-file-input form-control" name="favicon" id="favicon">
                </div>
            </div>
            <button type="submit" class="btn btn-primary">Submit</button>
        </form>
    </div>
</div>
@endsection
@section('extra_js')
<script src="/js/sweetalert2.min.js"></script>
@endsection
