@extends('layouts.adminapp')
@section('title', 'Products')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="{{route('admin.product_insert')}}" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Product</a>
</div>
<div class="card card-default color-palette-box">
    @if( session()->has('success') )
    <span class="badge bg-success"> {{session()->get('success')}} </span>
    @endif
    <div class="card-body">
       @if (count($products) > 0)
       <table class="table">
        <thead>
          <tr>
            <th scope="col"></th>
            <th scope="col">Title</th>
            <th scope="col">Price</th>
            <th scope="col">Orders</th>
            <th scope="col">Visibility</th>
            <th scope="col">Creation Date</th>
            <th scope="col"></th>
          </tr>
        </thead>
        <tbody>
        @foreach($products as $product)
          <tr class="product-table">
            <td>{{$product->id}}</td>
            <td class="title">{{ $product->title }}</td>
            <td>{{$product->price}}$</td>
            <td>{{$product->orders}}</td>
            <td>
              <span class="badge bg-{{$product->visibility == '1' ? 'success' : 'warning'}}">
                {{$product->visibility == '1' ? 'Visible' : 'Draft'}}
              </span>
            </td>
            <td>{{$product->created_at}}</td>
            <td class="actions">
              <a target="_blank" href="{{route('product', $product->slug)}}"><i class="edit fa fa-eye"></i></a>
              <a href="{{route('admin.product_edit', $product->id)}}"><i class="edit fa fa-pencil"></i></a>
              <a class="remove_prod" data-id="{{$product->id}}" href="#"><i class="edit fa fa-trash"></i></a>
            </td>
          </tr>
        @endforeach
        </tbody>
      </table>
       @else
       <h3>No Products</h3>
       @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script>
  $(document).ready(() => {
    $(".card-body>.badge.bg-success").fadeTo(2000, 500).slideUp(500, function(){
          $(".card-body>.badge.bg-success").slideUp(500);
      });
      $('.remove_prod').on('click', function(e) {
        e.preventDefault()
        var confirmA = confirm('Delete The Product ?')
        var product_id = $(this).attr('data-id')
        var link = "{{route('admin.product_delete', 0)}}"
        if(confirmA) {
          window.location.href = link.replace('/0', '/'+product_id)
        }
      });
  })
</script>
@endsection

@section('extra_css')
    <style>
td.title {
  background: #eee;
  width: 100%;
  display: inline-block;
  color: #333;
  padding: 19px 20px;
}
span.badge.bg-success {
  padding: 4px 7px;
}
    </style>
@endsection