<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('uuid')->unique()->nullable();
            $table->integer('product_id');
            $table->string('customer_id');
            $table->string('transaction_id');
            $table->string('shipping_firstName');
            $table->string('shipping_lastName');
            $table->string('shipping_country');
            $table->string('shipping_streetAddress');
            $table->string('shipping_city');
            $table->string('shipping_postal_code');
            $table->string('shipping_phone');
            $table->string('shipping_emailAddress');
            $table->string('paypal_email');
            $table->string('shipping_qty');
            $table->string('total');
            $table->boolean('shipped')->default(0);
            $table->timestamps();
        });
    }    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
