<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    protected $fillable = [
        'uuid',
        'product_id',
        'customer_id',
        'transaction_id',
        'shipping_firstName',
        'shipping_lastName',
        'shipping_country',
        'shipping_streetAddress',
        'shipping_city',
        'shipping_postal_code',
        'shipping_phone',
        'shipping_emailAddress',
        'paypal_email',
        'shipping_qty',
        'total',
        'shipped'
    ];

    public function product() {
        return $this->belongsTo(Product::class);
    }
}