<?php

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendPaymentLinkMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $order_id;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($order_id)
    {
        $this->order_id = $order_id;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $order = Order::whereId($this->order_id)->with(['service', 'product'])->first();
        return $this->subject($order->product->short_title.' [ PAYMENT LINK ]')
        ->markdown('mails.send_payment_link', [ 'order' => $order ]);
    }
}
