<?php

namespace App\Http\Controllers;

use App\Models\Config;
use App\Models\Order;
use App\Models\Origin;
use App\Models\Paypal;
use App\Models\User;
use Exception;
use Gloudemans\Shoppingcart\Facades\Cart;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Encryption\Encrypter;

class CheckoutController extends Controller
{

    function getDomainOnly($host){
        $host = strtolower(trim($host));
        $host = ltrim(str_replace("http://","",str_replace("https://","",$host)),"www.");
        $count = substr_count($host, '.');
        if($count === 2){
            if(strlen(explode('.', $host)[1]) > 3) $host = explode('.', $host, 2)[1];
        } else if($count > 2){
            $host = getDomainOnly(explode('.', $host, 2)[1]);
        }
        $host = explode('/',$host);
        return $host[0];
    }

    public function show(Request $request) {
        $data = $request->data;
        if( $request->data ) {

            if( $data != '' ) {
                // Get Redirected Origin;
                $referer = request()->headers->get('referer');
                if(!$referer) return redirect()->route('cart');
                $redirectedOrigin = $this->getDomainOnly(request()->headers->get('referer'));
                $myRootUrl = parse_url(request()->root())['host'];
                // Check Origin;
                $origins = Origin::whereActive(1)->get();
                $origin_allowed = false;
                $origin_url = '';
                $iptv_logo = '';
                foreach( $origins as $origin ) {
                    $checkingUrl = $this->getDomainOnly($origin->url);
                    if( Str::contains($checkingUrl, $redirectedOrigin) ) {
                        $iptv_logo = $origin->logo;
                        $origin_allowed = true;
                        $origin_url = $origin->url;
                    }
                }

                if( $redirectedOrigin == $myRootUrl || $origin_allowed ) {
                    /*
                    ** DATA;
                    */
                    try {
                        $newEncrypter = new Encrypter( env('AES_SECRET_KEY'), \Illuminate\Support\Facades\Config::get( 'app.cipher' ) );
                        $data = $newEncrypter->decrypt($data);
                    }catch(Exception $e) {
                        return redirect()->route('home');
                    }
                    $origin_url = $origin_url ? $origin_url : $data['origin_url'];
                    $uuid = $data['uuid'];
                    if( Order::whereUuid($uuid)->first() ) return redirect($origin_url);
                    Cart::destroy();
                    $order_id = $data['order_id'];
                    $product_name = $data['product_name'];
                    $subtotal = $data['subtotal'];
                    $total = $data['total'];
                    $vod = $data['vod'];
                    $vod_price = $data['vod_price'];
                    $adult = $data['adult'];
                    $adult_price = $data['adult_price'];
                    $fastdelivery = $data['fastdelivery'];
                    $fastdelivery_price = $data['fastdelivery_price'];
                    $currency = $data['currency'];
                    $email = $data['email'];
                    $name = $data['name'];
                    $iptv_logo = $iptv_logo ? $iptv_logo : $data['iptv_logo'];
                    $background_color = $data['background_color'];
                    /*
                    ** PAYPAL;
                    */
                    $paypal_shuffled = Config::whereName('paypal_shuffled')->first()->value;
                    $client_id = '';
    
                    $active_paypals = Paypal::whereActive(true);
                    if( $paypal_shuffled ) {
                        $randomPaypal = $active_paypals->where('max_amount', -1)
                                                        ->orWhere('max_amount', '>=', $total)
                                                        ->get();
                        if( $randomPaypal->count() > 0 ) {
                            $paypal = $this->getRandomElement($randomPaypal);
                        }else $paypal = null;
    
                        if( $paypal != null ) {
                            $paypal_id = $paypal->id;
                            $client_id = $this->getRandomElement($randomPaypal)->client_id;
                        }
                        
                    }else {
                        $paypal = $active_paypals->orWhere('max_amount', '=', -1)
                                                    ->where('max_amount', '>=', $total)
                                                    ->first();
                        $client_id = $paypal->client_id;
                        $paypal_id = $paypal->id;
                    }    
    
    
                    // check if already the email was registred or not;
                    // All Users Will Created Under This Password ==> "Adu@udfk//@"
                    if( ! $user = User::whereEmail($email)->first() ) {
                        $user = User::create([
                            'name' => $data['name'],
                            'phone_number' => null,
                            'country' => '',
                            'email' => $email,
                            'password' => bcrypt('Adu@udfk//@'),
                        ]);
                    }
    
    
                    $user_id = $user->id;
                    Cart::add($order_id, $product_name, 1, $subtotal, [ 'is_iptv' => true, 'origin' => $origin_url ]);
    
                    return view('checkout_iptv')->with(compact(
                        'order_id', 'user_id', 'product_name', 'subtotal', 'total',
                        'vod', 'vod_price',
                        'adult', 'adult_price',
                        'fastdelivery', 'fastdelivery_price',
                        'currency', 'client_id', 'iptv_logo', 'background_color',
                        'uuid', 'name', 'paypal_id'
                    ));
                }
            }


        }else {

            $paypal_shuffled = Config::whereName('paypal_shuffled')->first()->value;
            $client_id = 0;
            if( $paypal_shuffled == 1 ) {
                $paypals = Paypal::whereActive(true)->get();
                $randomPaypal = $this->getRandomElement($paypals);
                $client_id = $randomPaypal->client_id;
            }else $client_id = Paypal::whereActive(true)->first()->client_id;
            $items = Cart::content();
            if(count($items) == 0) return redirect()->route('home');
            return view('checkout')->with(compact(
                'items', 'client_id'
            ));

        }
    }

    private function getRandomElement($array) {
        $pos=rand(0,sizeof($array)-1);
        $res=$array[$pos];
        if (is_array($res)) return $this->getrandomelement($res);
        else return $res;
    }

    public function payment_ok(Request $request) {
        $items = Cart::content();
        if(count($items) == 0) return redirect()->route('home');
        foreach( $items as $item ) {
            $cart_item = $item;
            break;
        }
        $orderData['product_id'] = $cart_item->model->id;
        $orderData['customer_id'] = $request->customer_id;
        $orderData['transaction_id'] = $request->transaction_id;
        $orderData['shipping_firstName'] = $request->shipping_firstName;
        $orderData['shipping_lastName'] = $request->shipping_lastName;
        $orderData['shipping_country'] = $request->shipping_country;
        $orderData['shipping_streetAddress'] = $request->shipping_streetAddress;
        $orderData['shipping_city'] = $request->shipping_city;
        $orderData['shipping_postal_code'] = $request->shipping_postal_code;
        $orderData['shipping_phone'] = $request->shipping_phone;
        $orderData['shipping_emailAddress'] = $request->shipping_emailAddress;
        $orderData['paypal_email'] = $request->paypal_email;
        $orderData['shipping_qty'] = $cart_item->qty;
        $orderData['total'] = Cart::total();
        $order = Order::create($orderData);
        session()->put('order_received', $order->id);
        Cart::destroy();
        return redirect()->route('order_received');
    }

    public function order_received() {
        if( session()->has('order_received') ) {
            $order = Order::whereId(session()->get('order_received'))->first();
            session()->forget('order_received');
            return view('order_received')->with('order', $order);
        }else return redirect()->route('home');
    }

    public function confirmRefOrder(Request $request) {
        $array['order_id'] = $request->order_id;
        $array['customer_id'] = $request->customer_id;
        $array['transaction_id'] = $request->transaction_id;
        $array['paypal_email'] = $request->paypal_email;
        $array['first_name'] = $request->first_name;
        $array['last_name'] = $request->last_name;
        $array['country'] = $request->country;
        $decJson = base64_encode(json_encode($array));
        return redirect(Config::whereName('iptv_website')->first()->value.'/complete_ref_payment/'.$decJson);
    }
}