<?php

namespace App\Http\Controllers;

use App\Models\Config;
use App\Models\Order;
use App\Models\Origin;
use App\Models\Paypal;
use App\Models\Product;
use App\Models\User;
use Exception;
use Gloudemans\Shoppingcart\Facades\Cart;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Encryption\Encrypter;

class CartController extends Controller
{
    public function show() {
        $items = Cart::content();
        foreach( $items as $item ) {
            if( $item->options->is_iptv ) {
                Cart::destroy();
                return redirect($item->options->origin.'/configure');
            }
        };
        return view('cart')->with('items', $items);
    }

    public function store(Request $request) {
        Cart::destroy();
        if( $request->id ) {
            $product = Product::whereId($request->id)->firstOrFail();
            Cart::add($product->id, $product->title, $request->q ? $request->q : 1, $product->price)->associate($product);
            return redirect()->route('cart')->with('success', 'Added To Cart Successfully!');   
        }
        return redirect()->route('cart');
    }
    
    public function destroy() {
        Cart::destroy();
        return view('cart')->with('products', []);
    }

    public function remove($rowId) {
        Cart::remove($rowId);
        return redirect()->route('cart')->with('success', 'Removed From Cart Successfully!');
    }

    public function update_qty(Request $request) {
        Cart::update($request->rowId, $request->qty);
        return redirect()->route('cart')->with('success', 'Quantity Updated Successfully!');
    }

    /**
     ***********************************************************
     * ******************* START IPTV **************************
     * *********************************************************
    */
    public function cart_redirect_iptv($data) {
        // Get Redirected Origin;
        $parsedReferer = parse_url(request()->headers->get('referer'));
        if( !array_key_exists('scheme', $parsedReferer) ) return redirect()->route('home');
        $origin_url = $parsedReferer['scheme'].'://'.$parsedReferer['host'];
        if( $data != '' ) {
            $redirectedOrigin = $parsedReferer['host'];
            // Check If Origin Is Allowed;
            $origins = Origin::whereActive(1)->get();
            $origin_allowed = false;
            foreach( $origins as $origin ) {
                if( Str::contains($origin->url, $redirectedOrigin) ) {
                    $iptv_logo = $origin->logo;
                    $origin_allowed = true;
                }
            }
            if( $origin_allowed ) {
                Cart::destroy();
                try {
                    $newEncrypter = new Encrypter( env('AES_SECRET_KEY'), \Illuminate\Support\Facades\Config::get( 'app.cipher' ) );
                    $data = $newEncrypter->decrypt($data);
                }catch(Exception $e) {
                    return redirect()->route('home');
                }
                if( Order::whereUuid($data['uuid'])->first() ) return redirect($origin);
                $data['iptv_logo'] = $iptv_logo;
                $data['origin_url'] = $origin_url;
                $redirection_seconds = $data['redirection_seconds'];
                $background_color = $data['background_color'];
                $d = $newEncrypter->encrypt($data);
                return view('cart_redirect_iptv')->with(compact('d', 'redirection_seconds', 'background_color'));
            }
        }
        return redirect($origin);
    }

    public function checkout_iptv($data) {

        $parsedReferer = parse_url(request()->headers->get('referer'));
        if( !array_key_exists('scheme', $parsedReferer) ) return redirect()->route('home');
        $origin_url = $parsedReferer['scheme'].'://'.$parsedReferer['host'];

        
        if( $data != '' ) {
            $redirectedOrigin = $parsedReferer['host'];
            // Check If Origin Is Allowed;
            $origins = Origin::whereActive(1)->get();
            $origin_allowed = false;
            foreach( $origins as $origin ) {
                if( Str::contains($origin->url, $redirectedOrigin) ) {
                    $iptv_logo = $origin->logo;
                    $origin_allowed = true;
                }
            }
            if( $origin_allowed ) {

                Cart::destroy();
                try {
                    $newEncrypter = new Encrypter( env('AES_SECRET_KEY'), \Illuminate\Support\Facades\Config::get( 'app.cipher' ) );
                    $data = $newEncrypter->decrypt($data);
                }catch(Exception $e) {
                    return redirect()->route('home');
                }

                $uuid = $data['uuid'];
                if( Order::whereUuid($uuid)->first() ) return redirect($origin_url);
                Cart::destroy();
                $order_id = $data['order_id'];
                $product_name = $data['product_name'];
                $subtotal = $data['subtotal'];
                $total = $data['total'];
                $vod = $data['vod'];
                $vod_price = $data['vod_price'];
                $adult = $data['adult'];
                $adult_price = $data['adult_price'];
                $fastdelivery = $data['fastdelivery'];
                $fastdelivery_price = $data['fastdelivery_price'];
                $currency = $data['currency'];
                $email = $data['email'];
                $name = $data['name'];
                $iptv_logo = $iptv_logo;
                $background_color = $data['background_color'];
                /*
                ** PAYPAL;
                */
                $paypal_shuffled = Config::whereName('paypal_shuffled')->first()->value;
                $clientid = '';

                $active_paypals = Paypal::whereActive(true);
                if( $paypal_shuffled ) {
                    $randomPaypal = $active_paypals->where('max_amount', -1)
                                                    ->orWhere('max_amount', '>=', $total)
                                                    ->get();
                    if( $randomPaypal->count() > 0 ) {
                        $paypal = $this->getRandomElement($randomPaypal);
                    }else $paypal = null;

                    if( $paypal != null ) {
                        $paypal_id = $paypal->id;
                        $clientid = $this->getRandomElement($randomPaypal)->client_id;
                    }
                    
                }else {
                    $paypal = $active_paypals->orWhere('max_amount', '=', -1)
                                                ->where('max_amount', '>=', $total)
                                                ->first();
                    $clientid = $paypal->client_id;
                    $paypal_id = $paypal->id;
                }

                // check if already the email was registred or not;
                // All Users Will Created Under This Password ==> "Adu@udfk//@"
                if( ! $user = User::whereEmail($email)->first() ) {
                    $user = User::create([
                        'name' => $data['name'],
                        'phone_number' => null,
                        'country' => '',
                        'email' => $email,
                        'password' => bcrypt('Adu@udfk//@'),
                    ]);
                }


                $user_id = $user->id;
                Cart::add($order_id, $product_name, 1, $subtotal, [ 'is_iptv' => true, 'origin' => $origin_url ]);
                
                return view('checkout_iptv')->with(compact(
                    'order_id', 'user_id', 'product_name', 'subtotal', 'total',
                    'vod', 'vod_price',
                    'adult', 'adult_price',
                    'fastdelivery', 'fastdelivery_price',
                    'currency', 'clientid', 'iptv_logo', 'background_color',
                    'uuid', 'name', 'paypal_id'
                ));
            }
        }
        return redirect()->route('home');






        


        // if( $data != '' ) {
        //     // Get Redirected Origin;
        //     $referer = request()->headers->get('referer');
        //     if(!$referer) return redirect()->route('cart');
        //     $redirectedOrigin = parse_url(request()->headers->get('referer'))['host'];
        //     $myRootUrl = parse_url(request()->root())['host'];
        //     if( $redirectedOrigin == $myRootUrl ) {
        //         /*
        //         ** DATA;
        //         */
        //         try {
        //             $newEncrypter = new Encrypter( env('AES_SECRET_KEY'), \Illuminate\Support\Facades\Config::get( 'app.cipher' ) );
        //             $data = $newEncrypter->decrypt($data);
        //         }catch(Exception $e) {
        //             return redirect()->route('home');
        //         }
        //         $origin_url = $data['origin_url'];
        //         $uuid = $data['uuid'];
        //         if( Order::whereUuid($uuid)->first() ) return redirect($origin_url);
        //         Cart::destroy();
        //         $order_id = $data['order_id'];
        //         $product_name = $data['product_name'];
        //         $subtotal = $data['subtotal'];
        //         $total = $data['total'];
        //         $adult = $data['adult'];
        //         $adult_price = $data['adult_price'];
        //         $fastdelivery = $data['fastdelivery'];
        //         $fastdelivery_price = $data['fastdelivery_price'];
        //         $currency = $data['currency'];
        //         $email = $data['email'];
        //         $name = $data['name'];
        //         $iptv_logo = $data['iptv_logo'];
        //         $background_color = $data['background_color'];
        //         /*
        //         ** PAYPAL;
        //         */
        //         $paypal_shuffled = Config::whereName('paypal_shuffled')->first()->value;
        //         $clientid = '';

        //         $active_paypals = Paypal::whereActive(true);
        //         if( $paypal_shuffled ) {
        //             $randomPaypal = $active_paypals->where('max_amount', -1)
        //                                             ->orWhere('max_amount', '>=', $total)
        //                                             ->get();
        //             if( $randomPaypal->count() > 0 ) {
        //                 $paypal = $this->getRandomElement($randomPaypal);
        //             }else $paypal = null;

        //             if( $paypal != null ) {
        //                 $paypal_id = $paypal->id;
        //                 $clientid = $this->getRandomElement($randomPaypal)->client_id;
        //             }
                    
        //         }else {
        //             $paypal = $active_paypals->orWhere('max_amount', '=', -1)
        //                                         ->where('max_amount', '>=', $total)
        //                                         ->first();
        //             $clientid = $paypal->client_id;
        //             $paypal_id = $paypal->id;
        //         }



        //         // check if already the email was registred or not;
        //         // All Users Will Created Under This Password ==> "Adu@udfk//@"
        //         if( ! $user = User::whereEmail($email)->first() ) {
        //             $user = User::create([
        //                 'name' => $data['name'],
        //                 'phone_number' => null,
        //                 'country' => '',
        //                 'email' => $email,
        //                 'password' => bcrypt('Adu@udfk//@'),
        //             ]);
        //         }


        //         $user_id = $user->id;
        //         Cart::add($order_id, $product_name, 1, $subtotal, [ 'is_iptv' => true, 'origin' => $origin_url ]);

        //         return view('checkout_iptv')->with(compact(
        //             'order_id', 'user_id', 'product_name', 'subtotal', 'total',
        //             'adult', 'adult_price', 'fastdelivery', 'fastdelivery_price',
        //             'currency', 'clientid', 'iptv_logo', 'background_color',
        //             'uuid', 'name', 'paypal_id'
        //         ));
        //     }
        // }
    }

    private function getRandomElement($array) {
        $pos=rand(0,sizeof($array)-1);
        $res=$array[$pos];
        if (is_array($res)) return $this->getrandomelement($res);
        else return $res;
    }

    public function complete_iptv_payment(Request $request) {        
        $origin = null;
        foreach( Cart::content() as $item ){
            $origin = $item->options->origin;
            break;
        }
        // init vars;
        $user_id = $request->user_id;
        $ppl_account = Paypal::whereId($request->ppl_id)->first()->email;
        $iptv_order_id = $request->order_id;
        $uuid = $request->uuid;
        foreach( Cart::content() as $item ) {
            $cart_item = $item;
        }
        $origin = $cart_item->options->origin;
        $array['order_id'] = $iptv_order_id;
        $array['uuid'] = $uuid;
        $array['customer_id'] = $request->customer_id;
        $array['transaction_id'] = $request->transaction_id;
        $array['paypal_email'] = $request->paypal_email;
        $array['first_name'] = $request->first_name;
        $array['last_name'] = $request->last_name;
        $array['country'] = $request->country;
        $array['ppl_account'] = $ppl_account;
        $array['gateway'] = 'PayPal';
        $array['paid'] = true;
        /**
         * AES ENCRYPTION
         */
        try {
            $newEncrypter = new Encrypter( env('AES_SECRET_KEY'), \Illuminate\Support\Facades\Config::get( 'app.cipher' ) );
            $data = $newEncrypter->encrypt($array);
        }catch(Exception $e) {
            return redirect()->route('home');
        }
        // $decJson = base64_encode(json_encode($array));
        // Redirect to IPTV Website;
        return redirect($origin.'/complete_ref_payment/'.$data);
    }

    /**
     **********************************************************
     * ******************* END IPTV ***************************
     * *********************************************************
    */
}