<?php $__env->startSection('title', 'Posts'); ?>
<?php $__env->startSection('content'); ?>
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="<?php echo e(route('admin.post_insert')); ?>" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Post</a>
</div>
<div class="card card-default color-palette-box">
    <?php if( session()->has('success') ): ?>
    <span class="badge bg-success"> <?php echo e(session()->get('success')); ?> </span>
    <?php endif; ?>
    <div class="card-body">
       <?php if(count($posts) > 0): ?>
       <table class="table">
        <thead>
          <tr>
            <th scope="col"></th>
            <th scope="col">Title</th>
            <th scope="col">Visibility</th>
            <th scope="col">Creation Date</th>
            <th scope="col"></th>
          </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr class="product-table">
            <td><?php echo e($post->id); ?></td>
            <td class="title"><?php echo e($post->title); ?></td>
            <td>
              <span class="badge bg-<?php echo e($post->visibility == '1' ? 'success' : 'warning'); ?>">
                <?php echo e($post->visibility == '1' ? 'Visible' : 'Draft'); ?>

              </span>
            </td>
            <td><?php echo e($post->created_at); ?></td>
            <td class="actions">
              <a target="_blank" href="<?php echo e(route('post', $post->slug)); ?>"><i class="view fa fa-eye"></i></a>
              <a href="<?php echo e(route('admin.post_edit', $post->id)); ?>"><i class="edit fa fa-pencil"></i></a>
              <a class="remove_prod" data-id="<?php echo e($post->id); ?>" href="#"><i class="edit fa fa-trash"></i></a>
            </td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
       <?php else: ?>
       <h3>No Posts</h3>
       <?php endif; ?>
    </div>
 </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script>
  $(document).ready(() => {
    $(".card-body>.badge.bg-success").fadeTo(2000, 500).slideUp(500, function(){
          $(".card-body>.badge.bg-success").slideUp(500);
      });
      $('.remove_prod').on('click', function(e) {
        e.preventDefault()
        var confirmA = confirm('Delete The Post ?')
        var product_id = $(this).attr('data-id')
        var link = "<?php echo e(route('admin.post_delete', 0)); ?>"
        if(confirmA) {
          window.location.href = link.replace('/0', '/'+product_id)
        }
      });
  })
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>
    <style>
td.title {
  background: #eee;
  width: 100%;
  display: inline-block;
  color: #333;
  padding: 19px 20px;
}
span.badge.bg-success {
  padding: 4px 7px;
}
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/iptvca.io/resources/views/admin/posts.blade.php ENDPATH**/ ?>