<?php $__env->startSection('title', 'Products'); ?>
<?php $__env->startSection('content'); ?>
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="<?php echo e(route('admin.product_insert')); ?>" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Product</a>
</div>
<div class="card card-default color-palette-box">
    <?php if( session()->has('success') ): ?>
    <span class="badge bg-success"> <?php echo e(session()->get('success')); ?> </span>
    <?php endif; ?>
    <div class="card-body table-responsive">
       <?php if(count($products) > 0): ?>
       <table class="table">
        <thead>
          <tr>
            <th scope="col"></th>
            <th scope="col">Title</th>
            <th scope="col">Server type</th>
            <th scope="col">Price</th>
            <th scope="col">Orders</th>
            <th scope="col">Visibility</th>
            <th scope="col">Creation Date</th>
            <th scope="col"></th>
          </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr class="product-table">
            <td>#<?php echo e($product->id); ?></td>
            <td class="title"><a href="<?php echo e(route('admin.product_edit', $product->id)); ?>"><?php echo e($product->title); ?></a></td>
            <td><span class="badge badge-secondary"><?php echo e($product->cnumber->category->name); ?></span></td>
            <td><b><?php echo e($product->price.$currency->symbol); ?></b></td>
            <td><?php echo e($product->orders); ?></td>
            <td>
              <span class="badge bg-<?php echo e($product->visibility == '1' ? 'success' : 'warning'); ?>">
                <?php echo e($product->visibility == '1' ? 'Visible' : 'Draft'); ?>

              </span>
            </td>
            <td><?php echo e($product->created_at); ?></td>
            <td class="actions">
              <a href="<?php echo e(route('admin.product_edit', $product->id)); ?>"><i class="edit fa fa-pencil"></i></a>
              <a class="remove_prod" data-id="<?php echo e($product->id); ?>" href="#"><i class="edit fa fa-trash"></i></a>
              <a target="_blank" href="<?php echo e(route('cart', ['id' => $product->id])); ?>"><i class="edit fa fa-eye"></i></a>
            </td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
       <?php else: ?>
       <h3>No Products</h3>
       <?php endif; ?>
    </div>
 </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script>
  $(document).ready(() => {
    $(".card-body>.badge.bg-success").fadeTo(2000, 500).slideUp(500, function(){
          $(".card-body>.badge.bg-success").slideUp(500);
      });
      $('.remove_prod').on('click', function(e) {
        e.preventDefault()
        var confirmA = confirm('Delete The Product ?')
        var product_id = $(this).attr('data-id')
        var link = "<?php echo e(route('admin.product_delete', 0)); ?>"
        if(confirmA) {
          window.location.href = link.replace('/0', '/'+product_id)
        }
      });
  })
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>
<style>
    
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\raciptv.com\resources\views/admin/products.blade.php ENDPATH**/ ?>