<?php $__env->startSection('title', 'Order Received'); ?>
<?php $__env->startSection('content'); ?>
<div id="order_received">
   <div class="container">
      <span class="header_title">Order Received</span>
      <p class="header_p">Thank you, You order has been received. <br/> ( We will email you with all subscription details within some hours )</p>

      <div class="details">
         <div class="item">
            <span class="title">order number</span>
            <p class="value">#<?php echo e($order->id); ?></p>
         </div>
   
         <div class="item">
            <span class="title">payment Method</span>
            <p class="value"><?php echo e(str_contains(strtolower($order->gateway), 'stripe') ? 'Credit / Debit Card' : 'PayPal'); ?></p>
         </div>

         <div class="item">
            <span class="title">service</span>
            <p class="value"><?php echo e($order->product->short_title); ?></p>
         </div>

         <div class="item">
            <span class="title">email</span>
            <p class="value"><?php echo e($order->billing_email); ?></p>
         </div>

         <div class="item">
            <span class="title">total</span>
            <p class="value"><?php echo e($order->total); ?> <?php echo e($order->currency->code); ?></p>
         </div>
      </div>
      <a href="<?php echo e(route('home')); ?>" class="homepage">homepage</a>
   </div>   
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_css'); ?>
<style>
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<?php if( \App\Models\Config::whereName('gads_tracking_enabled')->first()->value == 1): ?>
<script>
   gtag('event', 'conversion', {
       'send_to': '<?php echo e(\App\Models\Config::whereName("gads_conversion_id")->first()->value); ?>',
       'value': <?php echo e($order->total); ?>,
       'currency': '<?php echo e($currency->code); ?>',
       'transaction_id': '<?php echo e($order->ppl_transaction_id); ?>'
   });
 </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\buysubtv.com\resources\views/order_received.blade.php ENDPATH**/ ?>