@extends('layouts.app')
@section('title', config('app.name').' || Contact Us')
@section('extra_css')
<style>
.h-captcha {
    margin-top: 25px;
}
</style>
@endsection
@section('content')
<div class="container">
    <div id="contact-us">
        @if (session('success'))
        <div class="sent">
            <i class="fa fa-check-circle"></i>
            <p class="message-sent">{{session('success') }}</p>
        </div>
        @else
        <h1>Contact Us</h1>
        <form method="POST">
            @csrf
            @if($errors->any())
            <ul class="errors">
                <li>Complete Captcha Please</li>
            </ul>
            @endif

            <div class="form-group">
                <label for="email">Email Address</label>
                <input type="email" class="form-control" id="email" name="email" placeholder="Put Your Email Here" value="{{old('email')}}">
            </div>

            <div class="form-group">
                <label for="subject">Subject</label>
                <input type="text" v-model="subject" id="subject" name="subject" value="{{old('subject')}}" class="form-control" placeholder="Subject">
            </div>

            <div class="form-group">
                <label for="message">Message</label>
                <textarea id="message" v-model="message" name="message" class="form-control" rows="7" placeholder="Message">{{old('message')}}</textarea>
            </div>

            {!! app('captcha')->display() !!}
            <button type="submit" class="send_message" @submit.prevent="send_message">Send Message</button>
        </form>
        @endif
    </div>
</div>
@endsection