@extends('layouts.app')
@section('extra_css')
<style>
.alert.alert-success {
    padding: 6px 0;
    text-align: center;
    font-size: 15px;
    FONT-WEIGHT: 600;
}
.auth-form {
   background: #030e2e;
   border-radius: 14px;
   padding: 49px 53px;
   margin: 70px 0;
   color: white;
}
h1.login_text {
    font-size: 28px;
    font-weight: 500;
    margin-bottom: 20px;
}
.form-control {
    background: #121d3d;
    color: white;
    height: 43px;
    border-color: #121d3d;
    border-radius: 12px;
}
.form-control:focus {
   background: #121d3d;
   color: white;
   border-color: #14224c;
}
.custom-control {
    padding: 7px 0;
}
.auth-form a {
    color: #e6ff00!important;
}
.auth-form p {
   margin: 0;
}
button.send {
    display: block;
    width: 100%;
    background: #05247e;
    border: none;
    border-radius: 9px;
    padding: 10px 0;
}
button.send:hover {
    background: #031c68;
    transition: 0.3s
}
</style>
@endsection
@section('title', 'Request Password')
@section('content')
<div class="container">
    <div class="row justify-content-center align-items-center">
       <div class="col-md-5">
          <div class="authincation-content">
             <div class="row">
                <div class="col-xl-12">
                   <div class="auth-form">
                      <form method="POST" action="{{ route('password.email') }}">
                        @csrf
                        <h1 class="login_text text-center">Reset Password</h1>
                        @if (session('status'))
                        <div class="alert alert-success mb-4" role="alert">
                            {{ session('status') }}
                        </div>
                         @endif
                         <div class="form-group mb-4">
                            <input id="email" placeholder="E-mail" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                            @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                         </div>
                         <div class="form-group row mb-0">
                            <button type="submit" class="btn send btn-primary">
                                {{ __('Send Password Reset Link') }}
                            </button>
                        </div>
                      </form>       
                   </div>
                </div>
             </div>
          </div>
       </div>
    </div>
 </div>
@endsection
