<?php

namespace Database\Seeders;

use App\Models\Config;
use App\Models\LegalPage;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\URL;

class LegalPagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Initilize variables;
        $date = Carbon::now()->format('Y-m-d');
        $company_name = config('app.name').' LTD.';
        $email = env('MAIL_USERNAME');
        $contactUs_url = route('contactus');
        $company_address = '1812 Rue Capitol, Laval, QC H7M 2H5, Canada';

        // Generate Legal Pages;
        LegalPage::create([
            'title' => 'Privacy Policy',
            'slug' => 'privacy-policy',
            'content' => '<p>Updated at '.$date.'</p><p>'.config('app.name').' (&ldquo;we,&rdquo; &ldquo;our,&rdquo; or &ldquo;us&rdquo;) is committed to protecting your privacy. This Privacy Policy explains how your personal information is collected, used, and disclosed by '.config('app.name').'.</p><p>This Privacy Policy applies to our website, and its associated subdomains (collectively, our &ldquo;Service&rdquo;) alongside our application, '.config('app.name').'. By accessing or using our Service, you signify that you have read, understood, and agree to our collection, storage, use, and disclosure of your personal information as described in this Privacy Policy and our Terms of Service.</p><h1>Definitions and key terms</h1><p>To help explain things as clearly as possible in this Privacy Policy, every time any of these terms are referenced, are strictly defined as:</p><ul><li>Cookie: small amount of data generated by a website and saved by your web browser. It is used to identify your browser, provide analytics, remember information about you such as your language preference or login information.</li><li>Company: when this policy mentions &ldquo;Company,&rdquo; &ldquo;we,&rdquo; &ldquo;us,&rdquo; or &ldquo;our,&rdquo; it refers to '.$company_name.', '.$company_address.' that is responsible for your information under this Privacy Policy.</li><li>Country: where '.config('app.name').' or the owners/founders of '.config('app.name').' are based, in this case is ireland</li><li>Customer: refers to the company, organization or person that signs up to use the '.config('app.name').' Service to manage the relationships with your consumers or service users.</li><li>Device: any internet connected device such as a phone, tablet, computer or any other device that can be used to visit '.config('app.name').' and use the services.</li><li>IP address: Every device connected to the Internet is assigned a number known as an Internet protocol (IP) address. These numbers are usually assigned in geographic blocks. An IP address can often be used to identify the location from which a device is connecting to the Internet.</li><li>Personnel: refers to those individuals who are employed by '.config('app.name').' or are under contract to perform a service on behalf of one of the parties.</li><li>Personal Data: any information that directly, indirectly, or in connection with other information &mdash; including a personal identification number &mdash; allows for the identification or identifiability of a natural person.</li><li>Service: refers to the service provided by '.config('app.name').' as described in the relative terms (if available) and on this platform.</li><li>Third-party service: refers to advertisers, contest sponsors, promotional and marketing partners, and others who provide our content or whose products or services we think may interest you.</li><li>Website: '.config('app.name').'&#39;s site, which can be accessed via this URL: '.env('APP_URL').'/</li><li>You: a person or entity that is registered with '.config('app.name').' to use the Services.</li></ul><p>&nbsp;</p><h1>What Information Do We Collect?</h1><p>We collect information from you when you visit our website, register on our site, place an order, subscribe to our newsletter, respond to a survey or fill out a form.</p><ul><li>Email Addresses</li><li>Billing Addresses</li></ul><ul></ul><h1>How Do We Use The Information We Collect?</h1><p>Any of the information we collect from you may be used in one of the following ways:</p><ul><li>To personalize your experience (your information helps us to better respond to your individual needs)</li><li>To improve our website (we continually strive to improve our website offerings based on the information and feedback we receive from you)</li><li>To improve customer service (your information helps us to more effectively respond to your customer service requests and support needs)</li><li>To process transactions</li><li>To administer a contest, promotion, survey or other site feature</li><li>To send periodic emails</li></ul><p>&nbsp;</p><h1>When does '.config('app.name').' use end user information from third parties?</h1><p>'.config('app.name').' will collect End User Data necessary to provide the '.config('app.name').' services to our customers.</p><p>End users may voluntarily provide us with information they have made available on social media websites. If you provide us with any such information, we may collect publicly available information from the social media websites you have indicated. You can control how much of your information social media websites make public by visiting these websites and changing your privacy settings.</p><h1>When does '.config('app.name').' use customer information from third parties?</h1><p>We receive some information from the third parties when you contact us. For example, when you submit your email address to us to show interest in becoming a '.config('app.name').' customer, we receive information from a third party that provides automated fraud detection services to '.config('app.name').'. We also occasionally collect information that is made publicly available on social media websites. You can control how much of your information social media websites make public by visiting these websites and changing your privacy settings.</p><h1>Do we share the information we collect with third parties?</h1><p>We may share the information that we collect, both personal and non-personal, with third parties such as advertisers, contest sponsors, promotional and marketing partners, and others who provide our content or whose products or services we think may interest you. We may also share it with our current and future affiliated companies and business partners, and if we are involved in a merger, asset sale or other business reorganization, we may also share or transfer your personal and non-personal information to our successors-in-interest.</p><p>We may engage trusted third party service providers to perform functions and provide services to us, such as hosting and maintaining our servers and the website, database storage and management, e-mail management, storage marketing, credit card processing, customer service and fulfilling orders for products and services you may purchase through the website. We will likely share your personal information, and possibly some non-personal information, with these third parties to enable them to perform these services for us and for you.</p><p>We may share portions of our log file data, including IP addresses, for analytics purposes with third parties such as web analytics partners, application developers, and ad networks. If your IP address is shared, it may be used to estimate general location and other technographics such as connection speed, whether you have visited the website in a shared location, and type of the device used to visit the website. They may aggregate information about our advertising and what you see on the website and then provide auditing, research and reporting for us and our advertisers.   We may also disclose personal and non-personal information about you to government or law enforcement officials or private parties as we, in our sole discretion, believe necessary or appropriate in order to respond to claims, legal process (including subpoenas), to protect our rights and interests or those of a third party, the safety of the public or any person, to prevent or stop any illegal, unethical, or legally actionable activity, or to otherwise comply with applicable court orders, laws, rules and regulations.</p><h1>Where and when is information collected from customers and end users?</h1><p>'.config('app.name').' will collect personal information that you submit to us. We may also receive personal information about you from third parties as described above.</p><h1>How Do We Use Your Email Address?</h1><p>By submitting your email address on this website, you agree to receive emails from us. You can cancel your participation in any of these email lists at any time by clicking on the opt-out link or other unsubscribe option that is included in the respective email. We only send emails to people who have authorized us to contact them, either directly, or through a third party. We do not send unsolicited commercial emails, because we hate spam as much as you do. By submitting your email address, you also agree to allow us to use your email address for customer audience targeting on sites like Facebook, where we display custom advertising to specific people who have opted-in to receive communications from us. Email addresses submitted only through the order processing page will be used for the sole purpose of sending you information and updates pertaining to your order. If, however, you have provided the same email to us through another method, we may use it for any of the purposes stated in this Policy. Note: If at any time you would like to unsubscribe from receiving future emails, we include detailed unsubscribe instructions at the bottom of each email.</p><h1>How Long Do We Keep Your Information?</h1><p>We keep your information only so long as we need it to provide '.config('app.name').' to you and fulfill the purposes described in this policy. This is also the case for anyone that we share your information with and who carries out services on our behalf. When we no longer need to use your information and there is no need for us to keep it to comply with our legal or regulatory obligations, we&rsquo;ll either remove it from our systems or depersonalize it so that we can&#39;t identify you.</p><h1>How Do We Protect Your Information?</h1><p>We implement a variety of security measures to maintain the safety of your personal information when you place an order or enter, submit, or access your personal information. We offer the use of a secure server. All supplied sensitive/credit information is transmitted via Secure Socket Layer (SSL) technology and then encrypted into our Payment gateway providers database only to be accessible by those authorized with special access rights to such systems, and are required to keep the information confidential. After a transaction, your private information (credit cards, social security numbers, financials, etc.) is never kept on file. We cannot, however, ensure or warrant the absolute security of any information you transmit to '.config('app.name').' or guarantee that your information on the Service may not be accessed, disclosed, altered, or destroyed by a breach of any of our physical, technical, or managerial safeguards.</p><h1>Could my information be transferred to other countries?</h1><p>'.config('app.name').' is incorporated in ireland. Information collected via our website, through direct interactions with you, or from use of our help services may be transferred from time to time to our offices or personnel, or to third parties, located throughout the world, and may be viewed and hosted anywhere in the world, including countries that may not have laws of general applicability regulating the use and transfer of such data. To the fullest extent allowed by applicable law, by using any of the above, you voluntarily consent to the trans-border transfer and hosting of such information.</p><h1>Is the information collected through the '.config('app.name').' Service secure?</h1><p>We take precautions to protect the security of your information. We have physical, electronic, and managerial procedures to help safeguard, prevent unauthorized access, maintain data security, and correctly use your information. However, neither people nor security systems are foolproof, including encryption systems. In addition, people can commit intentional crimes, make mistakes or fail to follow policies. Therefore, while we use reasonable efforts to protect your personal information, we cannot guarantee its absolute security. If applicable law imposes any non-disclaimable duty to protect your personal information, you agree that intentional misconduct will be the standards used to measure our compliance with that duty.</p><h1>Can I update or correct my information?</h1><p>The rights you have to request updates or corrections to the information '.config('app.name').' collects depend on your relationship with '.config('app.name').'. Personnel may update or correct their information as detailed in our internal company employment policies.</p><p>Customers have the right to request the restriction of certain uses and disclosures of personally identifiable information as follows. You can contact us in order to (1) update or correct your personally identifiable information, (2) change your preferences with respect to communications and other information you receive from us, or (3) delete the personally identifiable information maintained about you on our systems (subject to the following paragraph), by cancelling your account. Such updates, corrections, changes and deletions will have no effect on other information that we maintain, or information that we have provided to third parties in accordance with this Privacy Policy prior to such update, correction, change or deletion. To protect your privacy and security, we may take reasonable steps (such as requesting a unique password) to verify your identity before granting you profile access or making corrections. You are responsible for maintaining the secrecy of your unique password and account information at all times.</p><p>You should be aware that it is not technologically possible to remove each and every record of the information you have provided to us from our system. The need to back up our systems to protect information from inadvertent loss means that a copy of your information may exist in a non-erasable form that will be difficult or impossible for us to locate. Promptly after receiving your request, all personal information stored in databases we actively use, and other readily searchable media will be updated, corrected, changed or deleted, as appropriate, as soon as and to the extent reasonably and technically practicable.</p><p>If you are an end user and wish to update, delete, or receive any information we have about you, you may do so by contacting the organization of which you are a customer.</p><h1>Personnel</h1><p>If you are a '.config('app.name').' worker or applicant, we collect information you voluntarily provide to us. We use the information collected for Human Resources purposes in order to administer benefits to workers and screen applicants.</p><p>You may contact us in order to (1) update or correct your information, (2) change your preferences with respect to communications and other information you receive from us, or (3) receive a record of the information we have relating to you. Such updates, corrections, changes and deletions will have no effect on other information that we maintain, or information that we have provided to third parties in accordance with this Privacy Policy prior to such update, correction, change or deletion.</p><h1>Sale of Business</h1><p>We reserve the right to transfer information to a third party in the event of a sale, merger or other transfer of all or substantially all of the assets of '.config('app.name').' or any of its Corporate Affiliates (as defined herein), or that portion of '.config('app.name').' or any of its Corporate Affiliates to which the Service relates, or in the event that we discontinue our business or file a petition or have filed against us a petition in bankruptcy, reorganization or similar proceeding, provided that the third party agrees to adhere to the terms of this Privacy Policy.</p><h1>Affiliates</h1><p>We may disclose information (including personal information) about you to our Corporate Affiliates. For purposes of this Privacy Policy, &quot;Corporate Affiliate&quot; means any person or entity which directly or indirectly controls, is controlled by or is under common control with '.config('app.name').', whether by ownership or otherwise. Any information relating to you that we provide to our Corporate Affiliates will be treated by those Corporate Affiliates in accordance with the terms of this Privacy Policy.</p><h1>Governing Law</h1><p>This Privacy Policy is governed by the laws of ireland without regard to its conflict of laws provision. You consent to the exclusive jurisdiction of the courts in connection with any action or dispute arising between the parties under or in connection with this Privacy Policy except for those individuals who may have rights to make claims under Privacy Shield, or the Swiss-US framework.</p><p>The laws of ireland, excluding its conflicts of law rules, shall govern this Agreement and your use of the website. Your use of the website may also be subject to other local, state, national, or international laws.</p><p>By using '.config('app.name').' or contacting us directly, you signify your acceptance of this Privacy Policy. If you do not agree to this Privacy Policy, you should not engage with our website, or use our services. Continued use of the website, direct engagement with us, or following the posting of changes to this Privacy Policy that do not significantly affect the use or disclosure of your personal information will mean that you accept those changes.</p><h1>Your Consent</h1><p>We&#39;ve updated our Privacy Policy to provide you with complete transparency into what is being set when you visit our site and how it&#39;s being used. By using our website, registering an account, or making a purchase, you hereby consent to our Privacy Policy and agree to its terms.</p><h1>Links to Other Websites</h1><p>This Privacy Policy applies only to the Services. The Services may contain links to other websites not operated or controlled by '.config('app.name').'. We are not responsible for the content, accuracy or opinions expressed in such websites, and such websites are not investigated, monitored or checked for accuracy or completeness by us. Please remember that when you use a link to go from the Services to another website, our Privacy Policy is no longer in effect. Your browsing and interaction on any other website, including those that have a link on our platform, is subject to that website&rsquo;s own rules and policies. Such third parties may use their own cookies or other methods to collect information about you.</p><h1>Cookies</h1><p>'.config('app.name').' uses &quot;Cookies&quot; to identify the areas of our website that you have visited. A Cookie is a small piece of data stored on your computer or mobile device by your web browser. We use Cookies to enhance the performance and functionality of our website but are non-essential to their use. However, without these cookies, certain functionality like videos may become unavailable or you would be required to enter your login details every time you visit the website as we would not be able to remember that you had logged in previously. Most web browsers can be set to disable the use of Cookies. However, if you disable Cookies, you may not be able to access functionality on our website correctly or at all. We never place Personally Identifiable Information in Cookies.</p><h1>Blocking and disabling cookies and similar technologies</h1><p>Wherever you&#39;re located you may also set your browser to block cookies and similar technologies, but this action may block our essential cookies and prevent our website from functioning properly, and you may not be able to fully utilize all of its features and services. You should also be aware that you may also lose some saved information (e.g. saved login details, site preferences) if you block cookies on your browser. Different browsers make different controls available to you. Disabling a cookie or category of cookie does not delete the cookie from your browser, you will need to do this yourself from within your browser, you should visit your browser&#39;s help menu for more information.</p><h1>Remarketing Services</h1><p>We use remarketing services. What Is Remarketing? In digital marketing, remarketing (or retargeting) is the practice of serving ads across the internet to people who have already visited your website. It allows your company to seem like they&#39;re &ldquo;following&rdquo; people around the internet by serving ads on the websites and platforms they use most.</p><h1>Payment Details</h1><p>In respect to any credit card or other payment processing details you have provided us, we commit that this confidential information will be stored in the most secure manner possible.</p><h1>Kids&#39; Privacy</h1><p>We do not address anyone under the age of 13. We do not knowingly collect personally identifiable information from anyone under the age of 13. If You are a parent or guardian and You are aware that Your child has provided Us with Personal Data, please contact Us. If We become aware that We have collected Personal Data from anyone under the age of 13 without verification of parental consent, We take steps to remove that information from Our servers.</p><h1>Changes To Our Privacy Policy</h1><p>We may change our Service and policies, and we may need to make changes to this Privacy Policy so that they accurately reflect our Service and policies. Unless otherwise required by law, we will notify you (for example, through our Service) before we make changes to this Privacy Policy and give you an opportunity to review them before they go into effect. Then, if you continue to use the Service, you will be bound by the updated Privacy Policy. If you do not want to agree to this or any updated Privacy Policy, you can delete your account.</p><h1>Third-Party Services</h1><p>We may display, include or make available third-party content (including data, information, applications and other products services) or provide links to third-party websites or services (&quot;Third- Party Services&quot;).</p><p>You acknowledge and agree that '.config('app.name').' shall not be responsible for any Third-Party Services, including their accuracy, completeness, timeliness, validity, copyright compliance, legality, decency, quality or any other aspect thereof. '.config('app.name').' does not assume and shall not have any liability or responsibility to you or any other person or entity for any Third-Party Services.</p><p>Third-Party Services and links thereto are provided solely as a convenience to you and you access and use them entirely at your own risk and subject to such third parties&#39; terms and conditions.</p><ul></ul><h1>Information about General Data Protection Regulation (GDPR)</h1><p>We may be collecting and using information from you if you are from the European Economic Area (EEA), and in this section of our Privacy Policy we are going to explain exactly how and why is this data collected, and how we maintain this data under protection from being replicated or used in the wrong way.</p><h1>What is GDPR?</h1><p>GDPR is an EU-wide privacy and data protection law that regulates how EU residents&#39; data is protected by companies and enhances the control the EU residents have, over their personal data.</p><p>The GDPR is relevant to any globally operating company and not just the EU-based businesses and EU residents. Our customers&rsquo; data is important irrespective of where they are located, which is why we have implemented GDPR controls as our baseline standard for all our operations worldwide.</p><h1>What is personal data?</h1><p>Any data that relates to an identifiable or identified individual. GDPR covers a broad spectrum of information that could be used on its own, or in combination with other pieces of information, to identify a person. Personal data extends beyond a person&rsquo;s name or email address. Some examples include financial information, political opinions, genetic data, biometric data, IP addresses, physical address, sexual orientation, and ethnicity.</p><p>The Data Protection Principles include requirements such as:</p><ul><li>Personal data collected must be processed in a fair, legal, and transparent way and should only be used in a way that a person would reasonably expect.</li><li>Personal data should only be collected to fulfil a specific purpose and it should only be used for that purpose. Organizations must specify why they need the personal data when they collect it.</li><li>Personal data should be held no longer than necessary to fulfil its purpose.</li><li>People covered by the GDPR have the right to access their own personal data. They can also request a copy of their data, and that their data be updated, deleted, restricted, or moved to another organization.</li></ul><h1>Why is GDPR important?</h1><p>GDPR adds some new requirements regarding how companies should protect individuals&#39; personal data that they collect and process. It also raises the stakes for compliance by increasing enforcement and imposing greater fines for breach. Beyond these facts it&#39;s simply the right thing to do. At '.config('app.name').' we strongly believe that your data privacy is very important and we already have solid security and privacy practices in place that go beyond the requirements of this new regulation.</p><h1>Individual Data Subject&#39;s Rights - Data Access, Portability and Deletion</h1><p>We are committed to helping our customers meet the data subject rights requirements of GDPR. '.config('app.name').' processes or stores all personal data in fully vetted, DPA compliant vendors. We do store all conversation and personal data for up to 6 years unless your account is deleted. In which case, we dispose of all data in accordance with our Terms of Service and Privacy Policy, but we will not hold it longer than 60 days.</p><p>We are aware that if you are working with EU customers, you need to be able to provide them with the ability to access, update, retrieve and remove personal data. We got you! We&#39;ve been set up as self service from the start and have always given you access to your data and your customers data. Our customer support team is here for you to answer any questions you might have about working with the API.</p><h1>California Residents</h1><p>The California Consumer Privacy Act (CCPA) requires us to disclose categories of Personal Information we collect and how we use it, the categories of sources from whom we collect Personal Information, and the third parties with whom we share it, which we have explained above.</p><p>We are also required to communicate information about rights California residents have under California law. You may exercise the following rights:</p><ul><li>Right to Know and Access. You may submit a verifiable request for information regarding the: (1) categories of Personal Information we collect, use, or share; (2) purposes for which categories of Personal Information are collected or used by us; (3) categories of sources from which we collect Personal Information; and (4) specific pieces of Personal Information we have collected about you.</li><li>Right to Equal Service. We will not discriminate against you if you exercise your privacy rights.</li><li>Right to Delete. You may submit a verifiable request to close your account and we will delete Personal Information about you that we have collected.</li><li>Request that a business that sells a consumer&#39;s personal data, not sell the consumer&#39;s personal data.</li></ul><p>If you make a request, we have one month to respond to you. If you would like to exercise any of these rights, please contact us.</p><p>We do not sell the Personal Information of our users.</p><p>For more information about these rights, please contact us.</p><h1>California Online Privacy Protection Act (CalOPPA)</h1><p>CalOPPA requires us to disclose categories of Personal Information we collect and how we use it, the categories of sources from whom we collect Personal Information, and the third parties with whom we share it, which we have explained above.</p><p>CalOPPA users have the following rights:</p><ul><li>Right to Know and Access. You may submit a verifiable request for information regarding the: (1) categories of Personal Information we collect, use, or share; (2) purposes for which categories of Personal Information are collected or used by us; (3) categories of sources from which we collect Personal Information; and (4) specific pieces of Personal Information we have collected about you.</li><li>Right to Equal Service. We will not discriminate against you if you exercise your privacy rights.</li><li>Right to Delete. You may submit a verifiable request to close your account and we will delete Personal Information about you that we have collected.</li><li>Right to request that a business that sells a consumer&#39;s personal data, not sell the consumer&#39;s personal data.</li></ul><p>If you make a request, we have one month to respond to you. If you would like to exercise any of these rights, please contact us.</p><p>We do not sell the Personal Information of our users.</p><p>For more information about these rights, please contact us.</p><h1>Contact Us</h1><p>Don&#39;t hesitate to contact us if you have any questions.</p><ul><li>Via Email: '.$email.'</li><li>Via this Link: '.$contactUs_url.'</li></ul>',
            'visibility' => 1
        ]);

        LegalPage::create([
            'title' => 'Terms & conditions',
            'slug' => 'terms-conditions',
            'content' => '<p>Updated at '.$date.'</p><h1>General Terms</h1><p>By accessing and placing an order with '.config('app.name').', you confirm that you are in agreement with and bound by the terms of service contained in the Terms &amp; Conditions outlined below. These terms apply to the entire website and any email or other type of communication between you and '.config('app.name').'.</p><p>Under no circumstances shall '.config('app.name').' team be liable for any direct, indirect, special, incidental or consequential damages, including, but not limited to, loss of data or profit, arising out of the use, or the inability to use, the materials on this site, even if '.config('app.name').' team or an authorized representative has been advised of the possibility of such damages. If your use of materials from this site results in the need for servicing, repair or correction of equipment or data, you assume any costs thereof.</p><p>'.config('app.name').' will not be responsible for any outcome that may occur during the course of usage of our resources. We reserve the rights to change prices and revise the resources usage policy in any moment.</p><h1>License</h1><p>'.config('app.name').' grants you a revocable, non-exclusive, non-transferable, limited license to download, install and use the website strictly in accordance with the terms of this Agreement.</p><p>These Terms &amp; Conditions are a contract between you and '.config('app.name').' (referred to in these Terms &amp; Conditions as &quot;'.config('app.name').'&quot;, &quot;us&quot;, &quot;we&quot; or &quot;our&quot;), the provider of the '.config('app.name').' website and the services accessible from the '.config('app.name').' website (which are collectively referred to in these Terms &amp; Conditions as the &quot;'.config('app.name').' Service&quot;).</p><p>You are agreeing to be bound by these Terms &amp; Conditions. If you do not agree to these Terms &amp; Conditions, please do not use the '.config('app.name').' Service. In these Terms &amp; Conditions, &quot;you&quot; refers both to you as an individual and to the entity you represent. If you violate any of these Terms &amp; Conditions, we reserve the right to cancel your account or block access to your account without notice.</p><h1>Definitions and key terms</h1><p>To help explain things as clearly as possible in this Terms &amp; Conditions, every time any of these terms are referenced, are strictly defined as:</p><ul><li>Cookie: small amount of data generated by a website and saved by your web browser. It is used to identify your browser, provide analytics, remember information about you such as your language preference or login information.</li><li>Company: when this policy mentions &ldquo;Company,&rdquo; &ldquo;we,&rdquo; &ldquo;us,&rdquo; or &ldquo;our,&rdquo; it refers to '.config('app.name').', '.$company_address.' that is responsible for your information under this Terms &amp; Conditions.</li><li>Country: where '.config('app.name').' or the owners/founders of '.config('app.name').' are based, in this case is MA</li><li>Device: any internet connected device such as a phone, tablet, computer or any other device that can be used to visit '.config('app.name').' and use the services.</li><li>Service: refers to the service provided by '.config('app.name').' as described in the relative terms (if available) and on this platform.</li><li>Third-party service: refers to advertisers, contest sponsors, promotional and marketing partners, and others who provide our content or whose products or services we think may interest you.</li><li>Website: '.config('app.name').'&#39;s site, which can be accessed via this URL: '.env('APP_URL').'/</li><li>You: a person or entity that is registered with '.config('app.name').' to use the Services.</li></ul><h1>Restrictions</h1><p>You agree not to, and you will not permit others to:</p><ul><li>License, sell, rent, lease, assign, distribute, transmit, host, outsource, disclose or otherwise commercially exploit the website or make the platform available to any third party.</li><li>Modify, make derivative works of, disassemble, decrypt, reverse compile or reverse engineer any part of the website.</li><li>Remove, alter or obscure any proprietary notice (including any notice of copyright or trademark) of '.config('app.name').' or its affiliates, partners, suppliers or the licensors of the website.</li></ul><h1>Return and Refund Policy</h1><p>Thanks for shopping at '.config('app.name').'. We appreciate the fact that you like to buy the stuff we build. We also want to make sure you have a rewarding experience while you&rsquo;re exploring, evaluating, and purchasing our products.</p><p>As with any shopping experience, there are terms and conditions that apply to transactions at '.config('app.name').'. We&rsquo;ll be as brief as our attorneys will allow. The main thing to remember is that by placing an order or making a purchase at '.config('app.name').', you agree to the terms along with '.config('app.name').'&#39;s Privacy Policy.</p><p>If, for any reason, You are not completely satisfied with any good or service that we provide, don&#39;t hesitate to contact us and we will discuss any of the issues you are going through with our product.</p><h1>Your Suggestions</h1><p>Any feedback, comments, ideas, improvements or suggestions (collectively, &quot;Suggestions&quot;) provided by you to '.config('app.name').' with respect to the website shall remain the sole and exclusive property of '.config('app.name').'.</p><p>'.config('app.name').' shall be free to use, copy, modify, publish, or redistribute the Suggestions for any purpose and in any way without any credit or any compensation to you.</p><h1>Your Consent</h1><p>We&#39;ve updated our Terms &amp; Conditions to provide you with complete transparency into what is being set when you visit our site and how it&#39;s being used. By using our website, registering an account, or making a purchase, you hereby consent to our Terms &amp; Conditions.</p><h1>Links to Other Websites</h1><p>This Terms &amp; Conditions applies only to the Services. The Services may contain links to other websites not operated or controlled by '.config('app.name').'. We are not responsible for the content, accuracy or opinions expressed in such websites, and such websites are not investigated, monitored or checked for accuracy or completeness by us. Please remember that when you use a link to go from the Services to another website, our Terms &amp; Conditions are no longer in effect. Your browsing and interaction on any other website, including those that have a link on our platform, is subject to that website&rsquo;s own rules and policies. Such third parties may use their own cookies or other methods to collect information about you.</p><h1>Cookies</h1><p>'.config('app.name').' uses &quot;Cookies&quot; to identify the areas of our website that you have visited. A Cookie is a small piece of data stored on your computer or mobile device by your web browser. We use Cookies to enhance the performance and functionality of our website but are non-essential to their use. However, without these cookies, certain functionality like videos may become unavailable or you would be required to enter your login details every time you visit the website as we would not be able to remember that you had logged in previously. Most web browsers can be set to disable the use of Cookies. However, if you disable Cookies, you may not be able to access functionality on our website correctly or at all. We never place Personally Identifiable Information in Cookies.</p><h1>Changes To Our Terms &amp; Conditions</h1><p>You acknowledge and agree that may stop (permanently or temporarily) providing the Service (or any features within the Service) to you or to users generally at &rsquo;s sole discretion, without prior notice to you. You may stop using the Service at any time. You do not need to specifically inform when you stop using the Service. You acknowledge and agree that if disables access to your account, you may be prevented from accessing the Service, your account details or any files or other materials which is contained in your account.</p><p>If we decide to change our Terms &amp; Conditions, we will post those changes on this page, and/or update the Terms &amp; Conditions modification date below.</p><h1>Modifications to Our website</h1><p>'.config('app.name').' reserves the right to modify, suspend or discontinue, temporarily or permanently, the website or any service to which it connects, with or without notice and without liability to you.</p><h1>Updates to Our website</h1><p>'.config('app.name').' may from time to time provide enhancements or improvements to the features/ functionality of the website, which may include patches, bug fixes, updates, upgrades and other modifications (&quot;Updates&quot;).</p><p>Updates may modify or delete certain features and/or functionalities of the website. You agree that '.config('app.name').' has no obligation to (i) provide any Updates, or (ii) continue to provide or enable any particular features and/or functionalities of the website to you.</p><p>You further agree that all Updates will be (i) deemed to constitute an integral part of the website, and (ii) subject to the terms and conditions of this Agreement.</p><h1>Third-Party Services</h1><p>We may display, include or make available third-party content (including data, information, applications and other products services) or provide links to third-party websites or services (&quot;Third- Party Services&quot;).</p><p>You acknowledge and agree that '.config('app.name').' shall not be responsible for any Third-Party Services, including their accuracy, completeness, timeliness, validity, copyright compliance, legality, decency, quality or any other aspect thereof. '.config('app.name').' does not assume and shall not have any liability or responsibility to you or any other person or entity for any Third-Party Services.</p><p>Third-Party Services and links thereto are provided solely as a convenience to you and you access and use them entirely at your own risk and subject to such third parties&#39; terms and conditions.</p><h1>Term and Termination</h1><p>This Agreement shall remain in effect until terminated by you or '.config('app.name').'.</p><p>'.config('app.name').' may, in its sole discretion, at any time and for any or no reason, suspend or terminate this Agreement with or without prior notice.</p><p>This Agreement will terminate immediately, without prior notice from '.config('app.name').', in the event that you fail to comply with any provision of this Agreement. You may also terminate this Agreement by deleting the website and all copies thereof from your computer.</p><p>Upon termination of this Agreement, you shall cease all use of the website and delete all copies of the website from your computer.</p><p>Termination of this Agreement will not limit any of '.config('app.name').'&#39;s rights or remedies at law or in equity in case of breach by you (during the term of this Agreement) of any of your obligations under the present Agreement.</p><h1>Copyright Infringement Notice</h1><p>If you are a copyright owner or such owner&rsquo;s agent and believe any material on our website constitutes an infringement on your copyright, please contact us setting forth the following information: (a) a physical or electronic signature of the copyright owner or a person authorized to act on his behalf; (b) identification of the material that is claimed to be infringing; (c) your contact information, including your address, telephone number, and an email; (d) a statement by you that you have a good faith belief that use of the material is not authorized by the copyright owners; and (e) the a statement that the information in the notification is accurate, and, under penalty of perjury you are authorized to act on behalf of the owner.</p><h1>Indemnification</h1><p>You agree to indemnify and hold '.config('app.name').' and its parents, subsidiaries, affiliates, officers, employees, agents, partners and licensors (if any) harmless from any claim or demand, including reasonable attorneys&#39; fees, due to or arising out of your: (a) use of the website; (b) violation of this Agreement or any law or regulation; or (c) violation of any right of a third party.</p><h1>No Warranties</h1><p>The website is provided to you &quot;AS IS&quot; and &quot;AS AVAILABLE&quot; and with all faults and defects without warranty of any kind. To the maximum extent permitted under applicable law, '.config('app.name').', on its own behalf and on behalf of its affiliates and its and their respective licensors and service providers, expressly disclaims all warranties, whether express, implied, statutory or otherwise, with respect to the website, including all implied warranties of merchantability, fitness for a particular purpose, title and non-infringement, and warranties that may arise out of course of dealing, course of performance, usage or trade practice. Without limitation to the foregoing, '.config('app.name').' provides no warranty or undertaking, and makes no representation of any kind that the website will meet your requirements, achieve any intended results, be compatible or work with any other software, , systems or services, operate without interruption, meet any performance or reliability standards or be error free or that any errors or defects can or will be corrected.</p><p>Without limiting the foregoing, neither '.config('app.name').' nor any '.config('app.name').'&#39;s provider makes any representation or warranty of any kind, express or implied: (i) as to the operation or availability of the website, or the information, content, and materials or products included thereon; (ii) that the website will be uninterrupted or error-free; (iii) as to the accuracy, reliability, or currency of any information or content provided through the website; or (iv) that the website, its servers, the content, or e-mails sent from or on behalf of '.config('app.name').' are free of viruses, scripts, trojan horses, worms, malware, timebombs or other harmful components.</p><p>Some jurisdictions do not allow the exclusion of or limitations on implied warranties or the limitations on the applicable statutory rights of a consumer, so some or all of the above exclusions and limitations may not apply to you.</p><h1>Limitation of Liability</h1><p>Notwithstanding any damages that you might incur, the entire liability of '.config('app.name').' and any of its suppliers under any provision of this Agreement and your exclusive remedy for all of the foregoing shall be limited to the amount actually paid by you for the website.</p><p>To the maximum extent permitted by applicable law, in no event shall '.config('app.name').' or its suppliers be liable for any special, incidental, indirect, or consequential damages whatsoever (including, but not limited to, damages for loss of profits, for loss of data or other information, for business interruption, for personal injury, for loss of privacy arising out of or in any way related to the use of or inability to use the website, third-party software and/or third-party hardware used with the website, or otherwise in connection with any provision of this Agreement), even if '.config('app.name').' or any supplier has been advised of the possibility of such damages and even if the remedy fails of its essential purpose.</p><p>Some states/jurisdictions do not allow the exclusion or limitation of incidental or consequential damages, so the above limitation or exclusion may not apply to you.</p><h1>Severability</h1><p>If any provision of this Agreement is held to be unenforceable or invalid, such provision will be changed and interpreted to accomplish the objectives of such provision to the greatest extent possible under applicable law and the remaining provisions will continue in full force and effect.</p><p>This Agreement, together with the Privacy Policy and any other legal notices published by '.config('app.name').' on the Services, shall constitute the entire agreement between you and '.config('app.name').' concerning the Services. If any provision of this Agreement is deemed invalid by a court of competent jurisdiction, the invalidity of such provision shall not affect the validity of the remaining provisions of this Agreement, which shall remain in full force and effect. No waiver of any term of this Agreement shall be deemed a further or continuing waiver of such term or any other term, and '.config('app.name').'&#39;s failure to assert any right or provision under this Agreement shall not constitute a waiver of such right or provision. YOU AND '.config('app.name').' AGREE THAT ANY CAUSE OF ACTION ARISING OUT OF OR RELATED TO THE SERVICES MUST COMMENCE WITHIN ONE (1) YEAR AFTER THE CAUSE OF ACTION ACCRUES. OTHERWISE, SUCH CAUSE OF ACTION IS PERMANENTLY BARRED.</p><h1>Waiver</h1><p>Except as provided herein, the failure to exercise a right or to require performance of an obligation under this Agreement shall not effect a party&#39;s ability to exercise such right or require such performance at any time thereafter nor shall be the waiver of a breach constitute waiver of any subsequent breach.</p><p>o failure to exercise, and no delay in exercising, on the part of either party, any right or any power under this Agreement shall operate as a waiver of that right or power. Nor shall any single or partial exercise of any right or power under this Agreement preclude further exercise of that or any other right granted herein. In the event of a conflict between this Agreement and any applicable purchase or other terms, the terms of this Agreement shall govern.</p><h1>Amendments to this Agreement</h1><p>'.config('app.name').' reserves the right, at its sole discretion, to modify or replace this Agreement at any time. If a revision is material we will provide at least 30 days&#39; notice prior to any new terms taking effect. What constitutes a material change will be determined at our sole discretion.</p><p>By continuing to access or use our website after any revisions become effective, you agree to be bound by the revised terms. If you do not agree to the new terms, you are no longer authorized to use '.config('app.name').'.</p><h1>Entire Agreement</h1><p>The Agreement constitutes the entire agreement between you and '.config('app.name').' regarding your use of the website and supersedes all prior and contemporaneous written or oral agreements between you and '.config('app.name').'.</p><p>You may be subject to additional terms and conditions that apply when you use or purchase other '.config('app.name').'&#39;s services, which '.config('app.name').' will provide to you at the time of such use or purchase.</p><h1>Updates to Our Terms</h1><p>We may change our Service and policies, and we may need to make changes to these Terms so that they accurately reflect our Service and policies. Unless otherwise required by law, we will notify you (for example, through our Service) before we make changes to these Terms and give you an opportunity to review them before they go into effect. Then, if you continue to use the Service, you will be bound by the updated Terms. If you do not want to agree to these or any updated Terms, you can delete your account.</p><h1>Intellectual Property</h1><p>The website and its entire contents, features and functionality (including but not limited to all information, software, text, displays, images, video and audio, and the design, selection and arrangement thereof), are owned by '.config('app.name').', its licensors or other providers of such material and are protected by MA and international copyright, trademark, patent, trade secret and other intellectual property or proprietary rights laws. The material may not be copied, modified, reproduced, downloaded or distributed in any way, in whole or in part, without the express prior written permission of '.config('app.name').', unless and except as is expressly provided in these Terms &amp; Conditions. Any unauthorized use of the material is prohibited.</p><h1>Agreement to Arbitrate</h1><p>This section applies to any dispute EXCEPT IT DOESN&rsquo;T INCLUDE A DISPUTE RELATING TO CLAIMS FOR INJUNCTIVE OR EQUITABLE RELIEF REGARDING THE ENFORCEMENT OR VALIDITY OF YOUR OR '.config('app.name').'&#39;s INTELLECTUAL PROPERTY RIGHTS. The term &ldquo;dispute&rdquo; means any dispute, action, or other controversy between you and '.config('app.name').' concerning the Services or this agreement, whether in contract, warranty, tort, statute, regulation, ordinance, or any other legal or equitable basis. &ldquo;Dispute&rdquo; will be given the broadest possible meaning allowable under law.</p><h1>Notice of Dispute</h1><p>In the event of a dispute, you or '.config('app.name').' must give the other a Notice of Dispute, which is a written statement that sets forth the name, address, and contact information of the party giving it, the facts giving rise to the dispute, and the relief requested. You must send any Notice of Dispute via email to: '.$email.'.</p><p>'.config('app.name').' will send any Notice of Dispute to you by mail to your address if we have it, or otherwise to your email address. You and '.config('app.name').' will attempt to resolve any dispute through informal negotiation within sixty (60) days from the date the Notice of Dispute is sent. After sixty (60) days, you or '.config('app.name').' may commence arbitration.</p><h1>Binding Arbitration</h1><p>If you and '.config('app.name').' don&rsquo;t resolve any dispute by informal negotiation, any other effort to resolve the dispute will be conducted exclusively by binding arbitration as described in this section. You are giving up the right to litigate (or participate in as a party or class member) all disputes in court before a judge or jury. The dispute shall be settled by binding arbitration in accordance with the commercial arbitration rules of the American Arbitration Association. Either party may seek any interim or preliminary injunctive relief from any court of competent jurisdiction, as necessary to protect the party&rsquo;s rights or property pending the completion of arbitration. Any and all legal, accounting, and other costs, fees, and expenses incurred by the prevailing party shall be borne by the non-prevailing party.</p><h1>Submissions and Privacy</h1><p>In the event that you submit or post any ideas, creative suggestions, designs, photographs, information, advertisements, data or proposals, including ideas for new or improved products, services, features, technologies or promotions, you expressly agree that such submissions will automatically be treated as non-confidential and non-proprietary and will become the sole property of '.config('app.name').' without any compensation or credit to you whatsoever. '.config('app.name').' and its affiliates shall have no obligations with respect to such submissions or posts and may use the ideas contained in such submissions or posts for any purposes in any medium in perpetuity, including, but not limited to, developing, manufacturing, and marketing products and services using such ideas.</p><h1>Promotions</h1><p>'.config('app.name').' may, from time to time, include contests, promotions, sweepstakes, or other activities (&ldquo;Promotions&rdquo;) that require you to submit material or information concerning yourself. Please note that all Promotions may be governed by separate rules that may contain certain eligibility requirements, such as restrictions as to age and geographic location. You are responsible to read all Promotions rules to determine whether or not you are eligible to participate. If you enter any Promotion, you agree to abide by and to comply with all Promotions Rules.</p><p>Additional terms and conditions may apply to purchases of goods or services on or through the Services, which terms and conditions are made a part of this Agreement by this reference.</p><h1>Typographical Errors</h1><p>In the event a product and/or service is listed at an incorrect price or with incorrect information due to typographical error, we shall have the right to refuse or cancel any orders placed for the product and/or service listed at the incorrect price. We shall have the right to refuse or cancel any such order whether or not the order has been confirmed and your credit card charged. If your credit card has already been charged for the purchase and your order is canceled, we shall immediately issue a credit to your credit card account or other payment account in the amount of the charge.</p><h1>Miscellaneous</h1><p>If for any reason a court of competent jurisdiction finds any provision or portion of these Terms &amp; Conditions to be unenforceable, the remainder of these Terms &amp; Conditions will continue in full force and effect. Any waiver of any provision of these Terms &amp; Conditions will be effective only if in writing and signed by an authorized representative of '.config('app.name').'. '.config('app.name').' will be entitled to injunctive or other equitable relief (without the obligations of posting any bond or surety) in the event of any breach or anticipatory breach by you. '.config('app.name').' operates and controls the '.config('app.name').' Service from its offices in MA. The Service is not intended for distribution to or use by any person or entity in any jurisdiction or country where such distribution or use would be contrary to law or regulation. Accordingly, those persons who choose to access the '.config('app.name').' Service from other locations do so on their own initiative and are solely responsible for compliance with local laws, if and to the extent local laws are applicable. These Terms &amp; Conditions (which include and incorporate the '.config('app.name').' Privacy Policy) contains the entire understanding, and supersedes all prior understandings, between you and '.config('app.name').' concerning its subject matter, and cannot be changed or modified by you. The section headings used in this Agreement are for convenience only and will not be given any legal import.</p><h1>Disclaimer</h1><p>'.config('app.name').' is not responsible for any content, code or any other imprecision.</p><p>'.config('app.name').' does not provide warranties or guarantees.</p><p>In no event shall '.config('app.name').' be liable for any special, direct, indirect, consequential, or incidental damages or any damages whatsoever, whether in an action of contract, negligence or other tort, arising out of or in connection with the use of the Service or the contents of the Service. The Company reserves the right to make additions, deletions, or modifications to the contents on the Service at any time without prior notice.</p><p>The '.config('app.name').' Service and its contents are provided &quot;as is&quot; and &quot;as available&quot; without any warranty or representations of any kind, whether express or implied. '.config('app.name').' is a distributor and not a publisher of the content supplied by third parties; as such, '.config('app.name').' exercises no editorial control over such content and makes no warranty or representation as to the accuracy, reliability or currency of any information, content, service or merchandise provided through or accessible via the '.config('app.name').' Service. Without limiting the foregoing, '.config('app.name').' specifically disclaims all warranties and representations in any content transmitted on or in connection with the '.config('app.name').' Service or on sites that may appear as links on the '.config('app.name').' Service, or in the products provided as a part of, or otherwise in connection with, the '.config('app.name').' Service, including without limitation any warranties of merchantability, fitness for a particular purpose or non-infringement of third party rights. No oral advice or written information given by '.config('app.name').' or any of its affiliates, employees, officers, directors, agents, or the like will create a warranty. Price and availability information is subject to change without notice. Without limiting the foregoing, '.config('app.name').' does not warrant that the '.config('app.name').' Service will be uninterrupted, uncorrupted, timely, or error-free.</p><h1>Contact Us</h1><p>Don&#39;t hesitate to contact us if you have any questions.</p><ul><li>Via Email: '.$email.'</li><li>Via this Link: '.$contactUs_url.'</li></ul>',
            'visibility' => 1
        ]);

        LegalPage::create([
            'title' => 'Cookie Policy',
            'slug' => 'cookie-policy',
            'content' => '<p>Updated at '.$date.'</p><h1>Definitions and key terms</h1><p>To help explain things as clearly as possible in this Cookie Policy, every time any of these terms are referenced, are strictly defined as:</p><ul><li>Cookie: small amount of data generated by a website and saved by your web browser. It is used to identify your browser, provide analytics, remember information about you such as your language preference or login information.</li><li>Company: when this policy mentions &ldquo;Company,&rdquo; &ldquo;we,&rdquo; &ldquo;us,&rdquo; or &ldquo;our,&rdquo; it refers to '.config('app.name').', that is responsible for your information under this Cookie Policy.</li><li>Device: any internet connected device such as a phone, tablet, computer or any other device that can be used to visit '.config('app.name').' and use the services.</li><li>Personal Data: any information that directly, indirectly, or in connection with other information &mdash; including a personal identification number &mdash; allows for the identification or identifiability of a natural person.</li><li>Service: refers to the service provided by '.config('app.name').' as described in the relative terms (if available) and on this platform.</li><li>Third-party service: refers to advertisers, contest sponsors, promotional and marketing partners, and others who provide our content or whose products or services we think may interest you.</li><li>Website: site, which can be accessed via this URL: '.env('APP_URL').'/</li></ul><h1>Introduction</h1><p>This Cookie Policy explains how '.config('app.name').' and its affiliates (collectively &quot;'.config('app.name').'&quot;, &quot;we&quot;, &quot;us&quot;, and &quot;ours&quot;), use cookies and similar technologies to recognize you when you visit our website, including without limitation '.env('APP_URL').'/ and any related URLs, mobile or localized versions and related domains / sub-domains (&quot;Websites&quot;). It explains what these technologies are and why we use them, as well as the choices for how to control them.</p><h1>What is a cookie?</h1><p>A cookie is a small text file that is stored on your computer or other internet connected device in order to identify your browser, provide analytics, remember information about you such as your language preference or login information. They&#39;re completely safe and can&#39;t be used to run programs or deliver viruses to your device.</p><h1>Why do we use cookies?</h1><p>We use first party and/or third party cookies on our website for various purposes such as:</p><ul><li>To facilitate the operation and functionality of our website;</li><li>To improve your experience of our website and make navigating around them quicker and easier;</li><li>To allow us to make a bespoke user experience for you and for us to understand what is useful or of interest to you;</li><li>To analyze how our website is used and how best we can customize it;</li><li>To identify future prospects and personalize marketing and sales interactions with it;</li><li>To facilitate the tailoring of online advertising to your interests.</li><li>You: a person or entity that is registered with '.config('app.name').' to use the Services.</li></ul><h1>What type of cookies does '.config('app.name').' use?</h1><p>Cookies can either be session cookies or persistent cookies. A session cookie expires automatically when you close your browser. A persistent cookie will remain until it expires or you delete your cookies. Expiration dates are set in the cookies themselves; some may expire after a few minutes while others may expire after multiple years. Cookies placed by the website you&rsquo;re visiting are called &ldquo;first party cookies&rdquo;.</p><p>Strictly Necessary cookies are necessary for our website to function and cannot be switched off in our systems. They are essential in order to enable you to navigate around the website and use its features. If you remove or disable these cookies, we cannot guarantee that you will be able to use our website.</p><p>We use the following types of cookies in our website:</p><h1>Essential Cookies</h1><p>We use essential cookies to make our website work. These cookies are strictly necessary to enable core functionality such as security, network management, your cookie preferences and accessibility. Without them you wouldn&#39;t be able to use basic services. You may disable these by changing your browser settings, but this may affect how the Websites function.</p><h1>Performance and Functionality Cookies</h1><p>These cookies are used to enhance the performance and functionality of our website but are non-essential to their use. However, without these cookies, certain functionality like videos may become unavailable or you would be required to enter your login details every time you visit the website as we would not be able to remember that you had logged in previously.</p><h1>Marketing Cookies</h1><p>These account-based marketing cookies enable us to identify future prospects and personalize sales and marketing interactions with them.</p><h1>Analytics and Customization Cookies</h1><p>These cookies collect information that is used to help us understand how our website is being used or how effective our marketing campaigns are, or to help us customize our website for you.</p><p>We use cookies served by Google Analytics to collect limited data directly from end-user browsers to enable us to better understand your use of our website. Further information on how Google collects and uses this data can be found at: https://www.google.com/policies/privacy/partners/. You can opt-out of all Google supported analytics on our Websites by visiting: https://tools.google.com/dlpage/gaoptout.</p><h1>Social Media Cookies</h1><p>These cookies are used when you share information using a social media sharing button or &ldquo;like&rdquo; button on our Site or you link your account or engage with our content on or through a social networking website such as Facebook, Twitter or Google+. The social network will record that you have done this. These cookies may also include certain code that has been placed on the platform to help track conversions from ads, optimize ads based on collected data, build targeted audiences for future ads, and remarket to qualified users who have already taken certain action on the platform.</p><h1>Third Party Cookies</h1><p>Some cookies that have been set on our website are not set on a first party basis by '.config('app.name').'. The Websites can be embedded with content from third parties to serve advertising. These third party service providers may set their own cookies on your web browser. Third party service providers control many of the performance and functionality, advertising, marketing and analytics cookies described above. We do not control the use of these third party cookies as cookies can only be accessed by the third party that originally set them.</p><h1>How you can manage cookies?</h1><p>Most browsers allow you to control cookies through their &#39;settings&#39; preferences. However, if you limit the ability of websites to set cookies, you may worsen your overall user experience, since it will no longer be personalized to you. It may also stop you from saving customized settings like login information. Browser manufacturers provide help pages relating to cookie management in their products.</p><p>Browser manufacturers provide help pages relating to cookie management in their products. Please see below for more information.</p><ul><li>Google Chrome</li><li>Internet Explorer</li><li>Mozilla Firefox</li><li>Safari (Desktop)</li><li>Safari (Mobile)</li><li>Android Browser</li><li>Opera</li><li>Opera Mobile</li></ul><h1>Blocking and disabling cookies and similar technologies</h1><p>Wherever you&#39;re located you may also set your browser to block cookies and similar technologies, but this action may block our essential cookies and prevent our website from functioning properly, and you may not be able to fully utilize all of its features and services. You should also be aware that you may also lose some saved information (e.g. saved login details, site preferences) if you block cookies on your browser. Different browsers make different controls available to you. Disabling a cookie or category of cookie does not delete the cookie from your browser, you will need to do this yourself from within your browser, you should visit your browser&#39;s help menu for more information.</p><h1>Changes To Our Cookie Policy</h1><p>We may change our Service and policies, and we may need to make changes to this Cookie Policy so that they accurately reflect our Service and policies. Unless otherwise required by law, we will notify you (for example, through our Service) before we make changes to this Cookie Policy and give you an opportunity to review them before they go into effect. Then, if you continue to use the Service, you will be bound by the updated Cookie Policy. If you do not want to agree to this or any updated Cookie Policy, you can delete your account.</p><h1>Your Consent</h1><p>By using our website, registering an account, or making a purchase, you hereby consent to our Cookie Policy and agree to its terms.</p><h1>Contact Us</h1><p>Don&#39;t hesitate to contact us if you have any questions regarding our Cookie Policy.</p><ul><li>Via Email: '.$email.'</li><li>Via this Link: '.$contactUs_url.'</li></ul>',
            'visibility' => 1
        ]);

        LegalPage::create([
            'title' => 'End-User License Agreement',
            'slug' => 'end-user-license-agreement',
            'content' => '<p>Updated at '.$date.'</p><p>'.config('app.name').' hereby grants you access to '.env('APP_URL').'/ (&ldquo;the Website&rdquo;) and invites you to purchase the services offered here.</p><h1>Definitions and key terms</h1><p>To help explain things as clearly as possible in this Eula, every time any of these terms are referenced, are strictly defined as:</p><ul><li>Cookie: small amount of data generated by a website and saved by your web browser. It is used to identify your browser, provide analytics, remember information about you such as your language preference or login information.</li><li>Company: when this policy mentions &ldquo;Company,&rdquo; &ldquo;we,&rdquo; &ldquo;us,&rdquo; or &ldquo;our,&rdquo; it refers to IRELAND LTD., '.$company_address.' that is responsible for your information under this Eula.</li><li>Country: where '.config('app.name').' or the owners/founders of '.config('app.name').' are based, in this case is Ireland</li><li>Service: refers to the service provided by '.config('app.name').' as described in the relative terms (if available) and on this platform.</li><li>Third-party service: refers to advertisers, contest sponsors, promotional and marketing partners, and others who provide our content or whose products or services we think may interest you.</li><li>Website: site, which can be accessed via this URL: '.env('APP_URL').'/</li><li>You: a person or entity that is registered with '.config('app.name').' to use the Services.</li></ul><h1>Introduction</h1><p>This End User License Agreement (the &ldquo;Agreement&rdquo;) is a binding agreement between you (&ldquo;End User&rdquo;,&ldquo;you&rdquo; or &ldquo;your&rdquo;) and IRELAND LTD. (&ldquo;Company&rdquo;, &ldquo;we&rdquo;, &ldquo;us&rdquo; or &ldquo;our&rdquo;). This Agreement governs the relationship between you and us, and your use of the Company '.config('app.name').'. Throughout this Agreement, End User and Company may each be referred to as a &ldquo;Party&rdquo; or collectively, the &ldquo;Parties&rdquo;.</p><p>If you are using the website on behalf of your employer or other entity (an &ldquo;Organisation&rdquo;) for whose benefit you utilise the website or who owns or otherwise controls the means through which you utilise or access the website, then the terms &ldquo;End User&rdquo;, &ldquo;you&rdquo;, and &ldquo;your&rdquo; shall apply collectively to you as an individual and to the Organisation. If you use, or purchase a license or to, the website on behalf of an Organisation, you hereby acknowledge, warrant, and covenant that you have the authority to 1) purchase a license to the website on behalf of the Organisation; 2) bind the Organisation to the terms of this Agreement.</p><p>By downloading, installing, accessing, or using the website you: (a) affirm that you have all of the necessary permissions and authorisations to access and use the website; (b) if you are using the website pursuant to a license purchased by an organisation, that you are authorised by that organisation to access and use the website(c) acknowledge that you have read and that you understand this agreement; (d) represent that you are of sound mind and of legal age (18 years of age or older) to enter into a binding agreement; and (e) accept and agree to be legally bound by the terms and conditions of this agreement.</p><p>If you do not agree to these terms, do not download, install, access, or use the software. if you have already downloaded the software, delete it from your computing device.</p><p>The Application is licensed, not sold, to you by '.config('app.name').' for use strictly in accordance with the terms of this Agreement.</p><h1>License</h1><p>Subject to the terms of this Agreement and, if applicable, those terms provided in the License Agreement, '.config('app.name').' grants you a limited, non-exclusive, perpetual, revocable, and non-transferable license to:</p><p>(a) download, install and use the Software on one (1) Computing Device per single user license that you have purchased and been granted. If you have multiple Computer Devices in which you wish to use the Software, you agree to acquire a license for the number of devices you intend to use;</p><p>(b) access, view, and use on such Computing Device the End User Provided Materials made available in or otherwise accessible through the Software, strictly in accordance with this Agreement, and any other terms and conditions applicable to such End User Provided Materials;</p><p>(c) install and use the trial version of the Software on any number of Computing Devices for a trial period of fifteen (15) unique days after installation.</p><p>(d) receive updates and new features that become available during the one (1) year period from the date on which you purchased the license to the Software.</p><h1>Restrictions</h1><p>You agree not to, and you will not permit others to:</p><ul><li>License, sell, rent, lease, assign, distribute, transmit, host, outsource, disclose or otherwise commercially exploit the Application or make the Application available to any third party.</li><li>Modify, make derivative works of, disassemble, decrypt, reverse compile or reverse engineer any part of the Application.</li><li>Remove, alter or obscure any proprietary notice (including any notice of copyright or trademark) of '.config('app.name').' or its affiliates, partners, suppliers or the licensors of the Application.</li></ul><h1>Intellectual Property</h1><p>All intellectual property rights, including copyrights, patents, patent disclosures and inventions (whether patentable or not), trademarks service marks, trade secrets, know-how and other confidential information, trade dress, trade names, logos, corporate names and domain names, together with all of the good will associated there with, derivative works and all other rights (collectively, &ldquo;Intellectual Property Rights&rdquo;) that are part of the Software that are otherwise owned by '.config('app.name').' shall always remain the exclusive property of '.config('app.name').' (or of its suppliers or licensors, if and when applicable). Nothing in this Agreement grants you (or any Organisation) a license to Intellectual Property Rights.</p><p>You agree that this is Agreement conveys a limited license to use Intellectual Property Rights, solely as part of the Software (and not independently of it), and only for the effective Term of the license granted to you hereunder. Accordingly, your use of any of Intellectual Property Rights independently of the Software or outside the scope of this Agreement shall be considered an infringement of Intellectual Property Rights. This shall not limit, however, any claim '.config('app.name').' may have for a breach of contract in the event you breach a term or condition of this Agreement. You shall use the highest standard of care to safeguard all Software (including all copies thereof) from infringement, misappropriation, theft, misuse or unauthorised access. Except as expressly granted in this Agreement, '.config('app.name').' reserves and shall retain all rights, title, and interest in the Software, including all copyrights and copyrightable subject matter, trademarks and trademark able subject matter, patents and patentable subject matter, trade secrets, and other intellectual property rights, registered, unregistered, granted, applied-for, or both now in existence or that may be created, relating to the thereto.</p><p>You (or the Organisation, if and as applicable) shall retain ownership of all Intellectual Property Rights in and to the work products that you create through or with the assistance of the Software.</p><h1>Your Suggestions</h1><p>Any feedback, comments, ideas, improvements or suggestions (collectively, &quot;Suggestions&quot;) provided by you to '.config('app.name').' with respect to the Application shall remain the sole and exclusive property of '.config('app.name').'.</p><p>'.config('app.name').' shall be free to use, copy, modify, publish, or redistribute the Suggestions for any purpose and in any way without any credit or any compensation to you.</p><h1>Modifications to Application</h1><p>'.config('app.name').' reserves the right to modify, suspend or discontinue, temporarily or permanently, the Application or any service to which it connects, with or without notice and without liability to you.</p><h1>Updates to Application</h1><p>'.config('app.name').' may from time to time provide enhancements or improvements to the features/ functionality of the Application, which may include patches, bug fixes, updates, upgrades and other modifications (&quot;Updates&quot;).</p><p>Updates may modify or delete certain features and/or functionalities of the Application. You agree that '.config('app.name').' has no obligation to (i) provide any Updates, or (ii) continue to provide or enable any particular features and/or functionalities of the Application to you.</p><p>You further agree that all Updates will be (i) deemed to constitute an integral part of the Application, and (ii) subject to the terms and conditions of this Agreement.</p><h1>Term and Termination</h1><p>This Agreement shall remain in effect until terminated by you or '.config('app.name').'.</p><p>'.config('app.name').' may, in its sole discretion, at any time and for any or no reason, suspend or terminate this Agreement with or without prior notice.</p><p>This Agreement will terminate immediately, without prior notice from '.config('app.name').', in the event that you fail to comply with any provision of this Agreement. You may also terminate this Agreement by deleting the Application and all copies thereof from your computer.</p><p>Upon termination of this Agreement, you shall cease all use of the Application and delete all copies of the Application from your computer.</p><p>Termination of this Agreement will not limit any of rights or remedies at law or in equity in case of breach by you (during the term of this Agreement) of any of your obligations under the present Agreement.</p><h1>Indemnification</h1><p>You agree to indemnify, defend and hold harmless '.config('app.name').' and its officers, directors, employees, agents, affiliates, successors, and assigns from and against any and all losses, damages, liabilities, deficiencies, claims, actions, judgments, settlements, interest, awards, penalties, fines, costs, or expenses of whatever kind, including reasonable attorneys&rsquo; fees, arising from or relating to: i) your use or misuse of the Software; ii) your failure to comply with any applicable law, regulation, or government directive; iii) your breach of this Agreement; or iv) your agreement or relationship with an Organisation (if applicable) or any third party. Furthermore, you agree that '.config('app.name').' assumes no responsibility for the information or content you submit or make available through this Software or the content that is made available to you by third parties.</p><h1>No Warranties</h1><p>The Application is provided to you &quot;AS IS&quot; and &quot;AS AVAILABLE&quot; and with all faults and defects without warranty of any kind. To the maximum extent permitted under applicable law, '.config('app.name').', on its own behalf and on behalf of its affiliates and its and their respective licensors and service providers, expressly disclaims all warranties, whether express, implied, statutory or otherwise, with respect to the Application, including all implied warranties of merchantability, fitness for a particular purpose, title and non-infringement, and warranties that may arise out of course of dealing, course of performance, usage or trade practice. Without limitation to the foregoing, '.config('app.name').' provides no warranty or undertaking, and makes no representation of any kind that the Application will meet your requirements, achieve any intended results, be compatible or work with any other software, applications, systems or services, operate without interruption, meet any performance or reliability standards or be error free or that any errors or defects can or will be corrected.</p><p>Without limiting the foregoing, neither '.config('app.name').' nor any provider makes any representation or warranty of any kind, express or implied: (i) as to the operation or availability of the Application, or the information, content, and materials or products included thereon; (ii) that the Application will be uninterrupted or error-free; (iii) as to the accuracy, reliability, or currency of any information or content provided through the Application; or (iv) that the Application, its servers, the content, or e-mails sent from or on behalf of '.config('app.name').' are free of viruses, scripts, trojan horses, worms, malware, time bombs or other harmful components.</p><p>Some jurisdictions do not allow the exclusion of or limitations on implied warranties or the limitations on the applicable statutory rights of a consumer, so some or all of the above exclusions and limitations may not apply to you.</p><h1>Limitation of Liability</h1><p>Notwithstanding any damages that you might incur, the entire liability of '.config('app.name').' and any of its suppliers under any provision of this Agreement and your exclusive remedy for all of the foregoing shall be limited to the amount actually paid by you for the Application.</p><p>To the maximum extent permitted by applicable law, in no event shall '.config('app.name').' or its suppliers be liable for any special, incidental, indirect, or consequential damages whatsoever (including, but not limited to, damages for loss of profits, for loss of data or other information, for business interruption, for personal injury, for loss of privacy arising out of or in any way related to the use of or inability to use the Application, third-party software and/or third-party hardware used with the Application, or otherwise in connection with any provision of this Agreement), even if '.config('app.name').' or any supplier has been advised of the possibility of such damages and even if the remedy fails of its essential purpose.</p><p>Some states/jurisdictions do not allow the exclusion or limitation of incidental or consequential damages, so the above limitation or exclusion may not apply to you.</p><h1>Severability</h1><p>If any provision of this Agreement is held to be unenforceable or invalid, such provision will be changed and interpreted to accomplish the objectives of such provision to the greatest extent possible under applicable law and the remaining provisions will continue in full force and effect.</p><h1>Waiver</h1><p>No failure to exercise, and no delay in exercising, on the part of either party, any right or any power under this Agreement shall operate as a waiver of that right or power. Nor shall any single or partial exercise of any right or power under this Agreement preclude further exercise of that or any other right granted herein. In the event of a conflict between this Agreement and any applicable purchase or other terms, the terms of this Agreement shall govern.</p><h1>Amendments to this Agreement</h1><p>'.config('app.name').' reserves the right, at its sole discretion, to modify or replace this Agreement at any time. If a revision is material we will provide at least 30 days&#39; notice prior to any new terms taking effect. What constitutes a material change will be determined at our sole discretion.</p><p>By continuing to access or use our Application after any revisions become effective, you agree to be bound by the revised terms. If you do not agree to the new terms, you are no longer authorized to use the Application.</p><h1>Governing Law</h1><p>The laws of Ireland, excluding its conflicts of law rules, shall govern this Agreement and your use of the Application. Your use of the Application may also be subject to other local, state, national, or international laws.</p><h1>Changes to this agreement</h1><p>We reserve the exclusive right to make changes to this Agreement from time to time. Your continued access to and use of the website constitutes your agreement to be bound by, and your acceptance of, the terms and conditions posted at such time. You acknowledge and agree that you accept this Agreement (and any amendments thereto) each time you load, access, or use the website. Therefore, we encourage you to review this Agreement regularly.</p><p>If, within thirty (30) days of us posting changes or amendments to this Agreement, you decide that you do not agree to the updated terms, you may withdraw your acceptance to the amended terms by providing us with written notice of your withdrawal. Upon providing us with the written notice of the withdrawal of your acceptance, you are no longer authorised to access or use the website.</p><h1>No Employment or Agency Relationship</h1><p>No provision of this Agreement, or any part of relationship between you and '.config('app.name').', is intended to create nor shall they be deemed or construed to create any relationship between you and '.config('app.name').' other than that of and end user of the website and services provided.</p><h1>Equitable Relief</h1><p>You acknowledge and agree that your breach of this Agreement would cause '.config('app.name').' irreparable harm for which money damages alone would be inadequate. In addition to damages and any other remedies to which '.config('app.name').' may be entitled, you acknowledge and agree that we may seek injunctive relief to prevent the actual, threatened or continued breach of this Agreement.</p><h1>Headings</h1><p>The headings in this Agreement are for reference only and shall not limit the scope of, or otherwise affect, the interpretation of this Agreement.</p><h1>Geographic Restrictions</h1><p>The Company is based in Ireland and provided for access and use primarily by persons located in Ireland, and is maintains compliance with Ireland laws and regulations. If you use the website from outside Ireland, you are solely and exclusively responsible for compliance with local laws.</p><h1>Limitation of Time to File Claims</h1><p>Any cause of action or claim you may have arising out of or relating to this agreement or the website must be commenced within one (1) year after the cause of action accrues, otherwise, such cause of action or claim is permanently barred.</p><h1>Entire Agreement</h1><p>The Agreement constitutes the entire agreement between you and '.config('app.name').' regarding your use of the Application and supersedes all prior and contemporaneous written or oral agreements between you and '.config('app.name').'.</p><p>You may be subject to additional terms and conditions that apply when you use or purchase other services, which '.config('app.name').' will provide to you at the time of such use or purchase.</p><h1>Contact Us</h1><p>Don&#39;t hesitate to contact us if you have any questions about this Agreement.</p><ul><li>Via Email: '.$email.'</li><li>Via this Link: '.$contactUs_url.'</li></ul>',
            'visibility' => 1
        ]);

        // $whatsapp_link = Config::whereName('whatsapp_link')->first()->value;
        // LegalPage::create([
        //     'title' => 'Refund Policy',
        //     'slug' => 'refund-policy',
        //     'content' => '<h1>General :</h1><p>At '.config('app.name').', we want to ensure that you are 100% happy with your purchase. If you have any technical or sales queries, do not hesitate to contact us. However, if you feel the service you purchased is not the best fit for your requirements and you attempted to resolve issues with our support staff, we want to make things right.</p><p><strong style="color: red">As we do have The Trial, we don&rsquo;t give a refund</strong>.</p><p>But in some cases, under circumstances that our financial team study in details, we can approve a refund.&nbsp;Although we&rsquo;d love to know where things went wrong, or how we can improve.</p><br>Check <a target="_blank" href="'.route('page', 'cancellation-policy').'">Cancellation Page</a><h2>YOU HAVE 3 DAYS TO ASK FOR A REFUND SINCE DATE OF YOUR PURCHASE.</h2><h2>AFTER 3 DAYS, NO REFUND REQUESTS ARE ACCEPTED.</h2><p>If your refund request gets approved, follow the steps below for a&nbsp;partial refund&nbsp;within 3 days of your date of purchase. if the 3 days have been passed and you have a problem you can contact any time via WhatsApp SUPPORT number or via the Contact us page to fix your problem.</p><h3>Once you requested a refund you can&rsquo;t subscribe again to our service at any time in the future.</h3><p><br><strong>Follow the steps below to get your refund request sent to us :</strong></p><ul><li>Use <a href="'.$whatsapp_link.'">the Whatsapp Support</a> or contact form to request the refund.</li><li>Provide your username and same email address you use to buy our services.</li><li>Include your invoice number.</li><li>Note that the refund will be only partial, we will deduct the price of number of days used&nbsp;<strong>(4.3 US$ per day)</strong></li><li>Credit Card charge fees cannot be refunded as they go straight to your bank.</li><li>Payment will be done to the same method of payment used.</li></ul>',
        //     'visibility' => 1
        // ]);

        LegalPage::create([
            'title' => 'Cancellation Policy',
            'slug' => 'cancellation-policy',
            'content' => '<p><span>Please be noticed that orders only can be cancelled or modified within 2 hours after being placed.</span></p><p><span>If you want&nbsp; to modify or cancel your order, please contact us&nbsp;<a href="'.route('contactus').'"><strong>HERE&nbsp;</strong></a></span><span>to send your request, our customer support team is willing to support you.</span></p><p><span>Please notice:</span></p><p><span>*If your order has been processed already, you cannot cancel or modify it, therefore, please contact our Customer Service&nbsp;<a href="'.route('contactus').'"><strong>HERE&nbsp;</strong></a></span><span>as quickly as possible.&nbsp;</span></p><p><span>*If you insist to cancel/modify a processing order, you might be <strong style="color: red">charged 50% the payment</strong>.&nbsp;</span></p><p><span>*If your order was shipped out already, nothing can be changed any longer.</span></p>',
            'visibility' => 1
        ]);

    }
}
