<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ContactMail extends Mailable
{
    use Queueable, SerializesModels;

    public $message, $subject, $email;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($message, $subject, $email)
    {
        $this->message = $message;
        $this->subject = $subject;
        $this->email = $email;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject($this->subject.' [ Contact Page ]')
                    ->markdown('mails.contact_us');
    }
}
