<?php $__env->startSection('title', config('app.name').' || Cart'); ?>
<?php $__env->startSection('extra_css'); ?>
<style>
#shopping-cart .checkout a {
    background: #030e2e;
    padding: 13px 81px;
    font-size: 21px;
    font-weight: 600;
}
#shopping-cart .checkout a:hover {
    background: #010616;
    transition: 0.3s;
}

.table>:not(caption)>*>* {
    border: none;
}

table.table {
    border-radius: 8px;
    overflow: hidden;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <div id="shopping-cart">
        <?php if($items->count()>0): ?>
        <?php if(session()->has('success')): ?>
        <div class="alert alert-success" role="alert">
            <?php echo e(session()->get('success')); ?>

        </div>
        <?php endif; ?>
        <div class="row justify-content-center">
            <div class="col-md-12">
                <h2>Cart</h2>
                <table class="table">
                    <thead>
                        <tr class="header">
                           <th scope="col">#</th>
                           <th scope="col"></th>
                           <th scope="col">Product</th>
                           <th scope="col">Price</th>
                           <th scope="col">Quantity</th>
                           <th scope="col">Subtotal</th>
                        </tr>
                     </thead>
                     <tbody>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                           <th scope="row">
                              <div class="ceil_flex">
                                 <a class="remove_cart_item" href="<?php echo e(route('cart.remove', $item->rowId)); ?>">
                                 <i class="fa fa-close"></i>
                                 </a>
                              </div>
                           </th>
                           <td>
                              <div class="ceil_flex">
                                 <img class="poster" width="60" src="<?php echo e(asset($item->model->poster)); ?>" alt="<?php echo e($item->title); ?>">
                              </div>
                           </td>
                           <td>
                              <div class="ceil_flex title">
                                 <?php echo e($item->name); ?>

                              </div>
                           </td>
                           <td>
                              <div class="ceil_flex">
                                 <?php echo e($item->price); ?> $
                              </div>
                           </td>
                           <td>
                              <div class="ceil_flex">                                
                                 x<?php echo e($item->qty); ?>

                           </td>
                           </div>
                           <td>
                              <div class="ceil_flex">                                
                                 <?php echo e($item->subtotal()); ?> $
                              </div>
                           </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-center">
                <div class="cart_summary">
                    <h3>Summary</h3>
                    <ul>
                        <li>
                            <span class="name">subtotal</span>
                            <span class="value"><?php echo e(Cart::subtotal()); ?> $</span>
                        </li>
                        <li>
                            <span class="name">shipping</span>
                            <span class="value">Free shipping</span>
                        </li>
                        <li>
                            <span class="name">total</span>
                            <span class="value"><?php echo e(Cart::total()); ?> $</span>
                        </li>
                        <li>
                            <a class="btn btn-primary checkout" href="<?php echo e(route('checkout')); ?>">proceed to checkout</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <?php else: ?>
        <div class="cart-empty">
            <h1>Your Shopping Cart Is Empty !</h1>
            <a href="<?php echo e(route('home')); ?>">Continue Shopping</a>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_js'); ?>
<script>
    $(document).ready(() => {
        $(".alert-success").fadeTo(2000, 500).slideUp(500, function(){
            $(".alert-success").slideUp(500);
        });
    })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\gymstore.test\resources\views/cart.blade.php ENDPATH**/ ?>