<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Checkout</title>
    <style>
        @import  url('https://fonts.googleapis.com/css2?family=Outfit:wght@400;500;600;800&display=swap');
        body {
            background: <?php echo e($background_color); ?>;
            font-family: 'Outfit', sans-serif;
        }
#app {
    color: white;
    width: 55%;
    margin: 0 auto;
    text-align: center;
}

.logo {
    margin-top: 60px
}

h2.title {
    text-transform: uppercase;
    font-size: 19px;
    color: #dadada;
    background: #ffffff0f;
    margin: 0 0 10px 0;
    padding: 10px;
    font-weight: 600;
    border-radius: 11px;
}

div#content {
    background: #00000047;
    padding: 39px 34px;
    border-radius: 19px;
    margin: 16px 0px;
}

.order {
    display: flex;
    align-items: center;
}

.order ul.order_details {
    border-radius: 11px;
    width: 20%;
    margin: 0;
    padding: 0;
    list-style: none;
    flex: 2;
}

.order ul.order_details li {
    background: #ffffff14;
    margin: 13px 0;
    padding: 11px 16px;
    border-radius: 9px;
    text-align: left;
    font-size: 14px;
    color: #d8d8d8;
    font-weight: 800;
}

.order ul.order_details li.total {
    background: #ffffff4a;
    font-weight: 800;
    font-size: 16px;
}

.order ul.order_details li span.value {
    float: right;
}

.order .payment_container {
    flex: 3;
    margin-left: 20px;
}

.order .payment_container .header {
    background: #ffffff0f;
    padding: 16px 9px;
    border-radius: 11px 11px 0 0;
    font-weight: 600;
}

.order .payment_container .payment_bx {
    background: #ffffffbf;
    border-radius: 0 0 11px 11px;
    padding: 18px 9px 0;
}


/**
* RESPONSIVE
*/
@media (max-width: 1200px) {
    #app {
        width: 87%;
    }
}

@media (max-width: 992px) {
    #app {
        width: 100%;
    }
}

@media (max-width: 711px) {

    .order {
        flex-direction: column
    }

    .order ul.order_details, .order .payment_container {
        width: 100%;
    }
    .order .payment_container {
        margin-top: 15px;
        margin-left: 0
    }
}

@media (max-width: 576px) {
    div#content {
        padding: 12px 15px;
    }
    .logo {
        margin-top: 10px;
    }
}

    </style>
</head>
<body>
    <div id="app">
        <img class="logo" width="140px" src="<?php echo e(asset('storage/'.$iptv_logo)); ?>" alt="">
        <div id="content">
            <div class="order">
                <ul class="order_details">
                    <li>
                        <span class="name"><?php echo e($product_name); ?></span>
                        <span class="value"><?php echo e($subtotal.$currency['symbol']); ?></span>
                    </li>
                    <?php if( $adult == 1 ): ?>                        
                    <li>
                        <span class="name">Adult</span>
                        <span class="value"><?php echo e($adult_price.$currency['symbol']); ?></span>
                    </li>
                    <?php endif; ?>
                    <?php if( $fastdelivery == 1 ): ?>                        
                    <li>
                        <span class="name">Fast Delivery</span>
                        <span class="value"><?php echo e($fastdelivery_price.$currency['symbol']); ?></span>
                    </li>
                    <?php endif; ?>
                    <li>
                        <span class="name">Setup Fees</span>
                        <span class="value">0<?php echo e($currency['symbol']); ?></span>
                    </li>
                    <li class="total">
                        <span class="name">Total</span>
                        <span class="value" style="color: lime"><?php echo e($total.' '.$currency['code']); ?></span>
                    </li>
                </ul>
                <div class="payment_container">
                    <h2 class="title">Order N° <span style="color: lime">#<?php echo e($order_id); ?></span></h2>
                    <div class="header">
                        <span>PayPal ( Credit / Debit Cards )</span>
                    </div>
                    <div class="payment_bx">
                        <form id="submit-payment" action="<?php echo e(route('complete_iptv_payment')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="order_id" value="<?php echo e($order_id); ?>">
                            <input type="hidden" name="uuid" value="<?php echo e($uuid); ?>">
                            <input type="hidden" name="user_id" value="<?php echo e($user_id); ?>">
                            <input type="hidden" name="gateway" value="paypal">
                            <input type="hidden" name="first_name" id="first_name">
                            <input type="hidden" name="last_name" id="last_name">
                            <input type="hidden" name="country" id="country">
                            <input type="hidden" name="customer_id" id="customer_id">
                            <input type="hidden" name="transaction_id" id="transaction_id">
                            <input type="hidden" name="paypal_email" id="paypal_email">
                            <input type="hidden" name="ppl_id" value="<?php echo e($paypal_id); ?>">
                        </form>
                        <div id="paypal-button-container"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<script src="https://www.paypal.com/sdk/js?client-id=<?php echo e($clientid); ?>&currency=<?php echo e($currency['code']); ?>"></script>

    <script>
        paypal.Buttons({
                    style: {
                        color: 'blue',
                        shape:  'pill',
                        label:  'paypal',
                    },
                    createOrder: function(data, actions) {
                        return actions.order.create({
                            purchase_units: [{
                                amount: {
                                    value: <?php echo e($total); ?>

                                }
                            }]
                        });
                    },
                    onApprove: function(data, actions) {
                        return actions.order.capture().then(function(details) {
                            if(  details.status == "COMPLETED"  ) {
                                document.getElementById('first_name').value = details.payer.name.given_name
                                document.getElementById('last_name').value = details.payer.name.surname
                                document.getElementById('customer_id').value = details.payer.payer_id
                                document.getElementById('transaction_id').value = details.purchase_units[0].payments.captures[0].id
                                document.getElementById('paypal_email').value = details.payer.email_address
                                if( details.purchase_units[0].shipping) {
                                    document.getElementById('country').value = details.purchase_units[0].shipping.address.country_code
                                }
                                document.getElementById('submit-payment').submit()
                            }else alert("Payment declined");
                        });
                    },
                    onCancel: () => {
                        alert('Payment Cancelled!!')
                    }
                }).render('#paypal-button-container')
    </script>
    
</body>
</html><?php /**PATH C:\xampp\htdocs\store.test\resources\views/checkout_iptv.blade.php ENDPATH**/ ?>