<?php $__env->startSection('title', 'Insert New Product'); ?>
<?php $__env->startSection('content'); ?>
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="<?php echo e(route('admin.products')); ?>" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
 </div>
<div class="card card-default color-palette-box admin_product">
    <div class="card-body">
        <form action="<?php echo e(route('admin.product_save')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="mb-3 col-md-9">
                    <label for="title" class="form-label">Title</label>
                    <input type="text" name="title" class="form-control" placeholder="Title" id="title">
                </div>
                <div class="col-md-2 select">
                    <label for="visibility" class="form-label">Visible</label>
                    <select name="visibility">
                        <option value="0" selected>NO</option>
                        <option value="1">YES</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="mb-3 col-md-2">
                    <label for="price" class="form-label">Price</label>
                    <input type="text" name="price" class="form-control" id="price" value="0">
                </div>
                <div class="mb-3 col-md-2">
                    <label for="old_price" class="form-label">Old Price</label>
                    <input type="text" name="old_price" class="form-control" id="old_price" value="0">
                </div>
                <div class="mb-3 col-md-8">
                    <label for="short_title" class="form-label">Short Title</label>
                    <input type="text" name="short_title" class="form-control" id="short_title" placeholder="Short Title">
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 select">
                    <label for="category" class="form-label">Category</label>
                    <select name="category_id">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category->id); ?>" <?php if($category->name == 'Other'): ?> selected <?php endif; ?>><?php echo e($category->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3 select">
                    <label for="hot" class="form-label">Hot</label>
                    <select name="hot">
                        <option value='1'>YES</option>
                        <option value='0'>NO</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 mb-3">
                    <label for="poster" class="form-label">Poster</label>
                    <input type="file" class="form-file-input form-control" name="poster" id="poster">
                </div>
                <div class="col-md-8">
                    <label for="tags" class="form-label">Tags</label>
                    <input type="text" name="tags" class="form-control" id="tags" placeholder="tags ...">
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <label for="description" class="form-label">Description</label>
                    <textarea rows="30" class="ckeditor form-control" id="description" name="description"></textarea>
                </div>
            </div>
            <div class="mb-3">
                <button class="btn btn-primary" type="submit">INSERT</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script>
    $(document).ready(function () {
        $('.ckeditor').ckeditor();
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\gymstore.test\resources\views/admin/product_insert.blade.php ENDPATH**/ ?>