@extends('layouts.app')
@section('title', config('app.name').' || '.$product->title)
@section('content')
<div class="container">
    <div id="product">
        @if(session()->has('error'))
        <div class="alert alert-danger" role="alert">
            {{session()->get('error')}}
        </div>
        @endif
        <div class="row">
            <div class="poster col-md-5">
                <img src="{{asset('storage/'.$product->poster)}}" alt="{{$product->title}}" title="{{$product->title}}">
            </div>
            <div class="col-md-6">
                @auth
                <a href="{{route('admin.product_edit', $product->id)}}"><i class="fa fa-pencil"></i></a>
                @endauth
                <h1 title="{{$product->title}}" class="title">{{$product->title}}</h1>
                <div class="price_section">
                    <span class="price">{{$product->price}}$</span>
                    <span class="old_price">{{$product->old_price}}$</span>
                </div>
                @if ($product->in_stock == "1")
                <div class="quantity col-md-3">
                    <i class="increase_q fa fa-minus"></i>
                    <input type="number" name="quantity" class="quantity_value" value="1">
                    <i class="decrease_q fa fa-plus"></i>
                </div>
                @endif
                @if ($product->in_stock == "0")
                <span class="sold_out"><i class="fa fa-close"></i> sold out</span>
                @else
                <button type="button" class="order_btn animate__animated animate__pulse col-md-7">order now</button>
                @endif
                <ul class="box-under">
                    <li>
                        <i class="fa fa-cloud-download"></i>
                        <p>Digital Download</p>
                    </li>
                    <li>
                        <i class="fa fa-eye"></i>
                        <p>Instant Access</p>
                    </li>
                    <li>
                        <i class="fa fa-lock"></i>
                        <p>Secure Payment</p>
                    </li>
                    <li>
                        <i class="fa fa-modx"></i>
                        <p>100% Guaranteed</p>
                    </li>
                    <li>
                        <i class="fa fa-medium"></i>
                        <p>Free Shipping</p>
                    </li>
                    <li class="category">
                        <span class="name">Category :</span>
                        <a href="{{route('category', $product->category->slug)}}">{{$product->category->name}}</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <div id="description">
        {!!$product->description!!}
    </div>
</div>
@endsection
@section('extra_js')
<script>
    var app_env = '{{env('APP_ENV')}}'
    $(document).ready(() => {
        $('i.increase_q').on('click', () => {
            const old_value = parseInt($('input.quantity_value').val())
            if( old_value > 1 ) {
                $('input.quantity_value').val(old_value - 1)
            }
        })

        $('i.decrease_q').on('click', () => {
            const old_value = parseInt($('input.quantity_value').val())
            if( old_value < 3 ) {
                $('input.quantity_value').val(old_value + 1)
            }
        })

        $('.order_btn').click(function() {
            var url = "{{route('cart.store', [ 'id' => $product->id ])}}"
            // var url = "{{route('cart.store', [ 'id' => 1 ])}}"
            if(app_env == 'production') {
                url = url.replace('http://', 'https://')
            }
            var qty = parseInt($('input.quantity_value').val())
            if( qty <= 3 ) {
                if( qty >= 1 ) {
                    window.location.href = url+"&q="+qty
                }else alert('You Can Order Only 3 items Maximum')
            }else alert('You Can Order Only 3 items Maximum')
        })
        $(".alert-danger").fadeTo(2000, 1000).slideUp(1000, function(){
            $(".alert-danger").slideUp(1000);
        });
    })
</script>
@endsection