@extends('layouts.adminapp')
@section('title', 'Categories')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="{{route('admin.category_insert')}}" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Category</a>
</div>
<div class="card card-default color-palette-box">
    @if( session()->has('success') )
    <span class="badge bg-success"> {{session()->get('success')}} </span>
    @endif
    <div class="card-body">
        @if (count($categories) > 0)
        <form method="POST" action="{{route('admin.categories_update')}}">
            @csrf
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col"></th>
                        <th scope="col">Name</th>
                        <th scope="col">Slug</th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>
                @foreach($categories as $category)
                <tr class="product-table">
                    <td>{{$category->id}}<input type="hidden" name="id[]" value="{{$category->id}}"></td>
                    <td><input class="form-control" type="text" name="name[]" value="{{$category->name}}"></td>
                    <td><input class="form-control" type="text" name="slug[]" value="{{$category->slug}}"></td>
                    <td class="actions">
                        <a class="remove_category" data-id="{{$category->id}}" href="#"><i class="edit fa fa-trash"></i></a>
                    </td>
                </tr>
                @endforeach
                </tbody>
            </table>
            <button class="btn btn-primary">Update</button>
        <form>
        @else
       <h3>No Categories</h3>
       @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script>
  $(document).ready(() => {
      $('.remove_category').on('click', function(e) {
        e.preventDefault()
        var confirmA = confirm('Delete Type ?')
        var category_id = $(this).attr('data-id')
        var link = "{{route('admin.category_delete', 0)}}"
        if(confirmA) {
          window.location.href = link.replace('/0', '/'+category_id)
        }
      });
  })
</script>
@endsection

@section('extra_css')
    <style>
      td.title {
        background: #eee;
        width: 100%;
        padding: 7px;
        display: inline-block;
        color: #333;
      }
    </style>
@endsection