<?php

namespace Database\Seeders;

use App\Models\Product;
use Illuminate\Support\Facades\File;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * MUG;
        */
        File::copy(public_path('images/products/9.png'), 'storage/app/public/9.png');
        Product::create([
            'category_id' => 1,
            'title' => 'Personalized Apparently We\'re Trouble Together BF Mug',
            'short_title' => 'We\'re Trouble Together BF Mug',
            'slug' => 'personalized-apparently-we-are-trouble-together-bf-mug',
            'poster' => '9.png',
            'description' => '<p>Perfect for coffee, tea and hot chocolate, this classic shape white, durable ceramic mug comes in the most popular size. High quality sublimation printing makes it an appreciated gift to every true hot beverage lover.</p><ul><li>White ceramic</li><li>11 oz (0.33 l)</li><li>Rounded corners</li><li>C-handle</li><li>Lead and BPA-free</li></ul>',
            'price' => 20.99,
            'old_price' => 39.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);

        File::copy(public_path('images/products/10.png'), 'storage/app/public/10.png');
        Product::create([
            'category_id' => 1,
            'title' => 'Creative Cartoon Panda Ceramic Cup Children\'s Cute Cover Original Black and White Mug Original and Funny Cups to Give Away Mugs',
            'short_title' => 'Cartoon Panda Panda Mug',
            'slug' => 'cartoon-panda-mug',
            'poster' => '10.png',
            'description' => ' <ul> <li>Purpose: <strong>universal</strong></li><li>Certification: <strong>CIQ</strong></li><li>Material: <strong>Ceramic</strong></li><li>Feature: <strong>Eco-Friendly,Stocked</strong></li><li>Style: <strong>CREATIVE</strong></li><li>Shape: <strong>Handgrip</strong></li></ul>',
            'price' => 42.99,
            'old_price' => 66.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);

        File::copy(public_path('images/products/11.png'), 'storage/app/public/11.png');
        Product::create([
            'category_id' => 1,
            'title' => 'Wooden Cup Retro Big Capacity Tea Water Classic Wood Mug',
            'short_title' => 'Water Classic Wood Mug',
            'slug' => 'wooden-cup-retro-big-capacity-tea-water-classic-wood-mug',
            'poster' => '11.png',
            'description' => '<p>Features: Made of quality wood, healthy and eco-friendly, non-toxic, thick and durable. Has fine workmanship and beautiful texture, a good gift for your friends. The handle is smooth and mellow, comfortable to grip. Large capacity, suitable for tea, beer, water, juice, milk and other drinks. Widely applied to bar, KTV, club, restaurant, hotel and home use. Specifications: Type A: Material: Wood Height: approx.10.8cm/4.25in Diameter:approx.8cm/3.15in Type B: Material: Jujube Color: Shown as picture Size(Dia x H): Approx. 8.6 x 10.9cm / 3.4 x 4.3inch Type C: Material: Wood Diameter: 8cm/3.1inch Height: 11cm/4.3inch Type D: Material: Wood Size: Approx.8.5 * 11cm Capacity: 301-400ml Type E: Material: Kembat Height: Approx. 11cm / 4.3in Diameter: Approx. 8cm / 3.1in Type F: Material: Wood Height: approx. 106mm/4.17in Max. Diameter: 84mm/3.31in Package Included: 1 * Wooden Beer Cup Note: 1. Please allow 0-2cm error due to manual measurement. Thanks for your understanding. 2.The color difference of the wood itself, plus the use of the monitor, will be slightly;different from the real object. Please take the real one as standard.</p>',
            'price' => 62.99,
            'old_price' => 73.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);


        File::copy(public_path('images/products/12.png'), 'storage/app/public/12.png');
        Product::create([
            'category_id' => 1,
            'title' => 'Wesley Bros Coffee Mug Breakfast Mug Cup For Tea Thermal Coffee Cup',
            'short_title' => 'Mug Cup For Tea & Water',
            'slug' => 'wesley-bros-Coffee-Mug-Breakfast-Mug-Cup-For-Tea-Thermal-Coffee-Cup',
            'poster' => '12.png',
            'description' => '<ul><li> Material :<strong>Ceramic</strong></li><li> Weight :<strong>above 0.4kg</strong></li><li> volume :<strong>330ml</strong></li><li> Height:<strong>9.5cm</strong></li><li> Diameter :<strong>8cm</strong></li></ul>',
            'price' => 82.99,
            'old_price' => 113.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);
        

        /**
         * WOMEN;
        */
        File::copy(public_path('images/products/1.png'), 'storage/app/public/1.png');
        Product::create([
            'category_id' => 2,
            'title' => 'Winter Warm Gym Top Activewear Running Coats Workout Clothes Woman',
            'short_title' => 'Winter Warm Gym Top',
            'slug' => 'winter-warm-gym-top-activewear-running-coats-workout-clothes-woman',
            'poster' => '1.png',
            'description' => '<ul><li>Model Number: <strong>yoga jacket</strong></li><li>Fabric Type: <strong>Broadcloth</strong></li><li>Feature: <strong>Anti-Pilling,Compressed,Quick Dry,Windproof</strong></li><li>Sleeve Length(cm): <strong>Full</strong></li><li>Gender: <strong>WOMEN</strong></li><li>Material: <strong>Polyester,Spandex</strong></li><li>Item Type: <strong>Shirts</strong></li><li>Sport Type: <strong>Yoga</strong></li><li>Size: <strong>M</strong></li><li>Color: <strong>Blue</strong></li><li>Season: <strong>Autumn,Winter</strong></li><li>Feature: <strong>Warm,Breathable,Soft,Comfortable</strong></li><li>yoga top: <strong>sports jacket,yoga shirts,gym coat</strong></li></ul>',
            'price' => 89.99,
            'old_price' => 70.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);
        
        File::copy(public_path('images/products/2.png'), 'storage/app/public/2.png');
        Product::create([
            'category_id' => 2,
            'title' => 'Fitness Clothes Short Sleeve Yoga Shirt Gym Women ( M Size )',
            'short_title' => 'Short Sleeve ( M Size )',
            'slug' => 'fitness-clothes-short-sleeve-yoga-shirt-gym-women-m-size',
            'poster' => '2.png',
            'description' => '<ul><li>Model Number: <strong>gym shirt</strong></li><li>Fabric Type: <strong>Broadcloth</strong></li><li>Feature: <strong>anti-wrinkle,Breathable,Anti-Pilling,Anti-Shrink,Quick Dry</strong></li><li>Sleeve Length(cm): <strong>Short</strong></li><li>Gender: <strong>WOMEN</strong></li><li>Material: <strong>nylon,Spandex</strong></li><li>Item Type: <strong>Shirts</strong></li><li>Sport Type:<strong> Yoga</strong></li><li>Size: <strong>M</strong></li><li>Color: <strong>Pink</strong></li><li>Feature: <strong>Breathable,Quick Dry,Anti-Pilling</strong></li><li>Occasion: <strong>Yoga,Fitness,Gym,Running,Training,Workout</strong></li><li>SKU: <strong>SY061</strong></li><li>Yoga Top: <strong>Running Shirt,Yoga Top,Gym Top</strong></li></ul>',
            'price' => 62.99,
            'old_price' => 78.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);

        File::copy(public_path('images/products/3.png'), 'storage/app/public/3.png');
        Product::create([
            'category_id' => 2,
            'title' => 'Woman Blouses 2022 Chiffon Long Sleeve ( M Size )',
            'short_title' => 'Chiffon Long Sleeve ( M Size )',
            'slug' => 'woman-blouses-2022-chiffon-long-sleeve-m-size',
            'poster' => '3.png',
            'description' => '<ul><li>Release Date: <strong>Spring 2022</strong></li><li>Clothing Patterns: <strong>STRAIGHT</strong></li><li>Season: <strong>Autumn/Winter</strong></li><li>Fabric content: <strong>81% (inclusive) - 90% (inclusive)</strong></li><li>Material Composition: <strong>Synthetic fiber</strong></li><li>Closure Type:<strong> Single Breasted</strong></li><li>Age: <strong>25-34</strong></li><li>Thickness: <strong>Midweight</strong></li><li>Shirts Type: <strong>Casual Shirts</strong></li><li>Sleeve Style: <strong>Regular</strong></li><li>Gender: <strong>WOMEN</strong></li><li>Clothing Length: <strong>Regular</strong></li><li>Pattern Type: <strong>striped</strong></li><li>Fabric Type: <strong>Chiffon</strong></li><li>Style: <strong>Office Lady</strong></li><li>Material: <strong>Stretch & Spandex,Spandex</strong></li><li>Decoration: <strong>Button</strong></li><li>Sleeve Length(cm): <strong>Full</strong></li><li>Collar: <strong>Blue</strong></li><li>Fit Type: <strong>Loose Fit</strong></li><li>Elasticity: <strong>Non Strech</strong></li><li>size: <strong>M</strong></li><li>Pattern: <strong>striped</strong></li><li>Collar type: <strong>V-neck</strong></li><li>season: <strong>Autumn 2022</strong></li><li>Sleeve length: <strong>Long sleeves</strong></li></ul>',
            'price' => 34.99,
            'old_price' => 58.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);

        File::copy(public_path('images/products/4.png'), 'storage/app/public/4.png');
        Product::create([
            'category_id' => 2,
            'title' => 'Women Long Sleeve 1/4 Zip Yoga Shirt Top Workout Gym ( M Size )',
            'short_title' => 'Top Workout Gym Women ( M Size )',
            'slug' => 'women-long-sleeve-14-zip-yoga-shirt-top-workout-gym-m-size',
            'description' => '<ul><li>Release Date: <strong>Spring 2022</strong></li><li>Clothing Patterns: <strong>STRAIGHT</strong></li><li>Season: <strong>Autumn/Winter</strong></li><li>Fabric content: <strong>81% (inclusive) - 90% (inclusive)</strong></li><li>Material Composition: <strong>Synthetic fiber</strong></li><li>Closure Type:<strong> Single Breasted</strong></li><li>Age: <strong>25-34</strong></li><li>Thickness: <strong>Midweight</strong></li><li>Shirts Type: <strong>Casual Shirts</strong></li><li>Sleeve Style: <strong>Regular</strong></li><li>Gender: <strong>WOMEN</strong></li><li>Clothing Length: <strong>Regular</strong></li><li>Pattern Type: <strong>striped</strong></li><li>Fabric Type: <strong>Chiffon</strong></li><li>Style: <strong>Office Lady</strong></li><li>Material: <strong>Stretch & Spandex,Spandex</strong></li><li>Decoration: <strong>Button</strong></li><li>Sleeve Length(cm): <strong>Full</strong></li><li>Collar: <strong>Blue</strong></li><li>Fit Type: <strong>Loose Fit</strong></li><li>Elasticity: <strong>Non Strech</strong></li><li>size: <strong>M</strong></li><li>Pattern: <strong>striped</strong></li><li>Collar type: <strong>V-neck</strong></li><li>season: <strong>Autumn 2022</strong></li><li>Sleeve length: <strong>Long sleeves</strong></li></ul>',
            'poster' => '4.png',
            'price' => 20.99,
            'old_price' => 32.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);

        /**
         * MEN;
        */

        File::copy(public_path('images/products/5.png'), 'storage/app/public/5.png');
        Product::create([
            'category_id' => 3,
            'title' => 'Wool Shirt 250g Wicking Breathable Anti-Odor Long Sleeve',
            'short_title' => 'Wool Shirt 250g Wicking Breathable Anti-Odor Long Sleeve',
            'slug' => 'wool-shirt-250g-wicking-breathable-anti-odor-long-sleeve',
            'description' => '<ul><li>Applicable Season:<strong> Four Seasons</strong></li><li>Applicable Scene: <strong>Casual</strong></li><li>Fabric Type: <strong>JERSEY</strong></li><li>Hooded: <strong>No</strong></li><li>Pattern Type: <strong>Solid</strong></li><li>Collar: <strong>O-Neck</strong></li><li>Material: <strong>Wool</strong></li><li>Style: <strong>Casual</strong></li><li>Sleeve Length(cm): <strong>Full</strong></li><li>Gender: <strong>MEN</strong></li><li>Tops Type: <strong>Tees</strong></li><li>Item Type: <strong>Tops</strong></li><li>Fabric: <strong>Merino wool interlock</strong></li><li>Material: <strong>100% merino wool</strong></li></ul>',
            'poster' => '5.png',
            'price' => 49.99,
            'old_price' => 89.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);

        File::copy(public_path('images/products/6.png'), 'storage/app/public/6.png');
        Product::create([
            'category_id' => 3,
            'title' => 'Cotton T-Shirt Men 2022 Sleeve Tops ( M Size )',
            'short_title' => 'Cotton T-Shirt Mens',
            'slug' => 'cotton-t-shirt-men-2022-sleeve-tops-m-size',
            'description' => '<ul><li>Applicable Season: <strong>summer</strong></li><li>Applicable Scene: <strong>Casual</strong></li><li>Decoration: <strong>Button</strong></li><li>Feature: <strong>Breathable</strong></li><li>Size: <strong>Medium</strong>​​​​​​​</li><li>Color Style: <strong>Solid</strong></li><li>Type: <strong>Regular</strong></li><li>Pattern Type: <strong>Solid</strong></li><li>Style: <strong>Casual</strong></li><li>Material: <strong>Cotton</strong></li><li>Sleeve Length(cm): <strong>Short</strong></li><li>Gender: <strong>MEN</strong></li><li>Tops Type: <strong>Polos</strong></li><li>Fabric: <strong>95%Cotton, 5% Spandex</strong></li></ul>',
            'poster' => '6.png',
            'price' => 32.99,
            'old_price' => 44.00,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);

        File::copy(public_path('images/products/7.png'), 'storage/app/public/7.png');
        Product::create([
            'category_id' => 3,
            'title' => 'Casual Simple Long Sleeve Tops Men Clothing ( Black, M Size )',
            'short_title' => 'Black Tops Long Sleeve',
            'slug' => 'casual-simple-long-sleeve-tops-men-clothing-black-m-size',
            'description' => '<ul><li>Applicable Season: <strong>Four Seasons</strong></li><li>Applicable Scene: <strong>Casual</strong></li><li>Decoration: <strong>Button</strong></li><li>Feature: <strong>Breathable</strong></li><li>Color Style: <strong>Solid</strong></li><li>Type: <strong>Regular</strong></li><li>Pattern Type: <strong>Solid</strong></li><li>Style: <strong>Casual</strong></li><li>Material: <strong>Wool Blends</strong></li><li>Sleeve Length(cm): <strong>Full</strong></li><li>Gender: <strong>MEN</strong></li><li>Tops Type: <strong>Polos</strong></li></ul>',
            'poster' => '7.png',
            'price' => 19.99,
            'old_price' => 25.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);

        File::copy(public_path('images/products/8.png'), 'storage/app/public/8.png');
        Product::create([
            'category_id' => 3,
            'title' => 'Long-Sleeved Shirts Summer Solid Color Europe M Size ( Men\'s Tshirt )',
            'short_title' => 'Long-Sleeved Shirts',
            'slug' => 'long-sleeved-shirts-summer-solid-color-europe-m-size-mens-tshirt',
            'description' => '<ul><li>Applicable Season<em>:</em> <strong>Four Seasons</strong></li><li>Applicable Scene: <strong>Daily</strong></li><li>Closure Type: <strong>Covered Button</strong></li><li>Pattern Type: <strong>striped</strong></li><li>Sleeve Style: <strong>Regular</strong></li><li>Model Number: <strong>1</strong></li><li>Fabric Type: <strong>Broadcloth</strong></li><li>Style: <strong>Casual</strong></li><li>Collar: <strong>STAND</strong></li><li>Sleeve Length(cm): <strong>Full</strong></li><li>Material: <strong>Cotton,Linen</strong></li><li>Shirts Type: <strong>Casual Shirts</strong></li><li>Gender: <strong>MEN</strong></li></ul>',
            'poster' => '8.png',
            'price' => 11.99,
            'old_price' => 22.00,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);



    }
}
