<?php

namespace App\Http\Controllers;

use App\Mail\ContactMail;
use App\Models\Category;
use App\Models\Device;
use App\Models\LegalPage;
use App\Models\Order;
use App\Models\Product;
use App\Models\Question;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;

class HomeController extends Controller
{

    public function home() {
        $categories = Category::all()->map(function($category) {
            $category->poster = $category->products->random(1)->first()->poster;
            return $category;
        });
        $questions = Question::whereVisibility(1)->get();
        return view('home')->with(compact('categories', 'questions'));
    }

    public function contactus() {
        return view('contactus');
    }

    public function contactus_send(Request $request) {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'subject' => 'required',
            'message' => 'required',
            'h-captcha-response' => 'required'
        ]);
        if ($validator->fails()) {
            return back()->with('error', 'Message Not Sent!');
        }else {
            Mail::to('contact@ipsubtv.com')->send(new ContactMail($request->message, $request->subject, $request->email));
            return back()->with('success', 'Message Sent Successfully!');
        }
    }

    public function product($slug)
    {
        $product = Product::whereSlug($slug)->whereVisibility(true)->firstOrFail();
        $product->increment('views', 1);
        return view('product')->with(compact('product'));
    }

    public function category($slug)
    {
        $category = Category::whereSlug($slug)->firstOrFail();
        $category->products()->firstOrFail();
        return view('category')->with('category', $category);
    }
    
    public function page($slug) {
        $page = LegalPage::whereSlug($slug)->first();
        if(!$page) abort(404);
        return view('post')->with('post', $page);
    }
}
