<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
   <head>
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta http-equiv="content-type" content="text/html;charset=UTF-8" />
      <meta name="viewport" content="width=device-width,initial-scale=1">
      <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
      <title><?php echo $__env->yieldContent('title'); ?></title>
      <meta name="description" content="Some description for the page"/>
      <link href="/vd/jqvmap/css/jqvmap.min.css" rel="stylesheet" type="text/css"/>
      <link href="/vd/chartist/css/chartist.min.css" rel="stylesheet" type="text/css"/>
      <link href="https://cdn.lineicons.com/2.0/LineIcons.css" rel="stylesheet" type="text/css"/>
      <link href="/flaticon/flaticon.css" rel="stylesheet" type="text/css"/>
      <link href="/font-awesome-old/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
      <link href="/vd/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet" type="text/css"/>
      <link href="https://cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css" rel="stylesheet">
      <link href="/css/style.css?v=<?php echo e(time()); ?>" rel="stylesheet" type="text/css"/>
      <link href="<?php echo e(asset('css/admin.css').'?v='.time()); ?>" rel="stylesheet">
      <link rel="icon" type="image/png" sizes="128x128" href="<?php echo e(asset('storage/'.\App\Models\Config::whereName('favicon')->first()->value)); ?>">
      <script src="/js/jquery.min.js" type="text/javascript"></script>
      <?php echo $__env->yieldContent('extra_css'); ?>
      <style>
ul#menu {
    overflow-y: scroll;
    overflow-x: hidden;
    height: calc( 100vh - 150px );
}

/* width */
ul#menu::-webkit-scrollbar {
  width: 10px;
}

/* Track */
ul#menu::-webkit-scrollbar-track {
  background: #f1f1f1; 
}
 
/* Handle */
ul#menu::-webkit-scrollbar-thumb {
  background: #888; 
}

/* Handle on hover */
ul#menu::-webkit-scrollbar-thumb:hover {
  background: #555; 
}


      </style>
   </head>
   <body>
      <div id="preloader">
         <div class="sk-three-bounce">
            <div class="sk-child sk-bounce1"></div>
            <div class="sk-child sk-bounce2"></div>
            <div class="sk-child sk-bounce3"></div>
         </div>
      </div>
      <div id="main-wrapper">
         <div class="nav-header">
            <a target="_blank" href="<?php echo e(route('home')); ?>" class="brand-logo">
               <img class="mylogo" src="<?php echo e(asset('storage/'.\App\Models\Config::whereName('black_logo')->first()->value)); ?>" alt="">
            </a>
            <div class="nav-control">
               <div class="hamburger">
                  <span class="line"></span><span class="line"></span><span class="line"></span>
               </div>
            </div>
         </div>
         <div class="header">
            <div class="header-content">
               <nav class="navbar navbar-expand">
                  <div class="collapse navbar-collapse justify-content-between">
                     <div class="header-left">
                        <div class="dashboard_bar">
                           <?php echo $__env->yieldContent('title'); ?>
                        </div>
                     </div>
                     <ul class="navbar-nav header-right">
                        <li class="nav-item dropdown notification_dropdown">
                           <a class="nav-link dz-fullscreen" href="#">
                              <svg id="icon-full" viewBox="0 0 24 24" width="26" height="26" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1">
                                 <path d="M8 3H5a2 2 0 0 0-2 2v3m18 0V5a2 2 0 0 0-2-2h-3m0 18h3a2 2 0 0 0 2-2v-3M3 16v3a2 2 0 0 0 2 2h3"></path>
                              </svg>
                              <svg id="icon-minimize" width="26" height="26" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minimize">
                                 <path d="M8 3v3a2 2 0 0 1-2 2H3m18 0h-3a2 2 0 0 1-2-2V3m0 18v-3a2 2 0 0 1 2-2h3M3 16h3a2 2 0 0 1 2 2v3"></path>
                              </svg>
                           </a>
                        </li>
                        <li class="nav-item dropdown header-profile">
                           <a class="nav-link" href="#" role="button" data-toggle="dropdown">
                              <div class="header-info">
                                 <span><?php echo e(Auth::user()->name); ?></span>
                                 <small><?php echo e(Auth::user()->email); ?></small>
                              </div>
                              <img src="<?php echo e(asset('images/avatars/XvV1OLA.webp')); ?>" width="20" alt=""/>
                           </a>
                           <div class="dropdown-menu dropdown-menu-right">
                              <form method="POST" action="<?php echo e(route('logout')); ?>">
                                 <button type="submit" href="#" class="dropdown-item ai-icon">
                                    <?php echo csrf_field(); ?>
                                 <svg id="icon-logout" xmlns="http://www.w3.org/2000/svg" class="text-danger" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path>
                                    <polyline points="16 17 21 12 16 7"></polyline>
                                    <line x1="21" y1="12" x2="9" y2="12"></line>
                                 </svg>
                                 <span class="ml-2">Logout</span>
                                 </button>
                              </form>
                           </div>
                        </li>
                     </ul>
                  </div>
               </nav>
            </div>
         </div>
         <div class="deznav">
            <div class="deznav-scroll">
               <ul class="metismenu" id="menu">
                  <li><a href="<?php echo e(route('admin.dashboard')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">Dashboard</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.orders')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">Orders</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.orders', [ 'fastdelivery' => true ])); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">Prioritized</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.invoices')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">Invoices</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.products')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">Products</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.categories')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">Categories</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.cnumbers')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">Conn Numbers</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.blog_categories')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">Blog Categories</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.posts')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">Posts</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.settings')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">Settings</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.subtypes')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">SubTypes</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.servers')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">Servers</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.homepage_settings')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">HomePage</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.paypal')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">PayPal</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.legal_pages')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">Legal Pages</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.questions')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">FAQ</span>
                     </a>
                  </li>
                  <li><a href="<?php echo e(route('admin.media')); ?>" class="ai-icon" aria-expanded="false">
                     <i class="flaticon-381-settings-2"></i>
                     <span class="nav-text">Media</span>
                     </a>
                  </li>
               </ul>
            </div>
         </div>
         <div class="content-body">
            <div class="container-fluid">
               <?php echo $__env->yieldContent('content'); ?>
            </div>
         </div>
         <div class="footer">

         </div>
      </div>
      <script src="/vd/global/global.min.js" type="text/javascript"></script>
      <script src="/vd/bootstrap-select/dist/js/bootstrap-select.min.js" type="text/javascript"></script>
      <script src="/vd/apexchart/apexchart.js" type="text/javascript"></script>
      <script src="/js/dashboard/dashboard-1.js" type="text/javascript"></script>
      <script src="/js/custom.min.js" type="text/javascript"></script>
      <script src="/js/deznav-init.js" type="text/javascript"></script>
      <script src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
      <script src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap4.min.js"></script>
      <?php echo $__env->yieldContent('extra_js'); ?>
   </body>
</html>
<?php /**PATH /var/www/ipsubtv.com/resources/views/layouts/adminapp.blade.php ENDPATH**/ ?>