<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" xmlns="http://www.w3.org/1999/xhtml" itemscope itemtype="http://schema.org/WebPage">
    <head prefix="og: http://ogp.me/ns# fb: http://ogp.me/ns/fb# article: http://ogp.me/ns/article#">
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" >
        <link rel="profile" href="http://gmpg.org/xfn/11">
        <link rel="shortcut icon" href="<?php echo e(asset('storage/'.\App\Models\Config::whereName('favicon')->first()->value)); ?>">
        <meta name='robots' content='index, follow, max-image-preview:large, max-snippet:-1, max-video-preview:-1' />
        <meta name="format-detection" content="telephone=no">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link rel="canonical" href="<?php echo e(url()->full()); ?>" />
        <meta name="description" content="<?php echo $__env->yieldContent('description'); ?>">
        <title><?php echo $__env->yieldContent('title'); ?></title>
        <meta property="og:site_name" content="<?php echo $__env->yieldContent('title'); ?>">
        <meta property="og:url" content="<?php echo e(url()->full()); ?>">
        <meta property="og:title" content="<?php echo $__env->yieldContent('title'); ?>">
        <meta property="og:type" content="website">
        <meta property="og:description" content="<?php echo $__env->yieldContent('description'); ?>">
        <meta name="twitter:card" content="summary_large_image">
        <meta name="twitter:title" content="<?php echo $__env->yieldContent('title'); ?>">
        <meta name="twitter:description" content="<?php echo $__env->yieldContent('description'); ?>">
        
        <?php
            $disable_tools = \App\Models\Config::whereName('disable_tools')->first()->value
        ?>

        <?php if( $disable_tools == 1 ): ?>
        <style>
            * {
                -webkit-user-select: none; /* Safari */
                -ms-user-select: none; /* IE 10 and IE 11 */
                user-select: none; /* Standard syntax */
            }
        </style>
        <?php endif; ?>

        <?php
        $host = parse_url(env('APP_URL'))['host'];
        ?>
        <script type="application/ld+json">
            {
                "@context":"https://schema.org",
                "@graph":[
                   {
                      "@type":"WebPage",
                      "@id":"<?php echo e(url()->full()); ?>",
                      "url":"<?php echo e(url()->full()); ?>",
                      "name":"<?php echo $__env->yieldContent('title'); ?>",
                      "isPartOf":{
                         "@id":"https://<?php echo e($host); ?>/#website"
                      },
                      "datePublished":"2022-06-26T12:02:19+00:00",
                      "dateModified":"2022-09-04T18:23:07+00:00",
                      "description":"<?php echo $__env->yieldContent('description'); ?>",
                      "breadcrumb":{
                         "@id":"<?php echo e(url()->full()); ?>/#breadcrumb"
                      },
                      "inLanguage":"en-US",
                      "potentialAction":[
                         {
                            "@type":"ReadAction",
                            "target":[
                               "<?php echo e(url()->full()); ?>"
                            ]
                         }
                      ]
                   },
                   {
                      "@type":"BreadcrumbList",
                      "@id":"<?php echo e(url()->full()); ?>/#breadcrumb",
                      "itemListElement":[
                         {
                            "@type":"ListItem",
                            "position":1,
                            "name":"Home",
                            "item":"https://<?php echo e($host); ?>/"
                         },
                         {
                            "@type":"ListItem",
                            "position":2,
                            "name":"Channels"
                         }
                      ]
                   },
                   {
                      "@type":"WebSite",
                      "@id":"https://<?php echo e($host); ?>/#website",
                      "url":"https://<?php echo e($host); ?>/",
                      "name":"<?php echo e(config('app.name')); ?>",
                      "description":"<?php echo e(\App\Models\Config::whereName('seo_description')->first()->value); ?>",
                      "publisher":{
                         "@id":"https://<?php echo e($host); ?>/#organization"
                      },
                      "potentialAction":[
                         {
                            "@type":"SearchAction",
                            "target":{
                               "@type":"EntryPoint",
                               "urlTemplate":"https://<?php echo e($host); ?>/?s={search_term_string}"
                            },
                            "query-input":"required name=search_term_string"
                         }
                      ],
                      "inLanguage":"en-US"
                   },
                   {
                      "@type":"Organization",
                      "@id":"https://<?php echo e($host); ?>/#organization",
                      "name":"<?php echo e(config('app.name')); ?> LTD",
                      "url":"https://<?php echo e($host); ?>/",
                      "logo":{
                         "@type":"ImageObject",
                         "inLanguage":"en-US",
                         "@id":"https://<?php echo e($host); ?>/#/schema/logo/image/",
                         "url":"<?php echo e(asset('storage/'.\App\Models\Config::whereName('black_logo')->first()->value)); ?>",
                         "contentUrl":"<?php echo e(asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)); ?>",
                         "width":300,
                         "height":117,
                         "caption":"<?php echo e(config('app.name')); ?> LTD"
                      },
                      "image":{
                         "@id":"https://<?php echo e($host); ?>/#/schema/logo/image/"
                      }
                   }
                ]
             }
        </script>
        <style>
           <?php if( env('APP_ENV') == 'production' ): ?>
           <?php echo $__env->make('layouts.inc.css.app_min', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
           <?php else: ?>
           <?php echo $__env->make('layouts.inc.css.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
           <?php endif; ?>
           body {
            background : <?php echo e(App\Models\Config::whereName('background_color')->first()->value); ?>

           }
        </style>
        <?php echo $__env->yieldContent('extra_css'); ?>
        <?php if( \App\Models\Config::whereName('gads_tracking_enabled')->first()->value == 1 ): ?>            
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(\App\Models\Config::whereName('gads_tracking_tag')->first()->value); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', "<?php echo e(\App\Models\Config::whereName('gads_tracking_tag')->first()->value); ?>");
        </script>
        <?php endif; ?>
    </head>
    <body>
        <noscript>You must have JavaScript enabled in order to use this order form. Please enable JavaScript and then reload this page in order to continue. </noscript>
        <span id="toTop"><i class="fa fa-arrow-up"></i></span>
        <a id="whatsapp_button" href="<?php echo e(route('wtsp')); ?>" target="_blank"><i class="fa fa-whatsapp"></i><span> Chat With Us </span></a>
        <div id="header">
            <?php if( App\Models\Config::whereName('top_message_allowed')->first()->value == 1 ): ?>
            <div class="top-message">
                <?php echo e(App\Models\Config::whereName('top_message')->first()->value); ?>

            </div>
            <?php endif; ?>
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <a id="logo" class="nav-brand" href="<?php echo e(route('home')); ?>">
                        <img width="110" height="39" alt="<?php echo e(config('app.name').' - '.\App\Models\Config::whereName('website_description')->first()->value); ?>" src="<?php echo e(asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)); ?>">
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"><i class="fa fa-bars" aria-hidden="true"></i></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav top-menu me-auto mb-2 mb-lg-0">
                            <?php
                            $current_route = Route::currentRouteName();
                            ?>
                            <li class="<?php echo e($current_route == 'subscriptions' ? 'active': ''); ?>">
                                <a class="nav-item hvr-underline-from-center" href="<?php echo e(route('subscriptions')); ?>">
                                    subscriptions
                                </a>
                            </li>
                            <li class="<?php echo e($current_route == 'blog' ? 'active': ''); ?>">
                                <a class="nav-item hvr-underline-from-center" href="<?php echo e(route('blog')); ?>">Blog</a>
                            </li>
                            <li><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('blog_category', 'how-to-install')); ?>">how to install</a></li>
                            <li class="<?php echo e($current_route == 'channels_list' ? 'active': ''); ?>">
                                <a class="nav-item hvr-underline-from-center" href="<?php echo e(route('channels_list')); ?>">Channels List</a>
                            </li>
                            <li class="<?php echo e($current_route == 'faq' ? 'active': ''); ?>">
                                <a class="nav-item hvr-underline-from-center" href="<?php echo e(route('faq')); ?>">FAQ</a>
                            </li>
                            <li class="<?php echo e($current_route == 'contactus' ? 'active': ''); ?>"><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('contactus')); ?>">Contact Us</a></li>
                            <?php
                            $reseller = \App\Models\Config::whereName('reseller')->first()->value
                            ?>
                            <?php if( $reseller == 1 ): ?>
                            <li><a class="nav-item hvr-underline-from-center" href="#reseller">RESELLER</a></li>
                            <?php endif; ?>
                        </ul>
                        <div class="top-right-menu">
                            <ul>
                                <?php if( App\Models\Config::whereName('trial_allowed')->first()->value == 1 ): ?>
                                <li>
                                    <div class="cta_btn">
                                        <a class="order_now_cta" href="<?php echo e(route('wtsp').'?text=Please I Wanna Try The Server Before I Buy For '.config('app.url')); ?>">FREE TRIAL</a>
                                     </div>
                                </li>
                                <?php else: ?>
                                <li>
                                    <div class="cta_btn">
                                        <a class="order_now_cta" href="<?php echo e(Route::currentRouteName() == 'home' ? '#subscribe' : route('subscriptions')); ?>"> Order Now </a>
                                     </div>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
        <?php echo $__env->yieldContent('content'); ?>
        <footer>
            <div class="container">
                <div class="row top_s">
                    <div class="about_us col-md-4">
                        <a href="<?php echo e(route('home')); ?>">
                            <img width="90" height="39" alt="<?php echo e(\App\Models\Config::whereName('about_us')->first()->value); ?>" 
                            src="<?php echo e(asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)); ?>">
                        </a>
                        <p><?php echo e(\App\Models\Config::whereName('about_us')->first()->value); ?></p>
                    </div>
                    <div class="col-md-4">
                        <div class="links">
                            <h3>Blog / Resources</h3>
                            <a href="<?php echo e(route('channels_list')); ?>" class="<?php echo e($current_route == 'channels_list' ? 'active': ''); ?>">channels list</a>
                            <a href="<?php echo e(route('subscriptions')); ?>" class="<?php echo e($current_route == 'subscriptions' ? 'active': ''); ?>">subscriptions</a>
                            <a href="<?php echo e(route('faq')); ?>" class="<?php echo e($current_route == 'faq' ? 'active': ''); ?>">Frequently Asked Questions</a>
                            <a href="<?php echo e(route('blog')); ?>" class="<?php echo e($current_route == 'blog' ? 'active': ''); ?>">blog</a>
                            <a href="<?php echo e(route('blog_category', 'how-to-install')); ?>">how to install</a>
                            <?php if( $reseller == 1 ): ?>
                            <a class="nav-item hvr-underline-from-center" href="#reseller">RESELLER</a>
                            <?php endif; ?>
                            <a href="<?php echo e(route('contactus')); ?>" class="<?php echo e($current_route == 'contactus' ? 'active': ''); ?>">contact us</a>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="links">
                            <h3>pages</h3>
                            <?php $__currentLoopData = \App\Models\LegalPage::whereVisibility(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('page', $page->slug)); ?>"><?php echo e($page->title); ?></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="_footer">
                <span>
                    All Rights Are Reserved To <span class="colored"><?php echo e(config('app.name')); ?></span> <i class="fa fa-copyright" aria-hidden="true"></i> <?php echo e(\Carbon\Carbon::now()->year); ?>

                </span>
                <img width="200" height="33" src="<?php echo e(asset('images/cards.webp')); ?>" alt="payment gateways">
            </div>
        </footer>
        <?php if( \App\Models\Config::whereName('gtag')->first()->value ): ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(\App\Models\Config::whereName('gtag')->first()->value); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', "<?php echo e(\App\Models\Config::whereName('gtag')->first()->value); ?>");
        </script>
        <?php endif; ?>
        <script>
        <?php if( env('APP_ENV') == 'production'): ?>
        <?php echo $__env->make('layouts.inc.js.app_min', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php else: ?>
        <?php echo $__env->make('layouts.inc.js.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <?php if( $disable_tools == 1 ): ?>
        <?php echo $__env->make('layouts.inc.js.disable_tools_min', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        </script>
        <?php echo $__env->yieldContent('extra_js'); ?>
        
    </body>
</html><?php /**PATH /var/www/ipsubtv.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>