<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <title>Redirection ...</title>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;700&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css" integrity="sha512-SzlrxWUlpfuzQ+pcUCosxcglQRNAq/DZjVsC0lE40xsADsfeQoEypE+enwcOiGjk/bSuGGKHEyjSoQ1zVisanQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
* { font-family: 'Poppins', sans-serif; }
body {
    margin: 0;
}
div#redirection {
    text-align: center;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    background: #eee;
}
div#box p {
    margin: 0;
    margin-bottom: 11px;
    font-size: 15px;
    text-transform: capitalize;
    font-weight: 500;
    color: #726e6e;
}
div#box a#pay_now {
    background: green;
    color: white;
    text-transform: uppercase;
    font-weight: 600;
    text-decoration: none;
    font-size: 16px;
    padding: 5px 8px;
    border-radius: 11px;
    display: inline-block;
}
</style>
    </head>
    <body>
        <div id="redirection">
            <div id="box">
                @if($paid)
                <i style="color: green" class="fa fa-check-square fa-3x fa-fw"></i>
                <h2>Invoice Already Paid</h2>
                <h2>Redirection To Home Page Within <span id="countdowntimer"></span> seconds ...</h2>
                @else
                <i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i>
                <h2>Redirection To Payment Page Within <span id="countdowntimer"></span> seconds ...</h2>
                @endif
                <p>click here if you don't wanna wait</p>
                <a href="{{$url}}" id="pay_now">{{ $paid ? 'Go To Homepage' : 'Redirect Now' }}</a>
            </div>
        </div>
        <script>
            var timeleft = {{ $paid ? 4 : 3 }};
            document.getElementById("countdowntimer").textContent = timeleft;
            var downloadTimer = setInterval(function(){
            timeleft--;
            document.getElementById("countdowntimer").textContent = timeleft;
            if(timeleft <= 0)
                clearInterval(downloadTimer);
            },1000);            
            setTimeout(() => {
                window.location.href = '{{$url}}'
            }, timeleft*1000);
        </script>
    </body>
</html>