@extends('layouts.app')
@section('title', 'Order Received')
@section('content')
<div id="order_received">
   <div class="container">
      <span class="header_title">Order Received</span>
      <p class="header_p">Thank you, You order has been received. <br/> ( We will email you with all subscription details within some hours [ From 1 minute to 6 hours Maximum] )</p>

      <div class="details">
         <div class="item">
            <span class="title">order number</span>
            <p class="value">#{{$order->id}}</p>
         </div>
   
         <div class="item">
            <span class="title">payment Method</span>
            <p class="value">{{ str_contains(strtolower($order->gateway), 'stripe') ? 'Credit / Debit Card' : 'PayPal'}}</p>
         </div>

         <div class="item">
            <span class="title">service</span>
            <p class="value">{{$order->product->short_title}}</p>
         </div>

         <div class="item">
            <span class="title">email</span>
            <p class="value">{{$order->billing_email}}</p>
         </div>

         <div class="item">
            <span class="title">total</span>
            <p class="value">{{$order->total}} {{$order->currency->code}}</p>
         </div>
      </div>
      <a href="{{route('home')}}" class="homepage">homepage</a>
   </div>   
</div>
@endsection
@section('extra_css')
<style>
</style>
@endsection
@section('extra_js')
@if ( \App\Models\Config::whereName('gads_tracking_enabled')->first()->value == 1)
<script>
   gtag('event', 'conversion', {
       'send_to': '{{\App\Models\Config::whereName("gads_conversion_id")->first()->value }}',
       'value': {{$order->total}},
       'currency': '{{$currency->code}}',
       'transaction_id': '{{$order->ppl_transaction_id}}'
   });
 </script>
@endif
@endsection