<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" xmlns="http://www.w3.org/1999/xhtml" itemscope itemtype="http://schema.org/WebPage">
    <head prefix="og: http://ogp.me/ns# fb: http://ogp.me/ns/fb# article: http://ogp.me/ns/article#">
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" >
        <link rel="profile" href="http://gmpg.org/xfn/11">
        <link rel="shortcut icon" href="{{asset('storage/'.\App\Models\Config::whereName('favicon')->first()->value)}}">
        <meta name='robots' content='index, follow, max-image-preview:large, max-snippet:-1, max-video-preview:-1' />
        <meta name="format-detection" content="telephone=no">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link rel="canonical" href="{{url()->full()}}" />
        <meta name="description" content="@yield('description')">
        <title>@yield('title')</title>
        <meta property="og:site_name" content="@yield('title')">
        <meta property="og:url" content="{{url()->full()}}">
        <meta property="og:title" content="@yield('title')">
        <meta property="og:type" content="website">
        <meta property="og:description" content="@yield('description')">
        <meta name="twitter:card" content="summary_large_image">
        <meta name="twitter:title" content="@yield('title')">
        <meta name="twitter:description" content="@yield('description')">
        
        @php
            $disable_tools = \App\Models\Config::whereName('disable_tools')->first()->value
        @endphp

        @if( $disable_tools == 1 )
        <style>
            * {
                -webkit-user-select: none; /* Safari */
                -ms-user-select: none; /* IE 10 and IE 11 */
                user-select: none; /* Standard syntax */
            }
        </style>
        @endif

        @php
        $host = parse_url(env('APP_URL'))['host'];
        @endphp
        <script type="application/ld+json">
            {
                "@context":"https://schema.org",
                "@graph":[
                   {
                      "@type":"WebPage",
                      "@id":"{{url()->full()}}",
                      "url":"{{url()->full()}}",
                      "name":"@yield('title')",
                      "isPartOf":{
                         "@id":"https://{{$host}}/#website"
                      },
                      "datePublished":"2022-06-26T12:02:19+00:00",
                      "dateModified":"2022-09-04T18:23:07+00:00",
                      "description":"@yield('description')",
                      "breadcrumb":{
                         "@id":"{{url()->full()}}/#breadcrumb"
                      },
                      "inLanguage":"en-US",
                      "potentialAction":[
                         {
                            "@type":"ReadAction",
                            "target":[
                               "{{url()->full()}}"
                            ]
                         }
                      ]
                   },
                   {
                      "@type":"BreadcrumbList",
                      "@id":"{{url()->full()}}/#breadcrumb",
                      "itemListElement":[
                         {
                            "@type":"ListItem",
                            "position":1,
                            "name":"Home",
                            "item":"https://{{$host}}/"
                         },
                         {
                            "@type":"ListItem",
                            "position":2,
                            "name":"Channels"
                         }
                      ]
                   },
                   {
                      "@type":"WebSite",
                      "@id":"https://{{$host}}/#website",
                      "url":"https://{{$host}}/",
                      "name":"{{config('app.name')}}",
                      "description":"{{\App\Models\Config::whereName('seo_description')->first()->value}}",
                      "publisher":{
                         "@id":"https://{{$host}}/#organization"
                      },
                      "potentialAction":[
                         {
                            "@type":"SearchAction",
                            "target":{
                               "@type":"EntryPoint",
                               "urlTemplate":"https://{{$host}}/?s={search_term_string}"
                            },
                            "query-input":"required name=search_term_string"
                         }
                      ],
                      "inLanguage":"en-US"
                   },
                   {
                      "@type":"Organization",
                      "@id":"https://{{$host}}/#organization",
                      "name":"{{config('app.name')}} LTD",
                      "url":"https://{{$host}}/",
                      "logo":{
                         "@type":"ImageObject",
                         "inLanguage":"en-US",
                         "@id":"https://{{$host}}/#/schema/logo/image/",
                         "url":"{{asset('storage/'.\App\Models\Config::whereName('black_logo')->first()->value)}}",
                         "contentUrl":"{{asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)}}",
                         "width":300,
                         "height":117,
                         "caption":"{{config('app.name')}} LTD"
                      },
                      "image":{
                         "@id":"https://{{$host}}/#/schema/logo/image/"
                      }
                   }
                ]
             }
        </script>
        <style>
           @if( env('APP_ENV') == 'production' )
           @include('layouts.inc.css.app_min')
           @else
           @include('layouts.inc.css.app')
           @endif
           body {
            background : {{ App\Models\Config::whereName('background_color')->first()->value }}
           }
        </style>
        @yield('extra_css')
        @if ( \App\Models\Config::whereName('gads_tracking_enabled')->first()->value == 1 )            
        <script async src="https://www.googletagmanager.com/gtag/js?id={{\App\Models\Config::whereName('gads_tracking_tag')->first()->value}}"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', "{{\App\Models\Config::whereName('gads_tracking_tag')->first()->value}}");
        </script>
        @endif
    </head>
    <body>
        <noscript>You must have JavaScript enabled in order to use this order form. Please enable JavaScript and then reload this page in order to continue. </noscript>
        <span id="toTop"><i class="fa fa-arrow-up"></i></span>
        <a id="whatsapp_button" href="{{route('wtsp')}}" target="_blank"><i class="fa fa-whatsapp"></i><span> Chat With Us </span></a>
        <div id="header">
            @if( App\Models\Config::whereName('top_message_allowed')->first()->value == 1 )
            <div class="top-message">
                {{App\Models\Config::whereName('top_message')->first()->value}}
            </div>
            @endif
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <a id="logo" class="nav-brand" href="{{route('home')}}">
                        <img width="110" height="39" alt="{{config('app.name').' - '.\App\Models\Config::whereName('website_description')->first()->value}}" src="{{asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)}}">
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"><i class="fa fa-bars" aria-hidden="true"></i></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav top-menu me-auto mb-2 mb-lg-0">
                            @php
                            $current_route = Route::currentRouteName();
                            @endphp
                            <li class="{{ $current_route == 'subscriptions' ? 'active': ''}}">
                                <a class="nav-item hvr-underline-from-center" href="{{route('subscriptions')}}">
                                    subscriptions
                                </a>
                            </li>
                            <li class="{{ $current_route == 'blog' ? 'active': ''}}">
                                <a class="nav-item hvr-underline-from-center" href="{{route('blog')}}">Blog</a>
                            </li>
                            <li><a class="nav-item hvr-underline-from-center" href="{{route('blog_category', 'how-to-install')}}">how to install</a></li>
                            <li class="{{ $current_route == 'channels_list' ? 'active': ''}}">
                                <a class="nav-item hvr-underline-from-center" href="{{route('channels_list')}}">Channels List</a>
                            </li>
                            <li class="{{ $current_route == 'faq' ? 'active': ''}}">
                                <a class="nav-item hvr-underline-from-center" href="{{route('faq')}}">FAQ</a>
                            </li>
                            <li class="{{ $current_route == 'contactus' ? 'active': ''}}"><a class="nav-item hvr-underline-from-center" href="{{route('contactus')}}">Contact Us</a></li>
                            @php
                            $reseller = \App\Models\Config::whereName('reseller')->first()->value
                            @endphp
                            @if( $reseller == 1 )
                            <li><a class="nav-item hvr-underline-from-center" href="#reseller">RESELLER</a></li>
                            @endif
                        </ul>
                        <div class="top-right-menu">
                            <ul>
                                @if ( App\Models\Config::whereName('trial_allowed')->first()->value == 1 )
                                <li>
                                    <div class="cta_btn">
                                        <a class="order_now_cta" href="{{route('wtsp').'?text=Please I Wanna Try The Server Before I Buy For '.config('app.url')}}">FREE TRIAL</a>
                                     </div>
                                </li>
                                @else
                                <li>
                                    <div class="cta_btn">
                                        <a class="order_now_cta" href="{{Route::currentRouteName() == 'home' ? '#subscribe' : route('subscriptions')}}"> Order Now </a>
                                     </div>
                                </li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
        @yield('content')
        <footer>
            <div class="container">
                <div class="row top_s">
                    <div class="about_us col-md-4">
                        <a href="{{route('home')}}">
                            <img width="90" height="39" alt="{{\App\Models\Config::whereName('about_us')->first()->value}}" 
                            src="{{asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)}}">
                        </a>
                        <p>{{\App\Models\Config::whereName('about_us')->first()->value}}</p>
                    </div>
                    <div class="col-md-4">
                        <div class="links">
                            <h3>Blog / Resources</h3>
                            <a href="{{route('channels_list')}}" class="{{ $current_route == 'channels_list' ? 'active': ''}}">channels list</a>
                            <a href="{{route('subscriptions')}}" class="{{ $current_route == 'subscriptions' ? 'active': ''}}">subscriptions</a>
                            <a href="{{route('faq')}}" class="{{ $current_route == 'faq' ? 'active': ''}}">Frequently Asked Questions</a>
                            <a href="{{route('blog')}}" class="{{ $current_route == 'blog' ? 'active': ''}}">blog</a>
                            <a href="{{route('blog_category', 'how-to-install')}}">how to install</a>
                            @if( $reseller == 1 )
                            <a class="nav-item hvr-underline-from-center" href="#reseller">RESELLER</a>
                            @endif
                            <a href="{{route('contactus')}}" class="{{ $current_route == 'contactus' ? 'active': ''}}">contact us</a>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="links">
                            <h3>pages</h3>
                            @foreach (\App\Models\LegalPage::whereVisibility(1)->get() as $page)
                            <a href="{{route('page', $page->slug)}}">{{$page->title}}</a>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            <div class="_footer">
                <span>
                    All Rights Are Reserved To <span class="colored">{{ config('app.name') }}</span> <i class="fa fa-copyright" aria-hidden="true"></i> {{\Carbon\Carbon::now()->year}}
                </span>
                <img width="200" height="33" src="{{asset('images/cards.webp')}}" alt="payment gateways">
            </div>
        </footer>
        @if( \App\Models\Config::whereName('gtag')->first()->value )
        <script async src="https://www.googletagmanager.com/gtag/js?id={{\App\Models\Config::whereName('gtag')->first()->value}}"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', "{{\App\Models\Config::whereName('gtag')->first()->value}}");
        </script>
        @endif
        <script>
        @if( env('APP_ENV') == 'production')
        @include('layouts.inc.js.app_min')
        @else
        @include('layouts.inc.js.app')
        @endif

        @if( $disable_tools == 1 )
        @include('layouts.inc.js.disable_tools_min')
        @endif
        </script>
        @yield('extra_js')
        
    </body>
</html>